// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * ExecuteMacro.java
 *
 * Created on February 7, 2002, 2:36 PM
 */

//import ComSwitchboard;
import javax.swing.text.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class MacroHandler {
    
    Arachnophilia main;
    
    /** Creates new ExecuteMacro */
    public MacroHandler(Arachnophilia m) {
        main = m;
    }
    
    public void executeCommand(String s) {
        ArachDocument doc = null;
        if(main.currentSelectedDocument != null) {
            doc = main.currentSelectedDocument;
        }
        // first, carry our embedded commands
        s = main.comSwitchboard.exec(s,0);
        // did the command close our document?
        if(doc == null || s.length() == 0) {
            if( doc != null && main.haveFocus) {
                //doc.textComp.rfiw();
            }
            return;
        }
        //second, find and insert selected text
        
        MySyntaxTextArea text = doc.textComp;
        int cp = text.getCaretPosition();
        boolean isEscapedCaret = false;
        int p = s.indexOf("|");
        //System.out.println("|: " + p);
        if(p != -1 && p < s.length() -1) {
            isEscapedCaret = (p > 0 && s.charAt(p-1) == '\\');
            if(isEscapedCaret) {
                // delete the escape character
                s = s.substring(0,p-1) + s.substring(p);
            }
            else {
                // delete the caret mark
                s = s.substring(0,p) + s.substring(p+1);
            }
        }
        int a = text.getSelectionStart();
        int b = text.getSelectionEnd();
        boolean caretAtBeginning = text.getCaretPosition() == a;
        String selection = text.getSelectedText();
        if(selection == null) {
            //System.out.println("sel = null");
            selection = "";
        }
        
        doc.undoPush();
        if(p != -1 && !isEscapedCaret) { // overwrite
            text.replaceSelection(s);
            int ra = b-selection.length();
            int rb = a+p;
            text.setSelectionStart(rb);
            
            text.setSelectionEnd(rb);
            text.replaceSelection(selection);
            b = text.getSelectionEnd();
            text.setSelectionStart(ra);
            if(caretAtBeginning) {
                text.setCaretPosition(b);
                text.moveCaretPosition(rb);
            }
            else {
                text.setCaretPosition(rb);
                text.moveCaretPosition(b);
            }
        }
        else { // do not overwrite
            text.setSelectionEnd(a);
            text.replaceSelection(s);
            int ra = a + selection.length() + s.length();
            int rb = b + s.length();
            text.setSelectionStart(ra);
            text.setSelectionEnd(rb);
            if(caretAtBeginning) {
                text.setCaretPosition(rb);
                text.moveCaretPosition(ra);
            }
            else {
                text.setCaretPosition(ra);
                text.moveCaretPosition(rb);
            }
        }
        Caret car = text.getCaret();
        if(car != null) {
            car.setSelectionVisible(true);
        }
        if(main.haveFocus) {
            text.rfiw();
        }
        //System.out.println(text.getSelectionStart() + "," + text.getSelectionEnd());
        //String
    }
}
