// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;



/*
 * MyJButton.java
 *
 * Created on November 24, 2001, 1:38 PM
 */

// This MyJButton is way superior to the old.
// It allows JButtons to have their natural size
// as well as offering the raised-on-entry feature

import javax.swing.*;
import javax.swing.tree.*;

public final class MyJButton extends JButton {
    
    private Arachnophilia main = null;
    public DefaultMutableTreeNode node = null;
    
    //Border activeBorder;
    //Border passiveBorder;
    /** Creates new MyJButton */
    
    public MyJButton() {
        super();
        myInit(null);
    }
    public MyJButton(Arachnophilia m) {
        super();
        myInit(m);
    }
    
    public MyJButton(Arachnophilia m,DefaultMutableTreeNode n) {
        super();
        node = n;
        //System.out.println("at button: " + n);
        myInit(m);
    }
    
    public MyJButton(Arachnophilia m,Icon i) {
        super(i);
        myInit(m);
    }
    
    public MyJButton(Icon i) {
        super(i);
        myInit(null);
    }
    
    public MyJButton(Arachnophilia m,String s) {
        super(s);
        myInit(m);
    }
    
    public MyJButton(Arachnophilia m,String s,Icon i) {
        super(s,i);
        myInit(m);
    }

    // disabled "special" button behavior
    // 02/08/2009
    
   private void myInit(Arachnophilia m) {
        main = m;
        setFocusable(false);
        //activeBorder = new BevelBorder(BevelBorder.RAISED);
        //passiveBorder = getBorder();
        addMouseListener(new java.awt.event.MouseAdapter() {
            /*
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                formMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                formMouseExited(evt);
            }*/
            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                handleMouse(evt);
            }
            @Override
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                handleMouse(evt);
            }
        });
    }
    /*
    private Insets getDiffInsets(Insets b) {
        Insets a = getInsets();
        return new Insets(a.top-b.top,a.left-b.left,a.bottom-b.bottom,a.right-b.right);
    }
    
    private void formMouseEntered(java.awt.event.MouseEvent evt) {
        if(isEnabled()) {
            Insets in = getDiffInsets(activeBorder.getBorderInsets(this));
            super.setBorder(new CompoundBorder(activeBorder,new EmptyBorder(in)));
        }
    }
    
    private void formMouseExited(java.awt.event.MouseEvent evt) {
            Insets in = getDiffInsets(passiveBorder.getBorderInsets(this));
            super.setBorder(new CompoundBorder(passiveBorder,new EmptyBorder(in)));
    }*/
    
    private void handleMouse(java.awt.event.MouseEvent evt) {
        //System.out.println("MyJButton1: ");
        if(main != null) {
            //System.out.println("MyJButton2: ");
            JPopupMenu pop = main.getMacroPanel().getButtonMenu(node);
            //System.out.println("MyJButton3: " + node);
            if(pop.isPopupTrigger(evt)) {
                //System.out.println("MyJButton4: ");
                evt.consume();
                pop.show(this,evt.getX(),evt.getY());
            }
        }
    }
}
