// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * RightClickProcessor.java
 *
 * Created on February 17, 2002, 8:31 AM
 */
import FilePicker.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author Administrator
 * @version
 */
final public class RightClickProcessor {

    Arachnophilia main;
    int line;
    int lineStartOffset;
    int lineEndOffset;
    String documentLine;
    SearchReplace srch;
    ArrayList<String> windowVals = null;
    //String dataPath;

    /**
     * Creates new RightClickProcessor
     */
    public RightClickProcessor(Arachnophilia m) {
        main = m;
        srch = new SearchReplace();
        StringBuilder dataPath = new StringBuilder();
        dataPath.append(main.basePath).append(ArachConstants.SYSTEM_FILESEP).append(Arachnophilia.dataDirName).append(ArachConstants.SYSTEM_FILESEP).append("CtrlRightClickList.txt");
        windowVals = ArachComp.loadDataArrayList(dataPath.toString());
    }

    public boolean processRightClickEvent(MouseEvent evt, ArachDocument doc) {
        // show shift - right-click list
        if ((evt.getModifiers() & InputEvent.CTRL_MASK) != 0) {
            //evt.consume();
            Point p = ((Component) evt.getSource()).getLocationOnScreen();
            int x = p.x + evt.getX();
            int y = p.y + evt.getY();
            //JOptionPane.showMessageDialog(doc,"test");
            ContentFloatingWindow contentFloatingWindow = new ContentFloatingWindow(windowVals, new Point(x, y), main);
            return true;
        } else {
            // 12/2008:
            // don't test for filetype any more
            // too many files have HTML style content now
            //if (!doc.isHTMLDocument) {
            //    return false;
            //}
            int pos = doc.textComp.getCaretPosition();
            Bundle docb = getDocumentLine(doc);
            documentLine = docb.s;
            Bundle field = getDocumentField(docb);
            if (field == null) {
                return false;
            }
            Bundle colorField = getColorField(field);

            // is this a color field?
            if (colorField != null && colorField.s.length() == 6) {
                //System.out.println(colorField.s + "," + colorField.a + "," + colorField.b);
                colorField.s =
                        new DocumentProcessingFunctions(main).launchColorSelectorDialog(colorField.s);
                //System.out.println(result + "," + colorField.a + "," + colorField.b);
                replaceSelection(doc, pos, colorField, true);
                return true;
            } else { // test for a file
                int type;
                if (testForLinkArgument(field)) {
                    return false;
                }
                if ((type = main.fileTypes.getValidFileType(field.s)) == -1) {
                    // test for unknown, apparently valid file name
                    int len = field.s.length();
                    if (len > 3) {
                        int p = field.s.lastIndexOf('.');
                        if (p < len - 1 && p > 0) {
                            if (Character.isLetter(field.s.charAt(p + 1)) && Character.isLetter(field.s.charAt(p - 1))) {
                                type = main.fileTypes.getFileTypeForName("All");
                                //System.out.println(type);
                            }
                        }
                    }

                }
                if (type != -1) {
                    boolean isGraphic = (type == main.fileTypes.getFileTypeForName("Graphic"));
                    File f = promptDoc(doc, type, isGraphic);
                    if (f != null && main.currentSelectedDocument != null) {
                        File f_to = new File(main.currentSelectedDocument.getFullPath());
                        String from = f.getPath();
                        String to = f_to.getPath();
                        //System.out.println("creating relative path ...");
                        field.s = ArachComp.createRelativePath(from, to);
                        //System.out.println(from + "\n" + to + "\n" + field.s);
                        replaceSelection(doc, pos, field, true);
                        //System.out.println("b");
                        if (isGraphic) {
                            sizeGraphicTagsInLine(doc, pos);
                            //System.out.println("c");
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void sizeGraphicTagsInLine(ArachDocument doc, int pos) {
        Bundle docLine = getDocumentLine(doc);
        String s = docLine.s;
        int len = s.length();
        s = sizeAllGraphicTagsInString(doc, s);
        replaceSelection(doc, pos, new Bundle(s, 0, len - 1, pos), true);
    }

    public String sizeAllGraphicTagsInString(ArachDocument doc, String data) {
        int index = 0;
        Bundle field = new Bundle(data, 0, 0, 0);
        while ((index = sizeGraphic(doc, field, index)) != -1) {
        }
        return field.s;
    }

    // resize a graphic tag in the current document line
    private int sizeGraphic(ArachDocument doc, Bundle field, int index) {

        String targetTag = "<img";
        int startPos = findLC(field.s, targetTag, index);
        if (startPos != -1) {
            int endPos = field.s.indexOf("/>", startPos);
            if (endPos == -1) {
                endPos = field.s.indexOf(">", startPos);
            }
            if (endPos != -1) {
                index = endPos + 1;
                //System.out.println(startPos + "," + endPos);
                String target = field.s.substring(startPos, endPos);
                //System.out.println("target: " + target);
                //System.out.println("[" + target + "]");
                String path = getValueForArg(target, "src");
                path = doc.getPath() + "/" + path;
                //System.out.println(path);
                File f = new File(path);
                ImageIcon image = new ImageIcon(f.getPath());
                int width = image.getImage().getWidth(null);
                int height = image.getImage().getHeight(null);
                if (width != -1 && height != -1) {
                    target = replaceTag(target, "width", "width=\"" + width + "\"");
                    target = replaceTag(target, "height", "height=\"" + height + "\"");
                }
                //System.out.println(target);
                StringBuilder sb = new StringBuilder();
                sb.append(field.s.substring(0, startPos));
                sb.append(target);
                sb.append(field.s.substring(endPos));
                field.s = sb.toString();
            } else {
                index = -1;
            }
        } else {
            index = -1;
        }
        return index;
    }

    private int findLC(String data, String find, int index) {
        boolean found = false;
        int flen = find.length();
        int len = data.length() - flen;
        for (int i = index; i < len; i++) {
            if (data.substring(i, i + flen).equalsIgnoreCase(find)) {
                return i;
            }
        }
        return -1;
    }

    private String getValueForArg(String data, String tag) {
        boolean inQuotes = false;
        boolean found = false;
        String value = "";
        tag += "=";
        String lcData = data.toLowerCase();
        int i = 0;
        int len = data.length();
        int p = lcData.indexOf(tag);
        if (p != -1) {
            p = p + tag.length();
            i = p;
            while (i < len) {
                char c = data.charAt(i);
                if (c == '"') {
                    inQuotes = !inQuotes;
                } else if (!inQuotes) {
                    if (Character.isWhitespace(c) || c == '>') {
                        found = true;
                        break;
                    }
                }
                i++;
            }
        }
        if (p != -1 && (found || i == len)) {
            value = data.substring(p, i);
            value = srch.srchRplc(value, "\"", "");
        }
        return value;
    }

    private String replaceTag(String data, String tag, String replacement) {
        boolean inQuotes = false;
        boolean found = false;
        tag += "=";
        String lcData = data.toLowerCase();
        int i = 0;
        int len = data.length();
        int p = lcData.lastIndexOf(tag);
        if (p != -1) {
            i = p + tag.length();
            while (i < len) {
                char c = data.charAt(i);
                if (c == '"') {
                    inQuotes = !inQuotes;
                } else if (!inQuotes) {
                    if (Character.isWhitespace(c)) {
                        found = true;
                        break;
                    }
                }
                i++;
            }
        }
        if (p != -1 && (found || i == len)) {
            data = data.substring(0, p) + replacement + data.substring(i);
        } else {
            data += ' ' + replacement;
        }
        return data;
    }

    private boolean testForLinkArgument(Bundle field) {
        // if an internet URL
        return (field.s.indexOf("://") != -1);

    }

    private Bundle getDocumentField(Bundle field) {
        int len = field.s.length();
        int pos = field.pos - field.a;
        // bump down from invalid char
        if (pos > 0 && pos < len) {
            char c = field.s.charAt(pos);
            if (c == ':' || c == '=' || c == ' ' || c == '\"' || c == '\n') {
                pos--;
            }
        }
        int a = pos;
        int b = pos;
        while (a >= 0 && a < len) {
            char c = field.s.charAt(a);
            if (c == '<' || c == '>') {
                return null;
            }
            if (c == '=' || c == ':') {
                if (a < pos) {
                    a++;
                }
                break;
            }
            a--;
        }
        if (a < 0) {
            return null;
        }
        while (a < len) {
            char c = field.s.charAt(a);
            if (c != ' ' && c != '\"') {
                break;
            }
            a++;
        }
        if (a >= len) {
            return null;
        }
        while (b >= 0 && b < len) {
            char c = field.s.charAt(b);
            if (c == ' ' || c == '}' || c == '\"' || c == '>' || c == '\n') {
                if (b > pos) {
                    b--;
                }
                break;
            }
            b++;
        }
        if (b >= len) {
            return null;
        }
        if (a >= 0 && a < len && b >= 0 && b < len && b > a) {
            String s = field.s.substring(a, b + 1);
            return new Bundle(s, field.a + a, field.a + b, field.pos);
        } else {
            return null;
        }
    }

    private Bundle getColorField(Bundle field) {
        int len = field.s.length();
        int pos = field.pos - field.a;
        // bump up or down from invalid char
        if (pos >= 0 && pos <= len) {
            if (pos > 0 && pos >= len) {
                pos--;
            } else {
                char c = field.s.charAt(pos);
                if (c == '#') {
                    if (pos < len - 1) {
                        pos++;
                    }
                } else if (!ArachComp.isHexDigit(c)) {
                    if (pos > 0) {
                        pos--;
                    }
                }
            }
        }
        int a = pos;
        int b = pos;
        while (a >= 0 && a < len) {
            char c = field.s.charAt(a);
            if (!ArachComp.isHexDigit(c)) {
                if (a < pos) {
                    a++;
                }
                break;
            }
            a--;
        }
        if (a < 0) {
            a++;
        }
        while (b >= 0 && b < len) {
            char c = field.s.charAt(b);
            if (!ArachComp.isHexDigit(c)) {
                if (b > pos) {
                    b--;
                }
                break;
            }
            b++;
        }
        if (b >= len) {
            b--;
        }
        //System.out.println(pos + "," + a + "," + b);
        if (a >= 0 && a < len && b >= 0 && b < len && b > a) {
            String s = field.s.substring(a, b + 1);
            return new Bundle(s, field.a + a, field.a + b, field.pos);
        } else {
            return null;
        }
    }
    /*
     private Bundle getColorField(Bundle field) {
     if(field == null) {
     return null;
     }
     // set caret position
     int i = field.b - field.a;
     int j = i;
     int len = field.s.length();
     i++;
     while(i > 0 && i <= len && !ArachComp.isHexDigit(field.s.charAt(i-1)))
     i--;
     int a = i;
     while(j >= -1 && j < len-1 && ArachComp.isHexDigit(field.s.charAt(j+1)))
     j++;
     int b = j;
     //System.out.println(a + "," + b + "," + field.s.length());
     Bundle result = new Bundle(field.s.substring(a,b),field.a + a,field.a + b);
     return result;
     }*/

    private Bundle getDocumentLine(ArachDocument doc) {
        Bundle field = new Bundle();
        int pos = doc.textComp.getCaretPosition();
        line = doc.textComp.getCaretLine();
        lineStartOffset = doc.textComp.getLineStartOffset(line);
        lineEndOffset = lineStartOffset;
        try {
            lineEndOffset = doc.textComp.getLineEndOffset(line);
        } catch (javax.swing.text.BadLocationException e) {
            e.printStackTrace(System.out);
            return null;
        }
        field.s = doc.textComp.getText(lineStartOffset, lineEndOffset - lineStartOffset);
        field.a = 0;
        field.b = lineEndOffset - lineStartOffset;
        field.pos = pos - lineStartOffset;
        //System.out.println("doc line: [" + result + "] " + result.length());
        return field;
    }

    private void replaceSelection(ArachDocument doc, int caretPos, Bundle field, boolean replace) {
        doc.undoPush();
        doc.textComp.setCaretPosition(lineStartOffset + field.a);
        doc.textComp.moveCaretPosition(lineStartOffset + field.b + 1);
        if (replace) {
            doc.textComp.replaceSelection(field.s);
            doc.textComp.setCaretPosition(caretPos);
        }
    }

    class Bundle {

        public String s = "";
        public int a = 0, b = 0, pos = 0;

        public Bundle() {
        }

        public Bundle(String s, int a, int b, int c) {
            this.s = s;
            this.a = a;
            this.b = b;
            this.pos = c;
        }
    }

    public String createGraphicLink(ArachDocument doc) {
        return createFileLink(doc, "Graphic");
    }

    public String createFileLink(ArachDocument doc, String fileType) {
        String result = "";
        int type = main.fileTypes.getFileTypeForName(fileType);
        if (type != -1) {
            File f = promptDoc(doc, type, true);
            if (f != null) {
                File f_to = new File(doc.getFullPath());
                String from = f.getPath();
                String to = f_to.getPath();
                result = ArachComp.createRelativePath(from, to);
            }
        } else {
            main.beep();
            JOptionPane.showMessageDialog(main, "The file type \"" + fileType + "\" was not found.\n" + "Please be sure the submitted file type matches one\n" + "in the list of file types located at\n" + "\"" + main.basePath + "/ArachConf/FileData.txt.\"\n" + "These file types are case sensitive.", "Open file by type", JOptionPane.OK_OPTION);
        }
        return result;
    }

    public File promptDoc(ArachDocument doc, int type, boolean isGraphic) {
        if (!doc.isFile) {
            JOptionPane.showMessageDialog(main, "HTML files cannot link to other documents\n" + "or resources or be linked from others\n" + "before they are saved.\n" + "To enable this operation,\n" + "please first save your document.", "Right-cick wizard -- File not saved", JOptionPane.OK_OPTION);
            return null;
        }
        File f = null;
        final PickerDialog fc;
        String path = main.configValues.fileTypePaths[type];
        main.fileTypes.setFileType(type);
        if (path.length() > 0) {
            File fp = new File(path);
            fc = new PickerDialog(main, fp, main.fileTypes, PickerPanel.FILES_ONLY);
        } else {
            fc = new PickerDialog(main, main.fileTypes, PickerPanel.FILES_ONLY);
        }
        //fc.setFileSelectionMode(PickerPanel.FILES_ONLY);
        fc.setDialogTitle("Create link to " + main.fileTypes.fileTypeNames[type] + " file");
        if (isGraphic) {
            fc.setPreviewMode(PickerPanel.PREVIEW_GRAPHIC);
        }
        int returnVal = fc.showOpenDialog();
        if (returnVal == PickerPanel.ACCEPT) {

            File[] flist = fc.getSelectedFiles();
            if (flist.length > 0) {
                f = flist[0];
                main.configValues.fileTypePaths[type] = ArachComp.pathFromFullPath(f.getPath());
            }
        }
        return f;
    }
}
