// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * SearchReplaceStuff.java
 *
 * Created on December 18, 2001, 11:58 PM
 */
import javax.swing.*;
import javax.swing.text.*;

/**
 *
 * @author Administrator
 * @version
 */
final public class SearchReplaceStuff {
    //String search;
    //String replace;
    //String unescSearch;
    //String unescReplace;

    int findCount;
    int fileCount;
    Arachnophilia main;
    ArachDocument doc;
    int pos = -1, selStart, selEnd;
    boolean found = false;
    public boolean cancelCurrentOperation = false;
    boolean lockAccess = false;

    /**
     * Creates new SearchReplaceStuff
     */
    public SearchReplaceStuff(Arachnophilia m) {
        main = m;
    }

    public void countOccurrences(ArachDocument d, String search) {
        if (d != null) {
            //doc.undoPush();
            SearchReplace srch = new SearchReplace();
            //doc.lockDocument = true;
            int localSelStart;
            int localSelEnd;
            boolean selectionValid;
            int p = d.textComp.getCaretPosition();
            localSelStart = d.textComp.getSelectionStart();
            localSelEnd = d.textComp.getSelectionEnd();
            selectionValid = (localSelStart != localSelEnd);
            String text;
            if (selectionValid) {
                text = d.textComp.getSelectedText();
            } else {
                text = d.textComp.getText();
            }
            int count = srch.countOccurrences(0, text,
                    search, main.configValues.caseSensitiveTextSearch);
            main.showSearchResults("Found " + count + " case" + smartModifier(count) + ".");
        }
    }

    private String smartModifier(int count) {
        return (count == 1) ? "" : "s";
    }

    public void findFirst(ArachDocument d, String search) {
        if (d != null) {
            d.textComp.setCaretPosition(0);
            findNext(d, search);
        }
    }

    public void findNext(ArachDocument d, String search) {
        if (d != null) {
            //search = fPanel.getFindString();
            //unescSearch = EscapeUnescapeStringHandler.unescapeString(search);
            /*if(addToList) {
             addStringToList(search,findList);
             }*/
            if (search.length() > 0) {
                doc = d;
                //text = doc.textComp.getText();

                //replace = fPanel.getReplaceString();
                //unescReplace = EscapeUnescapeStringHandler.unescapeString(replace);
                //doc.textComp.setCaretPosition(0);
                pos = d.textComp.getCaretPosition();
                findText2(search);
            } else {
                main.beep();
            }
        } else {
            main.beep();
        }
    }

    public void findText2(String search) {
        found = false;
        if (main.currentSelectedDocument == doc && doc != null) {

            pos = searchText(search, pos, main.configValues.caseSensitiveTextSearch, doc.textComp);
            if (pos != -1) {
                found = true;
                selStart = pos;
                selEnd = pos + search.length();
                doc.centerCaret = true;
                doc.textComp.select(selStart, selEnd);
                Caret car = doc.textComp.getCaret();
                if (car != null) {
                    car.setSelectionVisible(true);
                }
                pos = selEnd;
                main.showSearchResults("Found 1 case.");
            } else {
                pos = 0;
                doc.textComp.setCaretPosition(0);
                main.beep();
                main.showSearchResults("Not found.");
            }
        } else {
            main.beep();
        }
    }

    private int searchText(String search, int pos, boolean caseSens, MySyntaxTextArea dd) {
        int top = dd.getLength();
        int len = search.length();
        top -= len;
        int findex = -1;
        if (caseSens) {
            for (int i = pos; i < top; i++) {
                if (search.equals(dd.getText(i, len))) {
                    findex = i;
                    break;
                }
            }
        } else {
            for (int i = pos; i < top; i++) {
                if (search.equalsIgnoreCase(dd.getText(i, len))) {
                    findex = i;
                    break;
                }
            }
        }
        return findex;
    }

    public void replaceText(String search, String replace) {

        if (!found || main.currentSelectedDocument != doc || doc == null) {
            main.showSearchResults("Searching.");
            findNext(main.currentSelectedDocument, search);
        } else {
            doc.undoPush();
            doc.textComp.replaceSelection(replace);
            int delta = replace.length() - search.length();
            pos += delta;
            doc.textComp.setCaretPosition(selStart);
            doc.textComp.moveCaretPosition(pos);
            found = false;
            main.showSearchResults("Replaced 1 case.");
        }
    }

    public void replaceGlobalThread(String search, final String unescSearch, String replace, final String unescReplace) {
        if (!lockAccess) {
            int r = JOptionPane.showConfirmDialog(main, "This operation will replace ALL cases of \n"
                    + "\"" + search + "\" with\n"
                    + "\"" + replace + "\"\n"
                    + "in ALL open documents.\n"
                    + "Okay to proceed?", "Global Replace All", JOptionPane.YES_NO_OPTION);

            if (r == JOptionPane.YES_OPTION) {
                lockAccess = true;
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                        replaceGlobal(unescSearch, unescReplace);
                    }
                });
            }
        } else {
            main.beep();
        }
    }

    private void replaceGlobal(String search, String replace) {
        cancelCurrentOperation = false;
        fileCount = 0;
        findCount = 0;
        ArachDocument[] array = main.fileHandler.docArray();
        for (int i = 0; i < array.length && !cancelCurrentOperation; i++) {
            // force no selection for this option
            ArachDocument localDoc = array[i];
            //System.out.println("normal: " + doc);
            localDoc.textComp.setSelectionEnd(localDoc.textComp.getSelectionStart());
            replaceAll2(localDoc, search, replace);
            fileCount++;
        }
        main.showSearchResults("Replaced " + findCount + " case" + smartModifier(findCount) + " in " + fileCount + " file" + smartModifier(fileCount) + ".");
        cancelCurrentOperation = false;
        lockAccess = false;
    }

    public void replaceAllThread(final ArachDocument doc, final String search, final String replace) {
        if (doc != null && !lockAccess) {
            findCount = 0;
            lockAccess = true;
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    replaceAll(doc, search, replace);
                }
            });
        } else {
            System.out.println("replaceAllThread beep -> lockaccess: " + lockAccess);
            main.beep();
        }
    }

    private void replaceAll(ArachDocument doc, String search, String replace) {
        replaceAll2(doc, search, replace);
        lockAccess = false;
        main.showSearchResults("Replaced " + findCount + " case" + smartModifier(findCount) + ".");
    }

    private void replaceAll2(ArachDocument doc, String search, String replace) {
        if (doc != null) {
            doc.undoPush();
            SearchReplace srch = new SearchReplace();
            doc.lockDocument = true;
            int localSelStart;
            int localSelEnd;
            int origLen = 0;
            int newLen;
            boolean selectionValid;
            int p = doc.textComp.getCaretPosition();
            localSelStart = doc.textComp.getSelectionStart();
            localSelEnd = doc.textComp.getSelectionEnd();
            selectionValid = (localSelStart != localSelEnd);
            String text;
            if (selectionValid) {
                text = doc.textComp.getSelectedText();
                origLen = text.length();
            } else {
                text = doc.textComp.getText();
            }
            //search = fPanel.getFindString();
            //unescSearch = EscapeUnescapeStringHandler.unescapeString(search);
            //replace = fPanel.getReplaceString();
            //unescReplace = EscapeUnescapeStringHandler.unescapeString(replace);
            text = srch.srchRplc(0, text,
                    search, replace,
                    main.configValues.caseSensitiveTextSearch);
            findCount += srch.findCount;
            if (selectionValid) {
                doc.textComp.replaceSelection(text);
                newLen = text.length();
                doc.textComp.setSelectionStart(localSelStart);
                doc.textComp.setSelectionEnd(localSelEnd + newLen - origLen);
            } else {
                doc.textComp.setText(text);
                if (p < doc.textComp.getDocument().getLength()) {
                    doc.textComp.setCaretPosition(p);
                }
            }
            //doc.textComp.setCaretPosition(p);
            Caret car = doc.textComp.getCaret();
            if (car != null) {
                car.setSelectionVisible(true);
            }
            doc.textComp.rfiw();
            doc.lockDocument = false;
        } else {
            main.beep();
        }
    }
}
