// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * SimpleMessageDialog.java
 *
 * Created on February 28, 2002, 5:01 PM
 */

import java.awt.*;
/**
 *
 * @author  Administrator
 */
public class SimpleMessageDialog extends javax.swing.JDialog {

    /** Creates new form SimpleMessageDialog */
    String message;
    public SimpleMessageDialog(java.awt.Frame parent,String msg,String title) {
        super(parent,true);
        message = msg;
        initComponents();
        messageArea.setText(message);
         messageArea.setBackground(getContentPane().getBackground());
        messageArea.invalidate();
        setTitle(title);
        pack();
        Rectangle ss = parent.getBounds();
        int w = ss.width/4;
        int h = ss.height/4;
        setBounds(ss.x+w,ss.y+h,ss.width-w*2,ss.height-h*2);
        setVisible(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        bottomPanel = new javax.swing.JPanel();
        okButton = new MyJButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        messageArea = new javax.swing.JTextArea();
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        
        bottomPanel.add(okButton);
        
        getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);
        
        jScrollPane3.setPreferredSize(new java.awt.Dimension(36, 40));
        messageArea.setBackground(new java.awt.Color(204, 204, 204));
        messageArea.setEditable(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        jScrollPane3.setViewportView(messageArea);
        
        getContentPane().add(jScrollPane3, java.awt.BorderLayout.CENTER);
        
        pack();
    }//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
      quit();  
    }//GEN-LAST:event_closeDialog

    private void quit()
    {
        setVisible(false);
        dispose();
    }
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        SimpleMessageDialog simpleMessageDialog = new SimpleMessageDialog(new javax.swing.JFrame(), "message","Title");
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextArea messageArea;
    // End of variables declaration//GEN-END:variables

}
