// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;



/*
 * TextInputDialog.java
 *
 * Created on December 15, 2001, 1:31 PM
 */

import java.awt.*;

/**
 *
 * @author  Administrator
 */
final public class TextInputDialog extends javax.swing.JDialog {
    
    boolean accept = false;
    boolean needInit = true;
    Frame parent;
    /** Creates new form TextInputDialog */
    public TextInputDialog(Frame parent) {
        super(parent, true);
        this.parent = parent;
        initComponents();
        setFont(parent.getFont());
        promptArea.setFont(getFont());
        promptArea.setBackground(getContentPane().getBackground());
        inputField.setFont(getFont());
       
        
    }
    
    public String showDialog(String title,String prompt,String previousValue) {
        setTitle(title);
        promptArea.setText(prompt);
        pack();
        Rectangle r = parent.getBounds();
        int w = r.width/4;
        int h = r.height/4;
        double scale = Math.sqrt(prompt.length());
        setBounds(r.x+w,r.y+h,(int)(200 + 10 * scale), (int)(100 + 10 * scale));
        inputField.setText(previousValue);
        setVisible(true);
        if (accept) {
            return inputField.getText();
        }
        else {
            return null;
        }
    }
    
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if(needInit) {
            needInit = false;
            inputField.grabFocus();
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        promptArea = new javax.swing.JTextArea();
        inputField = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        OKButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setModal(true);
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        promptArea.setBackground(new java.awt.Color(204, 204, 204));
        promptArea.setLineWrap(true);
        promptArea.setWrapStyleWord(true);
        promptArea.setMargin(new java.awt.Insets(4, 4, 4, 4));
        promptArea.setAutoscrolls(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        getContentPane().add(promptArea, gridBagConstraints1);
        
        inputField.setColumns(30);
        inputField.setToolTipText("Enter/edit value here");
        inputField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inputFieldActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints1.weightx = 1.0;
        getContentPane().add(inputField, gridBagConstraints1);
        
        OKButton.setText("OK");
        OKButton.setToolTipText("Accept this entry");
        OKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OKButtonActionPerformed(evt);
            }
        });
        
        jPanel1.add(OKButton);
        
        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Abandon the entry");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        jPanel1.add(cancelButton);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints1.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints1);
        
        pack();
    }//GEN-END:initComponents

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
        // Add your handling code here:
        inputField.requestFocusInWindow();
    }//GEN-LAST:event_formFocusGained

    private void inputFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inputFieldActionPerformed
        // Add your handling code here:
       accept();
    }//GEN-LAST:event_inputFieldActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void OKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OKButtonActionPerformed
        // Add your handling code here:
        accept = true;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_OKButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    private void accept()
    {
            accept = true;
            setVisible(false);
            dispose();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea promptArea;
    private javax.swing.JTextField inputField;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton OKButton;
    private javax.swing.JButton cancelButton;
    // End of variables declaration//GEN-END:variables
    
}
