// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * BaseCalcPanel.java
 *
 * Created on March 3, 2002, 8:44 AM
 */
package BaseCalc;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import Arachnophilia.*;

/**
 *
 * @author  Administrator
 */
public class BaseCalcPanel extends javax.swing.JPanel {

    int[] bases = new int[]{2, 8, 10, 16};
    //String[] baseNames = new String[]{"Binary", "Octal", "Decimal", "Hexadecimal"};
    //BasePanel[] panels;
    BaseFrame parent;
    JTextField controls[];
    int radices[] = {2, 8, 10, 16};
    String entries[] = new String[]{"", "", "", ""};

    /** Creates new form BaseCalcPanel */
    public BaseCalcPanel(BaseFrame p) {
        parent = p;
        initComponents();
        //contentPane.setLayout(new GridLayout(bases.length, 1));
        //panels = new BasePanel[bases.length];
        controls = new JTextField[]{binaryField, octalField, decimalField, hexField};
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                controls[3].requestFocusInWindow();
            }
        });
    }

    public void process(KeyEvent evt, int n) {
        evt.consume();
        char c = evt.getKeyChar();
        int kcode = evt.getKeyCode();
        //String name = evt.getKey_Text(kcode);
        int radix = radices[n];
        String s = entries[n];
        int len = s.length();
        if (kcode == KeyEvent.VK_BACK_SPACE) { // backspace
            if (len > 0) {
                s = s.substring(0, len - 1);
            }
        } else {
            s += c;
        }
        String os = s;
        long value = 0;
        boolean fail;
        do {
            fail = false;
            try {
                value = Long.valueOf(s, radix).longValue();
            } catch (NumberFormatException e) {
                fail = true;
                len = s.length();
                if (len > 0) {
                    s = s.substring(0, len - 1);
                }
            }
        } while (fail && s.length() > 0);
        entries[n] = s;
        // now generate all bases
        for (int i = 0; i < controls.length; i++) {
            String ss = (value > 0) ? Long.toString(value, radices[i]) : "";
            controls[i].setText(ss);
        }
    }

/** This method is called from within the constructor to
 * initialize the form.
 * WARNING: Do NOT modify this code. The content of this method is
 * always regenerated by the Form Editor.
 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        contentPane = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        binaryField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        octalField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        decimalField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        hexField = new javax.swing.JTextField();
        controlPane = new javax.swing.JPanel();
        closeButton = new MyJButton();

        setMinimumSize(new java.awt.Dimension(500, 140));
        setPreferredSize(new java.awt.Dimension(500, 140));
        setLayout(new java.awt.BorderLayout());

        contentPane.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Binary");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.03;
        contentPane.add(jLabel1, gridBagConstraints);

        binaryField.setFont(new java.awt.Font("Courier", 0, 14)); // NOI18N
        binaryField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        binaryField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                binaryFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        contentPane.add(binaryField, gridBagConstraints);

        jLabel2.setText("Octal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        contentPane.add(jLabel2, gridBagConstraints);

        octalField.setFont(new java.awt.Font("Courier", 0, 14)); // NOI18N
        octalField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        octalField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                octalFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        contentPane.add(octalField, gridBagConstraints);

        jLabel3.setText("Decimal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        contentPane.add(jLabel3, gridBagConstraints);

        decimalField.setFont(new java.awt.Font("Courier", 0, 14)); // NOI18N
        decimalField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        decimalField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                decimalFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        contentPane.add(decimalField, gridBagConstraints);

        jLabel4.setText("Hexadecimal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        contentPane.add(jLabel4, gridBagConstraints);

        hexField.setFont(new java.awt.Font("Courier", 0, 14)); // NOI18N
        hexField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        hexField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                hexFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        contentPane.add(hexField, gridBagConstraints);

        add(contentPane, java.awt.BorderLayout.CENTER);

        closeButton.setText("Close");
        closeButton.setToolTipText("Close this frame");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        controlPane.add(closeButton);

        add(controlPane, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        parent.quit();
    }//GEN-LAST:event_closeButtonActionPerformed

    private void binaryFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_binaryFieldKeyReleased
        // TODO add your handling code here:
        process(evt,0);
    }//GEN-LAST:event_binaryFieldKeyReleased

    private void octalFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_octalFieldKeyReleased
        // TODO add your handling code here:
        process(evt,1);
    }//GEN-LAST:event_octalFieldKeyReleased

    private void decimalFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_decimalFieldKeyReleased
        // TODO add your handling code here:
        process(evt,2);
    }//GEN-LAST:event_decimalFieldKeyReleased

    private void hexFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_hexFieldKeyReleased
        // TODO add your handling code here:
        process(evt,3);
    }//GEN-LAST:event_hexFieldKeyReleased

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField binaryField;
    private javax.swing.JButton closeButton;
    private javax.swing.JPanel contentPane;
    private javax.swing.JPanel controlPane;
    private javax.swing.JTextField decimalField;
    private javax.swing.JTextField hexField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField octalField;
    // End of variables declaration//GEN-END:variables
}
