// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * BrowserDialog.java
 *
 * Created on February 23, 2002, 10:52 AM
 */

package BrowserStuff;

import Arachnophilia.*;
//import ArachConstants;
//import InfoDialog;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
public final class BrowserDialog extends javax.swing.JDialog {
    
    Arachnophilia main;
    BrowserPanel bp;
    /** Creates new form BrowserDialog */
    public BrowserDialog(Arachnophilia m) {
        super(m, true);
        main = m;
        main.haveFocus = false;
        setTitle(ArachConstants.APPNAME + " Browser Configuration");
        //setIconImage(m.getIconImage());
        initComponents();
        bp = new BrowserPanel(this,m);
        getContentPane().add(bp);
        
        pack();
        if(!bp.haveDefinedBrowser) {
            launchInfoDialog();
        }
        
        Rectangle ss = m.getBounds();
        int w = ss.width/8;
        int h = ss.height/8;
        setLocation(ss.x+w,ss.y+h);
        setVisible(true);
        repaint();
        
    }
    
    public void launchInfoDialog() {
        if(main.configValues.showBrowserInfo) {
            String s =
            "Arachnophilia needs to find your system browser.\n\n"
            + "In the dialog following this one, you will help "
            + "Arachnophilia locate one or more browsers. If you are using "
            + "Windows, the most likely location to search is in the \"/Program Files\" "
            + "directory, so this choice will be made for you.\n\n"
            +"For other operating "
            + "systems, you will need to know which directory contains the browser executable. "
            + "Of course, you can always just search the entire file system, but "
            +"this may take quite some time.\n\n"
            +"1. Choose a directory if the default is not suitable.\n"
            +"2. Press \"Search\".\n"
            +"3. Press \"Transfer\" to complete the process.\n\n"
            +"Press \"OK\" to move to the next dialog.";
            InfoDialog info = new InfoDialog(main,true,"HTML Browser configuration",s);
            main.configValues.showBrowserInfo = !info.dontShowAgain;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        pack();
    }//GEN-END:initComponents
    
    public void close() {
        main.haveFocus = true;
        setVisible(false);
        dispose();
    }
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        close();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        new BrowserDialog(new javax.swing.JFrame(), true).show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
