// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package BrowserStuff;

import Arachnophilia.*;
import java.io.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version
 */
public final class BrowserLauncher {
    
    ArachDocument doc = null;
    Arachnophilia main = null;
    Process browserProcess = null;
    public File browserTempFile = null;
    boolean needServer;
    /** Creates new BrowserHandler */
    public BrowserLauncher(ArachDocument d, Arachnophilia m) {
        doc = d;
        main = m;
        int at = main.fileTypes.getFileTypeForName("ASP");
        int pt = main.fileTypes.getFileTypeForName("PHP");
        int ht = main.fileTypes.getFileTypeForName("HTML");
        boolean is_shtml = d.getFullPath().matches("(?i).*\\.shtml");
        needServer = (doc.fileType == at || doc.fileType == pt || (doc.fileType == ht && is_shtml));
    }
    
    public BrowserLauncher( Arachnophilia m) {
        main = m;
    }
    
    public void closeThings() {
        if(browserTempFile != null) {
            browserTempFile.delete();
            browserTempFile = null;
        }
        if(browserProcess != null) {
            browserProcess.destroy();
            browserProcess = null;
        }
    }
    
    public void retireTempFile() {
        closeThings();
    }
    
    private BrowserData chooseBrowser(String arg) {
        BrowserData data = null;
        if(arg.length() > 0) {
            for(int i = 0;i < main.configValues.browserList.length;i++) {
                BrowserData test = new BrowserData(main.configValues.browserList[i]);
                if(arg.equalsIgnoreCase(test.name)) {
                    data = test;
                    break;
                }
            }
            if(data == null) {
                main.beep();
                JOptionPane.showMessageDialog(main,
                "You have requested a browser with an unrecognized name\n"
                +"or a site with an unrecognized URL:"
                + "\"" + arg + "\".\n"
                +"For browser names, case doesn't matter, but spelling does.\n\n"
                +"The browser configuration dialog will launch next,\n"
                + "where you can check the spelling of the browser name.\n"
                +"Then you may want to edit the browser launch\n"
                +"button/macro you are using."
                ,
                "Named browser not found",JOptionPane.INFORMATION_MESSAGE);
                
            }
        }
        else {
            int q = main.configValues.selectedBrowser;
            if(q >= 0 && q < main.configValues.browserList.length) {
                data = new BrowserData(main.configValues.browserList[q]);
                if(!data.exists()) {
                    data = null;
                }
            }
        }
        return data;
    }
    
    public void launchBrowser(String arg) {
        launchBrowser(arg,null);
    }
    
    public void launchDefaultBrowserWithURL(String url) {
        launchBrowser(null,url);
    }
    
    public void launchBrowser(String arg,String url) {
        BrowserData data = null;
        if(arg != null) {
            data = chooseBrowser(arg);
        }
        else { // get the default
            data = chooseBrowser("");
        }
        // no browser choice
        if(data == null) {
            BrowserDialog browserDialog = new BrowserDialog(main);
            return;
        }
        String path = null;
        if(url == null && doc != null) {
            path = doc.getPath();
            if(!doc.isFile) {
                path = main.userHome;
            }
        }
        
        
        if(browserProcess != null && data.closeBeforeOpening) {
            browserProcess.destroy();
            browserProcess = null;
            //System.out.println(browserProcess.getInputStream());
        }
        
        boolean needBrowserTempFile = false;
        if(needServer){
            needBrowserTempFile = data.phpLaunchArgument.indexOf("$1") != -1;
        }
        else {
            needBrowserTempFile = data.htmlLaunchArgument.indexOf("$1") != -1;
        }
        
        if(needBrowserTempFile && browserTempFile == null && url == null) {
            closeThings();
            try {
                String suffix = ".html";
                int p = doc.name.lastIndexOf(".");
                if(p > 0) {
                    suffix = doc.name.substring(p);
                }
                browserTempFile = File.createTempFile(Arachnophilia.tempFilePrefix,suffix,new File(path));
                browserTempFile.deleteOnExit();
            }
            catch(Exception e) {
                e.printStackTrace(System.out);
            }
        }
        if(url != null) { // view an URL
            try {
                //System.out.println("launching URL with: " + data.appPath + "," + url);
                browserProcess = Runtime.getRuntime().exec(new String[]{data.appPath,url});
            }
            catch(Exception e) {
                e.printStackTrace(System.out);
            }
        }
        else { // temporary HTML file view
            if(browserTempFile != null || !needBrowserTempFile) {
                String destPath = "";
                if(browserTempFile != null) {                    
                    destPath = browserTempFile.getPath().replaceAll("\\\\","/");
                }
                String content = doc.textComp.getText();
                String anchorRef;
                String anchorLink = "";
                if(needBrowserTempFile && data.alwaysJumpToDocPos) {
                    
                    int line = doc.textComp.getCaretLine();
                    int top = doc.textComp.getLineCount();
                    int vis = doc.textComp.getVisibleLines();
                    //move up three lines
                    line -= 3;
                    line = (line < 0)?0:line;
                    line = (line >= top)?top-1:line;
                    int off = doc.textComp.getLineStartOffset(line);
                    //System.out.println(off);
                    if(off != -1) {
                        anchorLink = "#ArachTempDocPos";
                        anchorRef = "<a name=\"ArachTempDocPos\"></a>";
                        String tail = content.substring(off);
                        content = content.substring(0,off) + anchorRef + tail;
                    }
                }
                //System.out.println("dest path: " + destPath);
                ArachComp.writeDataFile(browserTempFile.getPath(),content,true);
                //if(browserProcess == null) {
                // if no argument, create a script
                String comArgs = (needServer)?data.phpLaunchArgument:data.htmlLaunchArgument;
                // process macros
                comArgs = main.comSwitchboard.exec(comArgs,0);
                // look for filename token
                if(needBrowserTempFile) {
                    if(needServer) {
                        String shortPath = browserTempFile.getName();
                        comArgs = data.formatActivationString(comArgs,"$1",shortPath + anchorLink);
                    }
                    else {
                        comArgs = data.formatActivationString(comArgs,"$1",destPath + anchorLink);
                    }
                    
                }
                try {
                    //System.out.println("launching file path with: " + data.appPath + "," + comArgs);
                    browserProcess = Runtime.getRuntime().exec(new String[]{data.appPath,comArgs});
                }
                catch(Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
