// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * BrowserPanel.java
 *
 * Created on February 23, 2002, 10:51 AM
 */
package BrowserStuff;

import Arachnophilia.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author Administrator
 */
final public class BrowserPanel extends javax.swing.JPanel {

    Arachnophilia main;
    BrowserDialog browserDialog;
    StringBuilder namesPath;
    boolean threadExists = false;
    boolean stopSearching = false;
    boolean suppressDisplayChanges = false;
    public boolean haveDefinedBrowser = false;
    int statusCounter = 0;
    int statusInterval = 0;
    int foundCount = 0;
    int lastSelectedIndex = -1;
    ArrayList<String> bList;
    BrowserData[] browserArray;

    /**
     * Creates new form BrowserPanel
     */
    public BrowserPanel(BrowserDialog d, Arachnophilia m) {
        browserDialog = d;
        main = m;
        initComponents();
        bList = new ArrayList<String>();
        browserArray = new BrowserData[main.configValues.browserListSize];
        int defined = loadBrowserList();
        haveDefinedBrowser = (defined > 0);
        listToDisplay();
        int q = main.configValues.selectedBrowser;
        if (q >= 0 && q < browserList.getItemCount()) {
            browserList.setSelectedIndex(q);
        }
        handleListChange();
        bList.add("Browsers Located:");
        resultList.setListData(bList.toArray(new String[]{}));
        namesPath = new StringBuilder();
        namesPath.append(main.basePath).append(ArachConstants.SYSTEM_FILESEP).append(Arachnophilia.dataDirName).append(ArachConstants.SYSTEM_FILESEP).append("BrowserExecutableNames.txt");
        String names = ArachComp.readProgramFile(namesPath.toString(), true);
        if (names != null) {
            executableNames.setText(names);
            executableNames.setCaretPosition(0);
            if (!haveDefinedBrowser) {

                File f = new File("/Program Files"); // Windows
                if (f.exists()) {
                    main.configValues.browserSearchStartPath = "/Program Files;/Program Files (x86)";
                } else {
                    f = new File("/Applications"); // Macintosh OS X
                    if (f.exists()) {
                        main.configValues.browserSearchStartPath = f.getPath();
                    } else {
                        f = new File("/usr/bin"); // Linux
                        if (f.exists()) {
                            main.configValues.browserSearchStartPath = "/usr/bin;/usr/local/bin";
                        } else {
                            main.configValues.browserSearchStartPath = "/"; // never fail, even when wrong
                        }
                    }
                }
            }
            startPath.setText(main.configValues.browserSearchStartPath);
        }
    }

    private int loadBrowserList() {
        int j = 0;
        for (int i = 0; i < browserArray.length; i++) {
            //System.out.println(main.configValues.browserList[i].toString());
            BrowserData data = new BrowserData(main.configValues.browserList[i]);
            if (!(data.appPath.equals("") && data.name.equals("--"))) {
                browserArray[j++] = data;
            }

        }
        int defined = j;
        while (j < browserArray.length) {
            browserArray[j++] = new BrowserData();
        }

        return defined;
    }

    private void saveBrowserList() {
        for (int i = 0; i
                < browserArray.length; i++) {
            main.configValues.browserList[i] = browserArray[i].toString();
        }

    }

    private void debugList() {
        for (int i = 0; i
                < browserArray.length; i++) {
            //System.out.println(i + " = " + browserArray[i]);
        }
    }

    private void deleteListItem() {
        handleListChange();
        debugList();
        int q = lastSelectedIndex;
        //System.out.println(q);
        if (q != -1 && q < browserArray.length) {
            suppressDisplayChanges = true;
            for (int i = q; i
                    < browserArray.length - 1; i++) {
                //System.out.println("overwriting " + browserArray[i] + " with " +  browserArray[i+1]);
                browserArray[i] = BrowserData.clone(browserArray[i + 1]);
                //System.out.println("result: " + browserArray[i]);
            }

            browserArray[browserArray.length - 1] = new BrowserData();

        }

        debugList();
        arrayToDisplay(q);
        listToDisplay();
        suppressDisplayChanges
                = false;
        browserList.setSelectedIndex(q);

    }

    private void acceptClose() {
        ArachComp.writeProgramFile(namesPath.toString(), executableNames.getText(), false);
        handleListChange();
        if (browserArray[0].name.equals("--")) {
            acceptSearchResults(true);
            handleListChange();
        } else {
            saveBrowserList();
            browserDialog.close();
        }

    }

    private void doCancel() {
        browserDialog.close();
    }

    private void selectBrowser() {
        handleListChange();
        if (lastSelectedIndex != -1) {
            int q = lastSelectedIndex;
            main.configValues.selectedBrowser = q;
            listToDisplay();
            browserList.setSelectedIndex(q);
        }

    }

    private void handleListChange() {
        if (!suppressDisplayChanges) {
            int i = browserList.getSelectedIndex();
            if (lastSelectedIndex != -1) {
                displayToArray(lastSelectedIndex);
            }

            if (i != -1) {
                arrayToDisplay(i);
                lastSelectedIndex
                        = i;
            }

        }
    }

    private void displayToArray(int i) {
        //System.out.println("displayToArray");
        browserArray[i] = new BrowserData(browserName.getText(), appPath.getText(), htmlLaunchArgTextField.getText(), phpLaunchArgTextField.getText(), cboCheckBox.getSelectedObjects() != null, ajdpCheckBox.getSelectedObjects() != null);
        browserList.insertItemAt(makePrefix(i) + browserName.getText(), i);
        browserList.removeItemAt(i + 1);
    }

    private void arrayToDisplay(int i) {
        browserName.setText(browserArray[i].name);
        appPath.setText(browserArray[i].appPath);
        htmlLaunchArgTextField.setText(browserArray[i].htmlLaunchArgument);
        phpLaunchArgTextField.setText(browserArray[i].phpLaunchArgument);
        cboCheckBox.setSelected(browserArray[i].closeBeforeOpening);
        ajdpCheckBox.setSelected(browserArray[i].alwaysJumpToDocPos);
        browserList.insertItemAt(makePrefix(i) + browserName.getText(), i);
        browserList.removeItemAt(i + 1);
    }

    private String makePrefix(int i) {
        String s = (main.configValues.selectedBrowser == i) ? "*" : " ";
        return i + ":" + s;
    }

    private void listToDisplay() {
        suppressDisplayChanges = true;
        browserList.removeAllItems();
        for (int i = 0; i
                < browserArray.length; i++) {
            //System.out.println("new item " + i + ": " + browserArray[i]);
            browserList.addItem(makePrefix(i) + browserArray[i].name);
        }

        suppressDisplayChanges = false;
    }

    private void addPathToList(String path) {
        if (path.length() > 0) {
            if (!bList.contains(path)) {
                foundCount++;
                bList.add(path);
            }

        }
        resultList.setListData(bList.toArray(new String[]{}));
        //jScrollPane2.updateUI();
    }

    private void startSearch(boolean recallAccept) {
        if (threadExists) {
            main.beep();
        } else {
            stopSearching = false;
            foundCount
                    = 0;
            ArachComp.writeProgramFile(namesPath.toString(), executableNames.getText(), false);
            String path = startPath.getText();
            main.configValues.browserSearchStartPath = path;
            String names = executableNames.getText();
            ArrayList<String> execNames = ArachComp.parseDelimLine(names, "\n");
            HashSet<String> hash = new HashSet<>();
            for (String name : execNames) {
                String slc = name.toLowerCase();
                hash.add(slc);
                hash.add(slc + ".exe");
            }

            addPathToList("");
            startSearchThread(path, hash, recallAccept);
        }

    }

    private void startSearchThread(final String path,
            final HashSet<String> hash,
            final boolean recallAccept) {
        threadExists = true;
        Thread t1 = new Thread() {

            @Override
            public void run() {
                try {
                    // this allows multiple search paths to be entered
                    String[] paths = path.split(";");
                    for (String p : paths) {
                        if (p.length() > 0) {
                            File f = new File(new File(p).getCanonicalPath());
                            searchForFile(f, hash);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace(System.out);
                }

                threadExists = false;
                main.beep();
                statusLabel.setText("Done.");
                wrapUpSearch();
                if (recallAccept) {
                    acceptSearchResults(false);
                }

            }
        };
        t1.start();
    }

    private void searchForFile(File pf, HashSet<String> hash) {
        try {
            if (pf != null) {
                // test for looping symbolic links
                File can = new File(pf.getCanonicalPath());
                if (can.equals(pf) && !stopSearching) {
                    if ((statusInterval++ % 20) == 0) {
                        updateStatusLabel();
                    }

                    File[] list = pf.listFiles();
                    for (File f : list) {
                        if (f.isDirectory()) {
                            // recurse
                            searchForFile(f, hash);
                        } else { // it's a file
                            if (hash.contains(f.getName().toLowerCase())) {
                                addPathToList(f.getPath());
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }

    }

    private void updateStatusLabel() {
        String[] statusMarks = {"\\", "|", "/", "-"};
        statusLabel.setText("Search " + statusMarks[statusCounter % statusMarks.length]);
        statusCounter++;

    }

    private void stopSearch() {
        if (threadExists) {
            stopSearching = true;
            wrapUpSearch();
        } else {
            main.beep();
        }

    }

    private void wrapUpSearch() {
        if (foundCount > 0) {
            resultList.setToolTipText("<html>Select one or more of the results,<br>then press \"Transfer\" below.</html>");
        }

    }

    private void browseForStartPath() {
        String path = startPath.getText();
        if (path.length() == 0) {
            path = "/";
        }
        JFileChooser dialog = new JFileChooser(path);
        dialog.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        dialog.setDialogTitle("Choose Browser Search Path");
        dialog.setApproveButtonText("Accept");
        int r = dialog.showOpenDialog(main);
        if (r == JFileChooser.APPROVE_OPTION) {
            startPath.setText(dialog.getSelectedFile().toString());
        }

        requestFocusInWindow();
        browserDialog.requestFocusInWindow();
    }

    private void acceptSearchResults(boolean first) {
        ArachComp.writeProgramFile(namesPath.toString(), executableNames.getText(), false);
        // this disgusting hack is only to allow people to continue to use Java 1.6
        // after this, use getselectedvalueslist(), the preferred method
        Object[] oa = resultList.getSelectedValues();
        String[] vals = Arrays.copyOf(oa, oa.length, String[].class);
        if (vals.length == 0) {
            ListModel dm = (ListModel) resultList.getModel();
            ArrayList<String> v = new ArrayList<String>();
            for (int i = 1; i
                    < dm.getSize(); i++) {
                v.add((String) dm.getElementAt(i));
            }

            vals = v.toArray(new String[]{});
        }
        int j = 0;
        if (vals.length > 0) {
            int sel = browserList.getSelectedIndex();
            for (int i = 0; i
                    < vals.length; i++) {
                String s = vals[i];
                //System.out.println(vals[i]);
                File f = new File(s);
                if (f.exists()) {
                    String name = f.getName();
                    int p = name.lastIndexOf('.');
                    if (p != -1) {
                        name = name.substring(0, p);
                    }

                    String nameq = name;
                    int k = 2;
                    while (alreadyInList(nameq)) {
                        nameq = name + k;
                        k++;

                    }

                    if (nameq.length() > 0) {
                        nameq = name.substring(0, 1).toUpperCase() + name.substring(1);
                    }

                    if (!alreadyInList(nameq)) {
                        j = getNextFreeListSlot(j);
                        if (j != -1) {
                            browserArray[j] = new BrowserData(nameq, s, "file:$1", "http://server-name/server-path/$1", true, true);
                        } else {
                            main.beep();
                            JOptionPane.showMessageDialog(main,
                                    "There are no free list locations.\n\n" + "Please delete some existing browser definitions\n" + "and try again.",
                                    "No room at the inn", JOptionPane.INFORMATION_MESSAGE);

                            break;
                        }

                    }
                }
                arrayToDisplay(sel);
                listToDisplay();
            }

        } else { // search
            startSearch(first);
        }

    }

    private boolean alreadyInList(String s) {
        for (int i = 0; i
                < browserArray.length; i++) {
            if (browserArray[i].appPath.equals(s)) {
                return true;
            }
        }

        return false;
    }

    private int getNextFreeListSlot(int j) {
        while (j < browserArray.length) {
            if (browserArray[j].name.equals("--")) {
                break;
            }
            j++;

        }

        if (j >= browserArray.length) {
            j = -1;
        }
        return j;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        topPanel = new javax.swing.JPanel();
        appListPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        executableNames = new javax.swing.JTextArea();
        resultListPanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        resultList = new JList<String>();
        startPath = new javax.swing.JTextField();
        startPathLabel = new javax.swing.JLabel();
        browseButton = new MyJButton();
        startButton = new MyJButton();
        stopButton = new MyJButton();
        gimmickPanel = new javax.swing.JPanel();
        statusLabel = new javax.swing.JLabel();
        acceptSearchButton = new javax.swing.JButton();
        bottomPane = new javax.swing.JPanel();
        browserList = new JComboBox<String>();
        jLabel1 = new javax.swing.JLabel();
        browserName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        appPath = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        cboCheckBox = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        htmlLaunchArgTextField = new javax.swing.JTextField();
        acceptButton = new MyJButton();
        cancelButton = new MyJButton();
        makeActiveButton = new MyJButton();
        deleteButton = new MyJButton();
        ajdpCheckBox = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        phpLaunchArgTextField = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setOneTouchExpandable(true);

        topPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Browser Search"));
        topPanel.setLayout(new java.awt.GridBagLayout());

        appListPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Search Names"));
        appListPanel.setLayout(new java.awt.BorderLayout());

        executableNames.setColumns(20);
        executableNames.setRows(5);
        jScrollPane1.setViewportView(executableNames);

        appListPanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(appListPanel, gridBagConstraints);

        resultListPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Search results"));
        resultListPanel.setLayout(new java.awt.BorderLayout());

        jScrollPane2.setAutoscrolls(true);
        jScrollPane2.setPreferredSize(new java.awt.Dimension(200, 100));

        resultList.setToolTipText("This list will contain any located browser executables");
        resultList.setMaximumSize(new java.awt.Dimension(32767, 32767));
        resultList.setMinimumSize(new java.awt.Dimension(100, 50));
        resultList.setPreferredSize(new java.awt.Dimension(500, 200));
        jScrollPane2.setViewportView(resultList);

        resultListPanel.add(jScrollPane2, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        topPanel.add(resultListPanel, gridBagConstraints);

        startPath.setToolTipText("This is the path at which to begin the search");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(startPath, gridBagConstraints);

        startPathLabel.setText("Search path:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(startPathLabel, gridBagConstraints);

        browseButton.setText("Browse");
        browseButton.setToolTipText("Select a directory at which to start the search");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(browseButton, gridBagConstraints);

        startButton.setText("Search");
        startButton.setToolTipText("Start searching for browsers");
        startButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(startButton, gridBagConstraints);

        stopButton.setText("Stop");
        stopButton.setToolTipText("Stop ongoing search");
        stopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(stopButton, gridBagConstraints);

        gimmickPanel.setLayout(new java.awt.BorderLayout());

        statusLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gimmickPanel.add(statusLabel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(gimmickPanel, gridBagConstraints);

        acceptSearchButton.setText("Transfer");
        acceptSearchButton.setToolTipText("<html>Transfer selected/all located paths<br>to unused browser locations below</html>");
        acceptSearchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acceptSearchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        topPanel.add(acceptSearchButton, gridBagConstraints);

        jSplitPane1.setLeftComponent(topPanel);

        bottomPane.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Browser Definitions"));
        bottomPane.setLayout(new java.awt.GridBagLayout());

        browserList.setToolTipText("Choose an unused position (--) for a new entry");
        browserList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browserListActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(browserList, gridBagConstraints);

        jLabel1.setText("Select Browser");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(jLabel1, gridBagConstraints);

        browserName.setToolTipText("You may enter a custom name here.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(browserName, gridBagConstraints);

        jLabel2.setText("Browser Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(jLabel2, gridBagConstraints);

        appPath.setToolTipText("<html>This is the full path to the executable.<br>You may want to use the search engine above</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(appPath, gridBagConstraints);

        jLabel3.setText("Application Path");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(jLabel3, gridBagConstraints);

        cboCheckBox.setText("Close browser before reopening");
        cboCheckBox.setToolTipText("Close the existing browser and relaunch");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(cboCheckBox, gridBagConstraints);

        jLabel4.setText("HTML Launch arg.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(jLabel4, gridBagConstraints);

        htmlLaunchArgTextField.setToolTipText("<html>This should be \"file:$1\" in most cases,<br>\nbut you may need to change it for some browsers.\n</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(htmlLaunchArgTextField, gridBagConstraints);

        acceptButton.setText("OK");
        acceptButton.setToolTipText("Accept and save changes, close dialog");
        acceptButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acceptButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(acceptButton, gridBagConstraints);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Discard changes, close dialog");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(cancelButton, gridBagConstraints);

        makeActiveButton.setText("Make Default");
        makeActiveButton.setToolTipText("Make this browser the default");
        makeActiveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                makeActiveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(makeActiveButton, gridBagConstraints);

        deleteButton.setText("Delete");
        deleteButton.setToolTipText("Delete selected definition");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(deleteButton, gridBagConstraints);

        ajdpCheckBox.setText("Jump to doc pos (may fail embedded scripts)");
        ajdpCheckBox.setToolTipText("<html>Jump to current editing position on preview<br>(this option may create errors in embedded scripts)</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(ajdpCheckBox, gridBagConstraints);

        jLabel5.setText("PHP,ASP Launch Arg.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(jLabel5, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        bottomPane.add(phpLaunchArgTextField, gridBagConstraints);

        jSplitPane1.setRightComponent(bottomPane);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        doCancel();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void makeActiveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_makeActiveButtonActionPerformed
        // Add your handling code here:
        selectBrowser();
    }//GEN-LAST:event_makeActiveButtonActionPerformed

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
        // Add your handling code here:
        deleteListItem();
    }//GEN-LAST:event_deleteButtonActionPerformed

    private void browserListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browserListActionPerformed
        // Add your handling code here:
        handleListChange();
    }//GEN-LAST:event_browserListActionPerformed

    private void acceptButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_acceptButtonActionPerformed
        // Add your handling code here:
        acceptClose();
    }//GEN-LAST:event_acceptButtonActionPerformed

    private void acceptSearchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_acceptSearchButtonActionPerformed
        // Add your handling code here:
        acceptSearchResults(true);
    }//GEN-LAST:event_acceptSearchButtonActionPerformed

    private void stopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopButtonActionPerformed
        // Add your handling code here:
        stopSearch();
    }//GEN-LAST:event_stopButtonActionPerformed

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        // Add your handling code here:
        browseForStartPath();
    }//GEN-LAST:event_browseButtonActionPerformed

    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startButtonActionPerformed
        // Add your handling code here:
        startSearch(false);
    }//GEN-LAST:event_startButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton acceptButton;
    private javax.swing.JButton acceptSearchButton;
    private javax.swing.JCheckBox ajdpCheckBox;
    private javax.swing.JPanel appListPanel;
    private javax.swing.JTextField appPath;
    private javax.swing.JPanel bottomPane;
    private javax.swing.JButton browseButton;
    private javax.swing.JComboBox<String> browserList;
    private javax.swing.JTextField browserName;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox cboCheckBox;
    private javax.swing.JButton deleteButton;
    private javax.swing.JTextArea executableNames;
    private javax.swing.JPanel gimmickPanel;
    private javax.swing.JTextField htmlLaunchArgTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JButton makeActiveButton;
    private javax.swing.JTextField phpLaunchArgTextField;
    private javax.swing.JList<String> resultList;
    private javax.swing.JPanel resultListPanel;
    private javax.swing.JButton startButton;
    private javax.swing.JTextField startPath;
    private javax.swing.JLabel startPathLabel;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JButton stopButton;
    private javax.swing.JPanel topPanel;
    // End of variables declaration//GEN-END:variables
}
