// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * ReplyPanel.java
 *
 * Created on March 1, 2002, 5:07 PM
 */

package CompilerReplyPanel;

import Arachnophilia.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 */
final public class ReplyPanel extends javax.swing.JPanel {
    
    Arachnophilia main;
    Process process;
    Thread thread = null;
    boolean killThread = false;
    
    /** Creates new form ReplyPanel */
    public ReplyPanel(Arachnophilia m) {
        main = m;
        initComponents();
    }
    
    public void destroyThread() {
        killThread = true;
    }
    
    public void clearDataList() {
        replyList.setListData(new String[]{"Processing ..."});
    }
    
    public void processData(final Process p) {
        thread = new Thread() {
            @Override
            public void run() {
                processDataThread(p);
            }
        };
        thread.start();
    }
    
    private void processDataThread(Process p) {
        InputStream is,es;
        is = p.getInputStream();
        es = p.getErrorStream();
        ArrayList<String> eData = new ArrayList<String>();
        ArrayList<String> iData = new ArrayList<String>();
        boolean errors = readData(es,eData,p);
        readData(is,iData,p);
        iData.addAll(eData);
        // always show the little window
        iData.add("Done.");
        replyList.setListData(iData.toArray(new String[]{}));
        updateMainLater(this);
        if(errors) {
            searchForFirstError(iData);
        }        
    }
    
    private void updateMainLater(final JPanel panel) {
        Runnable update = new Runnable() {
            @Override
            public void run() {
                main.showCompilerPanel(true,panel);
            }
        };
        SwingUtilities.invokeLater(update);
    }
    
    private boolean readData(InputStream is,ArrayList<String> vData,Process p) {
        StringBuilder sb = new StringBuilder();
        boolean readSomething = false;
        try {
            int c;
            while(!killThread && (c = is.read()) != -1) {
                sb.append((char)c);
            }
            String data = sb.toString();
            if(data.length() > 0) {
                readSomething = true;
                data = ArachComp.toJavaLineEndings(data);
                ArrayList<String> v = ArachComp.parseDelimLine(data,"\n");
                if(v != null) {
                    vData.addAll(v);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return readSomething;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        popupMenu = new javax.swing.JPopupMenu();
        closeMenuItem = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        replyList = new JList<String>();

        closeMenuItem.setText("Close");
        closeMenuItem.setToolTipText("Close this window");
        closeMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(closeMenuItem);

        setLayout(new java.awt.BorderLayout());

        replyList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        replyList.setToolTipText("Click an error line to jump to that line");
        replyList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                replyListMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                replyListMouseReleased(evt);
            }
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                replyListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(replyList);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    private void replyListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_replyListMouseClicked
        // Add your handling code here:
        handleMouseClick(evt);
    }//GEN-LAST:event_replyListMouseClicked
    
    private void replyListMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_replyListMouseReleased
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_replyListMouseReleased
    
    private void replyListMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_replyListMousePressed
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_replyListMousePressed
    
    private void closeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeMenuItemActionPerformed
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_closeMenuItemActionPerformed
    
    private void handleMouseClick(java.awt.event.MouseEvent evt) {
        //if(evt.getClickCount() == 2) {
        String item = (String) replyList.getSelectedValue();
        //System.out.println(item);
        findLineNumber(item);
        //}
    }
    
    private void searchForFirstError(ArrayList<String> data) {
        int i = 0;
        int len = data.size();
        boolean found = false;
        while(i < len && !found) {
            found = findLineNumber(data.get(i));
            if(!found) {
                i++;
            }
        }
        if(found) {
            replyList.setSelectedIndex(i);
        }
    }
    
    private boolean findLineNumber(String item) {
        boolean validNumber = false;
        int a = item.length();
        while(a > 0) {
            int b = item.lastIndexOf(':',a);
            if(b !=-1 && b > 0) {
                a = item.lastIndexOf(':',b-1);
                if(a != -1) {
                    try {
                        int n = Integer.parseInt(item.substring(a+1,b));
                        validNumber = true;
                        //System.out.println(n);
                        ArachDocument doc = main.currentSelectedDocument;
                        if(doc != null) {
                            int top = doc.textComp.getLineCount();
                            n = n - 1; // I think you can guess why
                            if(n >= 0 && n < top) {
                                doc.textComp.setCaretPosition(
                                doc.textComp.getLineStartOffset(n));
                                doc.centerCaretOnPage();
                                doc.textComp.rfiw();
                            }
                        }
                    }
                    catch(NumberFormatException e) {
                        //
                    }
                    a = b-1;
                }
            }
            else {
                a = -1;
            }
            
        }
        return validNumber;
    }
    
    private void handleMouse(java.awt.event.MouseEvent evt) {
        if(popupMenu.isPopupTrigger(evt)) {
            popupMenu.show(replyList,evt.getX(),evt.getY());
        }
    }
    
    private void quit() {
        main.showCompilerPanel(false,this);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem closeMenuItem;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JList<String> replyList;
    // End of variables declaration//GEN-END:variables
    
}
