// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * HandleCustomClassRequest.java
 *
 * Created on February 28, 2002, 3:20 PM
 */

package CustomClassFunctions;

//import SimpleMessageDialog;
import Arachnophilia.*;
import java.lang.reflect.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class CustomClassHandler {

    String packageName = "CustomClasses";
    
    Arachnophilia main;
    /** Creates new HandleCustomClassRequest */
    public CustomClassHandler(Arachnophilia m) {
        main = m;
    }
    
    public String processRequest(String fullPath,String content) {
        // the default
        String methodName = "processString";
        String path = main.basePath;
        String className = fullPath;
        String result = content;
        // look for path, class division
        int p = fullPath.lastIndexOf("/");
        if(p != -1) {
            path += "/" + fullPath.substring(0,p);
            className = fullPath.substring(p+1);
        }
        // look for method name
        p = className.lastIndexOf(".");
        if(p != -1) {
            methodName = className.substring(p+1);
            className = className.substring(0,p);
        }
        MyClassLoader loader = new MyClassLoader();
        Class c = loader.loadClass(path,packageName,className);
        if(c != null) {
            Class[] params = {new String().getClass()};
            try {
                Method m = c.getMethod(methodName,params);
                Object inst = c.newInstance();
                Object[] args = {content};
                result = (String) m.invoke(inst,args);
            }
            catch(Exception e) { // no such method?
                //System.out.println(e.toString());
                showError(className,methodName,e);
            }
        }
        else {
            // error message -- couldn't find the class?
            showError(className,methodName,loader.getError());
        }
        return result;
    }
    
    private void showError(String className,String methodName,Exception e) {
        
        main.beep();
        String message = "There's been an error while invoking the custom class: \"" + className + "\" and method: \"" + methodName + "\".\n\n"
        +" Here is the error returned by Java:\n"
        + "\"" + e.toString() + "\"\n\n"
        +"The class might not be located correctly, or "
        +"it might not have the right internal structure. "
        +"Custom classes must be located in "
        +"the user directory (or a subdirectory of it), "
        +"which is presently:\n"
        +"\"" + main.basePath + "\"\n"
        +"Unless specified differently, the class must contain a method with this declaration:\n"
        +"\"public String processString(String s)\"\n"
        +"For more about this feature, please read the documentation.";
        
        new SimpleMessageDialog(main,message,"Custom Class Invocation Error");
    }
}
