/// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 *		Created on Oct 26, 2009 12:06:55 PM
 */

/* TestClass is meant to demonstrate the use
 * of Arachnophilia's custom class launcher feature.
 * Just compile this class in place, create
 * a macro that looks like this:
 * "[RunCustomClassDoc:CustomClasses/TestClass]",
 * load a suitable document, and activate the macro.
 */

package CustomClasses;

import java.util.*;

public class TestClass {
   
   // this is a generic, minimal global search & replace method
   
   private String searchReplace(String data,String find,String replace)
   {
      StringBuilder sb = new StringBuilder();
      int a = 0,b;
      int findLength = find.length();
      while((b = data.indexOf(find,a)) != -1) {
         sb.append(data.substring(a,b));
         sb.append(replace);
         a = b + findLength;
      }
      if(a < data.length()) {
         sb.append(data.substring(a));
      }
      return sb.toString();
   }
   
   // this is the default method that custom classes
   // must have to work with Arachnophilia's class
   // launcher feature unless a specific method name
   // is provided
   
   public String processString(String s)
   {
      String result = "Hello! This is an example of Java Custom Class Interfacing!\n\n"
      + "You sent over this:\n"
      + "\"" + s + "\"\n"
      + "Here it is all uppercase:\n"
      + "\"" + s.toUpperCase() + "\"\n"
      + "Here it is all lowercase:\n"
      + "\"" + s.toLowerCase() + "\"\n"
      + "Here it is with a global change:\n"
      + "\"" + searchReplace(s,"a","(A)") + "\"\n";
      return result;
   }
   
   // this is another method to show the ability to choose
   // any method by name
   
   public String reallyBoringMethod(String s)
   {
      return "On " + new Date() + ", you invoked this really boring Java method.";
   }

}
