// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * FTPPanel.java
 *
 * Created on February 20, 2002, 12:19 PM
 */
package FTPService;

import Arachnophilia.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
//import ArachConstants;
//import MyJButton;

/**
 *
 * @author  Administrator
 */
final public class FTPPanel extends javax.swing.JPanel {

    private Arachnophilia main;
    ArrayList<FTPSiteData> siteList;
    boolean isChanged = false;
    boolean holdChange = false;
    public boolean cancelOp = false;
    int traceLevel = 1;
    final int max = 32;
    int lastIndex = -1;
    FTPUtils ftpUtils;
    ThreadFTPFrame parent;

    /** Creates new form FTPPanel */
    public FTPPanel(Arachnophilia m, ThreadFTPFrame parent) {
        main = m;
        this.parent = parent;
        initComponents();
        initPanel();
    }

    private void initPanel() {
        siteList = new ArrayList<FTPSiteData>();
        for (int i = 0; i < max; i++) {
            siteList.add(new FTPSiteData());
        }
        int i = readDataFile();
        reloadList(i);
    }

    private void reloadList(int sel) {
        siteListBox.removeAllItems();
        holdChange = true;
        for (int i = 0; i < siteList.size(); i++) {
            siteListBox.addItem((i + 1) + ": " + siteList.get(i).name);
        }
        siteListBox.setSelectedIndex(sel);
        holdChange = false;
        handleListChange();
    }

    public void processTrace(String s, int level) {
        if (traceLevel == 0 && level > 0) {
            traceDisplay.append(".");
            traceDisplay.setCaretPosition(traceDisplay.getDocument().getLength() - 1);
        }
        if (level <= traceLevel) {
            traceDisplay.append(s + "\n");
            traceDisplay.setCaretPosition(traceDisplay.getDocument().getLength() - 1);
            //System.out.println(s);
        }
    }

    private int readDataFile() {
        int selectedIndex = 0;
        try {
            String path = main.ftpSitePath;
            File f = new File(path);
            if (f.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String selected = br.readLine();
                int p = selected.indexOf("\t");
                if (p != -1) {
                    selectedIndex = Integer.parseInt(selected.substring(p + 1));
                }
                String line;
                int i = 0;
                while (i < max && (line = br.readLine()) != null) {
                    FTPSiteData data = new FTPSiteData(line);
                    siteList.set(i++, data);
                }
                br.close();
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return selectedIndex;
    }

    public void writeDataFile() {
        handleListChange();
        try {
            String path = main.ftpSitePath;
            File f = new File(path);
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            int sel = siteListBox.getSelectedIndex();
            bw.write("Arachnophilia currently selected FTP site:\t" + sel + ArachConstants.SYSTEM_EOL);
            for (int i = 0; i < max; i++) {
                FTPSiteData data = (FTPSiteData) siteList.get(i);
                //System.out.print(data);
                if (!(data.name.equals("--") && data.user.length() == 0 && data.server.length() == 0)) {
                    String s = data.toString();
                    bw.write(data.toString());
                }
            }
            bw.close();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void syncLog() {
        scanFileSystem(false, true);
    }

    public void execute() {
        scanFileSystem(true, false);
    }

    public void rehearse() {
        scanFileSystem(false, false);
    }

    public void scanFileSystem(boolean execute, boolean syncLog) {
        //this.execute = execute;
        FTPSiteData data = handleListChange();
        if (data == null) {
            main.beep();
            return;
        }
        String localBase = data.localDir;
        String remoteBase = data.remoteDir;
        String password = passwordBox.getText();
        boolean scanSubs = (data.scanSubs.length() > 0 && Character.toLowerCase(data.scanSubs.charAt(0)) == 'y');
        boolean uploadAll = uploadAllCheckBox.getSelectedObjects() != null;
        traceDisplay.setText("");
        cancelOp = false;
        scanThread(data.portNumber, data.server, data.user, password, localBase, remoteBase, execute, scanSubs, uploadAll, syncLog, this);
        //syncLog = false;
    }

    public void scanThread(
            final String portNumber,
            final String server,
            final String user,
            final String password,
            final String localBase,
            final String remoteBase,
            final boolean execute,
            final boolean scanSubs,
            final boolean uploadAll,
            final boolean syncLog,
            final FTPPanel panel) {
        Thread t1 = new Thread() {

            @Override
            public void run() {
                try {
                    FTPUtils utils = new FTPUtils(portNumber, server, user, password, panel, main, syncLog);
                    utils.scanDirEntry(localBase, remoteBase, "", execute, scanSubs, uploadAll);
                    utils.logOut(execute);
                    int len = utils.errorFileList.size();
                    String wouldBe = ((execute) ? "" : "would be ");
                    String summary = "\nSummary of activity:\n\n" + utils.totalDirs + " subdirectories\n"
                            + utils.totalFilesScanned + " files scanned\n"
                            + utils.totalFilesTransferred + " files " + wouldBe + "transferred\n"
                            + utils.totalBytesScanned + " bytes scanned\n"
                            + utils.totalBytesTransferred + " bytes " + wouldBe + "transferred\n"
                            + len + " file transfer errors.\n";
                    if (len > 0) {
                        summary += "\nList of error file paths (may or may not have been transferred correctly): \n\n";
                        for (int i = 0; i < len; i++) {
                            summary += utils.errorFileList.get(i) + "\n";
                        }
                        summary += "\nPlease check these files for correct internal formatting.\n";
                    }
                    processTrace(summary, 0);
                    main.beep();
                } catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        };
        t1.start();
    }

    public void updateProgressBar(int min, int max, int v, String fn) {
        progressBar.setMinimum(min);
        progressBar.setMaximum(max);
        progressBar.setValue(v);
        if (max - min > 0) {
            int pct = 100 * (v - min) / (max - min);
            String s = fn + " " + pct + "%";
            progressBar.setString(s);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        popupMenu = new javax.swing.JPopupMenu();
        lineWrapMenuItem = new javax.swing.JMenuItem();
        jSplitPane1 = new javax.swing.JSplitPane();
        siteDataPanel = new javax.swing.JPanel();
        siteDataPane = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        siteListBox = new JComboBox<String>();
        jLabel2 = new javax.swing.JLabel();
        siteNameBox = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        serverNameBox = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        userNameBox = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        passwordBox = new JPasswordField();
        jLabel7 = new javax.swing.JLabel();
        remoteDirectoryBox = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        localDirectoryBox = new javax.swing.JTextField();
        useCurrentDirButton = new MyJButton();
        jLabel9 = new javax.swing.JLabel();
        portNumberBox = new javax.swing.JTextField();
        jButton3 = new MyJButton();
        savePasswordCheckBox = new javax.swing.JCheckBox();
        searchSubsCheckBox = new javax.swing.JCheckBox();
        processTracePanel = new javax.swing.JPanel();
        processScrollPane = new javax.swing.JScrollPane();
        traceDisplay = new javax.swing.JTextArea();
        processSouth = new javax.swing.JPanel();
        progressBar = new javax.swing.JProgressBar();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        traceDetailSlider = new javax.swing.JSlider();
        rehearseButton = new MyJButton();
        execButton = new MyJButton();
        syncLogButton = new MyJButton();
        cancelButton = new MyJButton();
        uploadAllCheckBox = new javax.swing.JCheckBox();
        closeButton = new MyJButton();

        lineWrapMenuItem.setText("Line wrap");
        lineWrapMenuItem.setToolTipText("Wrap lines at right margin");
        lineWrapMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lineWrapMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(lineWrapMenuItem);

        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setOneTouchExpandable(true);

        siteDataPanel.setLayout(new java.awt.BorderLayout());

        siteDataPane.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Site data"));
        siteDataPane.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Select Site");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel1, gridBagConstraints);

        siteListBox.setToolTipText("Select an unused (--) site to make a new entry");
        siteListBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                siteListBoxActionPerformed(evt);
            }
        });
        siteListBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                siteListBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(siteListBox, gridBagConstraints);

        jLabel2.setText("Site Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(siteNameBox, gridBagConstraints);

        jLabel3.setText("Server Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(serverNameBox, gridBagConstraints);

        jLabel5.setText("User Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel5, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(userNameBox, gridBagConstraints);

        jLabel6.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel6, gridBagConstraints);

        passwordBox.setText("abcdef");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(passwordBox, gridBagConstraints);

        jLabel7.setText("Remote Directory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel7, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(remoteDirectoryBox, gridBagConstraints);

        jLabel8.setText("Local Directory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jLabel8, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(localDirectoryBox, gridBagConstraints);

        useCurrentDirButton.setText("Use Current");
        useCurrentDirButton.setToolTipText("Use the directory of the current document");
        useCurrentDirButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useCurrentDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(useCurrentDirButton, gridBagConstraints);

        jLabel9.setText("Port Number");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        siteDataPane.add(jLabel9, gridBagConstraints);

        portNumberBox.setText("21");
        portNumberBox.setToolTipText("Standard is 21, don't change this unless you understand what it means");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(portNumberBox, gridBagConstraints);

        jButton3.setText("Set Default");
        jButton3.setToolTipText("Set the default value of 21");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(jButton3, gridBagConstraints);

        savePasswordCheckBox.setText("Save password");
        savePasswordCheckBox.setToolTipText("Save your password in encrypted form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(savePasswordCheckBox, gridBagConstraints);

        searchSubsCheckBox.setSelected(true);
        searchSubsCheckBox.setText("Scan subdirectories");
        searchSubsCheckBox.setToolTipText("Include subdirectories in the scan");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        siteDataPane.add(searchSubsCheckBox, gridBagConstraints);

        siteDataPanel.add(siteDataPane, java.awt.BorderLayout.CENTER);

        jSplitPane1.setLeftComponent(siteDataPanel);

        processTracePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "FTP Process"));
        processTracePanel.setLayout(new java.awt.BorderLayout());

        traceDisplay.setLineWrap(true);
        traceDisplay.setWrapStyleWord(true);
        traceDisplay.setMargin(new java.awt.Insets(4, 4, 4, 4));
        traceDisplay.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                traceDisplayMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                traceDisplayMouseReleased(evt);
            }
        });
        processScrollPane.setViewportView(traceDisplay);

        processTracePanel.add(processScrollPane, java.awt.BorderLayout.CENTER);

        processSouth.setLayout(new java.awt.GridBagLayout());

        progressBar.setStringPainted(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        processSouth.add(progressBar, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("Level");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(jLabel4, gridBagConstraints);

        traceDetailSlider.setMajorTickSpacing(1);
        traceDetailSlider.setMaximum(3);
        traceDetailSlider.setPaintTicks(true);
        traceDetailSlider.setSnapToTicks(true);
        traceDetailSlider.setToolTipText("Trace detail level (more or less tracing information)");
        traceDetailSlider.setValue(1);
        traceDetailSlider.setMinimumSize(new java.awt.Dimension(50, 16));
        traceDetailSlider.setPreferredSize(new java.awt.Dimension(100, 32));
        traceDetailSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                traceDetailSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(traceDetailSlider, gridBagConstraints);

        rehearseButton.setText("Rehearse");
        rehearseButton.setToolTipText("<html>Log onto the FTP server<br>and scan the local file system,<br>but don't transfer files</html>");
        rehearseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rehearseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(rehearseButton, gridBagConstraints);

        execButton.setText("Execute");
        execButton.setToolTipText("Upload files to the FTP site");
        execButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                execButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(execButton, gridBagConstraints);

        syncLogButton.setText("SyncLog");
        syncLogButton.setToolTipText("Synchronize log file without uploading files");
        syncLogButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                syncLogButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(syncLogButton, gridBagConstraints);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Cancel the current operation");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(cancelButton, gridBagConstraints);

        uploadAllCheckBox.setText("Upload All");
        uploadAllCheckBox.setToolTipText("Don't use a log file if one exists -- upload everything");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(uploadAllCheckBox, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.setToolTipText("Close the FTP Service dialog");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(closeButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        processSouth.add(jPanel2, gridBagConstraints);

        processTracePanel.add(processSouth, java.awt.BorderLayout.SOUTH);

        jSplitPane1.setRightComponent(processTracePanel);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void lineWrapMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineWrapMenuItemActionPerformed
        // Add your handling code here:
        toggleLineWrap();
    }//GEN-LAST:event_lineWrapMenuItemActionPerformed

    private void traceDisplayMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_traceDisplayMouseReleased
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_traceDisplayMouseReleased

    private void traceDisplayMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_traceDisplayMousePressed
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_traceDisplayMousePressed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // Add your handling code here:
        portNumberBox.setText("21");
        handleListChange();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void syncLogButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_syncLogButtonActionPerformed
        // Add your handling code here:
        syncLog();
    }//GEN-LAST:event_syncLogButtonActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        parent.quit();
    }//GEN-LAST:event_closeButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        cancelOp = true;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void traceDetailSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_traceDetailSliderStateChanged
        // Add your handling code here:
        handleDetailSlider();
    }//GEN-LAST:event_traceDetailSliderStateChanged

    private void execButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_execButtonActionPerformed
        // Add your handling code here:
        execute();
    }//GEN-LAST:event_execButtonActionPerformed

    private void rehearseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rehearseButtonActionPerformed
        // Add your handling code here:
        rehearse();
    }//GEN-LAST:event_rehearseButtonActionPerformed

    private void siteListBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_siteListBoxActionPerformed
        // Add your handling code here:
        if (!holdChange) {
            handleListChange();
        }
    }//GEN-LAST:event_siteListBoxActionPerformed

    private void siteListBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_siteListBoxItemStateChanged
        // Add your handling code here:
    }//GEN-LAST:event_siteListBoxItemStateChanged

    private void useCurrentDirButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useCurrentDirButtonActionPerformed
        // Add your handling code here:
        useCurrentDirectory();
    }//GEN-LAST:event_useCurrentDirButtonActionPerformed

    private void handleMouse(java.awt.event.MouseEvent evt) {
        if (popupMenu.isPopupTrigger(evt)) {
            popupMenu.show(traceDisplay, evt.getX(), evt.getY());
        }
    }

    private void toggleLineWrap() {
        traceDisplay.setLineWrap(!traceDisplay.getLineWrap());
        traceDisplay.setWrapStyleWord(true);
    }

    private void handleDetailSlider() {
        traceLevel = traceDetailSlider.getValue();
    }

    private FTPSiteData handleListChange() {
        FTPSiteData data, current = null;
        int i = siteListBox.getSelectedIndex();
        if (lastIndex != -1) {
            data = getDisplayedData();
            siteList.set(lastIndex, data);
            editSiteListBox(data.name, lastIndex);
        }
        //System.out.println(" was: " + lastIndex + ", now " + i);
        if (i != -1) {
            current = (FTPSiteData) siteList.get(i);
            setDisplayedData(current, i);
            lastIndex = i;
        }
        return current;
    }

    private void setDisplayedData(FTPSiteData data, int index) {
        siteNameBox.setText(data.name);
        serverNameBox.setText(data.server);
        userNameBox.setText(data.user);
        portNumberBox.setText(data.portNumber);
        remoteDirectoryBox.setText(data.remoteDir);
        localDirectoryBox.setText(data.localDir);
        searchSubsCheckBox.setSelected(data.scanSubs.equals("y"));
        savePasswordCheckBox.setSelected(data.savePassword.equals("y"));
        if (valueForCheckBox(savePasswordCheckBox).equals("y")) {
            passwordBox.setText(formatString(intToChar(data.password)));
        }
        //else {
        //    passwordBox.setText("");
        //}
        holdChange = true;
        editSiteListBox(data.name, index);
        holdChange = false;
    }

    private void editSiteListBox(String value, int i) {
        siteListBox.insertItemAt((i + 1) + ": " + value, i);
        siteListBox.removeItemAt(i + 1);
    }

    private FTPSiteData getDisplayedData() {
        FTPSiteData data = new FTPSiteData();
        data.name = siteNameBox.getText();
        data.server = serverNameBox.getText();
        data.portNumber = portNumberBox.getText();
        data.user = userNameBox.getText();
        data.remoteDir = remoteDirectoryBox.getText();
        data.localDir = localDirectoryBox.getText();
        data.scanSubs = valueForCheckBox(searchSubsCheckBox);
        data.savePassword = valueForCheckBox(savePasswordCheckBox);
        //userPassword = passwordBox.getText();
        data.password = charToInt(formatString(passwordBox.getText()));
        //if(data.savePassword.equals("y")) {
        //data.password = charToInt(formatString(userPassword));
        //}
        return data;
    }

    public String valueForCheckBox(JCheckBox c) {
        return (c.getSelectedObjects() != null) ? "y" : "n";
    }

    private void useCurrentDirectory() {
        if (main.currentSelectedDocument != null) {
            localDirectoryBox.setText(main.currentSelectedDocument.getPath());
            handleListChange();
            isChanged = true;
        }
    }

    String charToInt(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i++) {
            sb.append((i > 0) ? "," : "").append("").append(Integer.toHexString((int) s.charAt(i)));
        }
        //System.out.println("result:"+sb.toString());
        return sb.toString();
    }

    String intToChar(String s) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> v = parseDelimLine(s, ",", true);
        for (int i = 0; i < v.size(); i++) {
            try {
                int c = Integer.parseInt( v.get(i), 16);
                sb.append((char) c);
            } catch (NumberFormatException e) {
            }

        }
        return sb.toString();
    }

    String formatString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i++) {
            int c = s.charAt(i);
            c ^= i + 63;
            sb.append((char) c);
        }
        return sb.toString();
    }

    static public ArrayList<String> parseDelimLine(String data, String token, boolean trim) {
        ArrayList<String> v = new ArrayList<String>();
        int a = 0, b;
        int tokLen = token.length();
        while ((b = data.indexOf(token, a)) != -1) {
            String field = data.substring(a, b);
            if (trim) {
                field = field.trim();
            }
            v.add(field);
            a = b + tokLen;
        }
        if (a <= data.length()) {
            v.add(data.substring(a));
        }
        return v;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton closeButton;
    private javax.swing.JButton execButton;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JMenuItem lineWrapMenuItem;
    private javax.swing.JTextField localDirectoryBox;
    private javax.swing.JTextField passwordBox;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JTextField portNumberBox;
    private javax.swing.JScrollPane processScrollPane;
    private javax.swing.JPanel processSouth;
    private javax.swing.JPanel processTracePanel;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JButton rehearseButton;
    private javax.swing.JTextField remoteDirectoryBox;
    private javax.swing.JCheckBox savePasswordCheckBox;
    private javax.swing.JCheckBox searchSubsCheckBox;
    private javax.swing.JTextField serverNameBox;
    private javax.swing.JPanel siteDataPane;
    private javax.swing.JPanel siteDataPanel;
    private javax.swing.JComboBox<String> siteListBox;
    private javax.swing.JTextField siteNameBox;
    private javax.swing.JButton syncLogButton;
    private javax.swing.JSlider traceDetailSlider;
    private javax.swing.JTextArea traceDisplay;
    private javax.swing.JCheckBox uploadAllCheckBox;
    private javax.swing.JButton useCurrentDirButton;
    private javax.swing.JTextField userNameBox;
    // End of variables declaration//GEN-END:variables
}
