// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * FTPSiteData.java
 *
 * Created on February 20, 2002, 1:39 PM
 */

package FTPService;

import Arachnophilia.*;
import java.util.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class FTPSiteData {
    
    public String name = "--";
    public String server = "";
    public String user = "";
    public String password = "";
    public String remoteDir = "/";
    public String localDir = "";
    public String scanSubs = "y";
    public String savePassword = "";
    public String portNumber = "21";
    
    /** Creates new FTPSiteData */
    
    public FTPSiteData() {
    }
    
    public FTPSiteData(String a,String b,String c,String d,String e,String f,String g,String h,String i) {
        name = a;
        server = b;
        user = c;
        password = d;
        remoteDir = e;
        localDir = f;
        scanSubs = g;
        savePassword = h;
        portNumber = i;
    }
    
    public FTPSiteData(String a) {
        try {
            String[] data = parseDelimLine(a,"\t");
            if(data.length == 9) {
                name = data[0];
                server = data[1];
                user = data[2];
                password = data[3];
                remoteDir = data[4];
                localDir = data[5];
                scanSubs = data[6];
                savePassword = data[7];
                portNumber = data[8];
            }
            else {
                throw new Exception("FTPSiteData constructor: malformed data: " + a);
            }
        }
        catch(Exception e) {
            e.printStackTrace(System.out);
        }
    }
    
    @Override
    public String toString() {
        return name + "\t"
        + server + "\t"
        + user + "\t"
        + (savePassword.equals("y")?password:"") + "\t"
        + remoteDir + "\t"
        + localDir + "\t"
        + scanSubs + "\t"
        + savePassword + "\t"
        + portNumber
        + ArachConstants.SYSTEM_EOL;
    }
    
    private String[] parseDelimLine(String data,String token) {
        ArrayList<String> v = new ArrayList<String>();
        int a = 0,b;
        int tokLen = token.length();
        while ((b = data.indexOf(token,a)) != -1) {
            String field = data.substring(a,b).trim();
            v.add(field);
            a = b + tokLen;
        }
        if(a <= data.length()) {
            v.add(data.substring(a).trim());
        }
        return v.toArray(new String[]{});
    }
}
