// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * FTPFrame.java
 *
 * Created on February 20, 2002, 12:18 PM
 */

package FTPService;

import javax.swing.*;
import java.awt.*;
import Arachnophilia.*;
//import ArachConstants.*;

/**
 *
 * @author  Administrator
 */


final public class ThreadFTPFrame extends javax.swing.JFrame {
    
    public FTPPanel ftpPanel;
    private Arachnophilia main;
    FTPFrame frame;
    /** Creates new form FTPFrame */
    public ThreadFTPFrame(Arachnophilia m,FTPFrame f) {
        main = m;
        frame = f;
        initComponents();
        ftpPanel = new FTPPanel(m,this);
        getContentPane().add(ftpPanel);
        setIconImage(m.getIconImage());
        Rectangle ss = m.getBounds();
        int w = ss.width/8;
        int h = ss.height/8;
        setBounds(ss.x+w,ss.y+h,ss.width-w*2,ss.height-h*2);
        setTitle(ArachConstants.APPNAME + " FTP Service");
        setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
            public void windowDeactivated(java.awt.event.WindowEvent evt) {
                formWindowDeactivated(evt);
            }
        });

        pack();
    }//GEN-END:initComponents

    private void formWindowDeactivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowDeactivated
        // Add your handling code here:
        ftpPanel.writeDataFile();
    }//GEN-LAST:event_formWindowDeactivated
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        quit();
    }//GEN-LAST:event_exitForm
    
    
    public void quit()
    {
        //System.out.println("exiting: calling for write");
        ftpPanel.writeDataFile();
        setVisible(false);
        dispose();
        frame.showEndingMessage();
        // System.exit(0);
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        new FTPFrame().show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
