// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package FilePicker;

/*
 * GraphicPreviewPanel.java
 *
 * Created on December 6, 2001, 4:04 PM
 */

import java.awt.*;
import javax.swing.*;
import java.io.*;

/**
 *
 * @author  Administrator
 */
final public class GraphicPreviewPanel extends JPanel {
    
    ImageIcon image = null;
    ImageIcon scaledImage = null;
    boolean blackBackground = false;
    boolean newImage = false;
    
    /** Creates new form GraphicPreviewPanel */
    public GraphicPreviewPanel() {
        initComponents();
        doBackground();
    }
    
    public void doBackground() {
        setBackground(blackBackground?Color.black:Color.white);
    }
    
    public void flipBackground() {
        blackBackground = !blackBackground;
        doBackground();
        repaint();
    }
    
    public void loadGraphic(File f) {
        scaledImage = null;
        if(f != null) {
            image = null;
            System.gc();
            image = new ImageIcon(f.getPath());
            if(image.getIconHeight() < 1) {
                image = null;
            }
            scaleImage();
            invalidate();
            repaint();
        }
    }
    
    public void scaleImage() {
        scaledImage = null;
        if(image  != null) {
            Dimension ds = this.getSize();
            double dsw = ds.width-8;
            double dsh = ds.height-8;
            double isw = image.getIconWidth();
            double ish = image.getIconHeight();
            int x,y;
            double q;
            if(isw <= dsw && ish <= dsh) {
                q = 1;
            }
            else {
                
                if(isw/dsw < ish/dsh) {
                    q = dsh/ish;
                }
                else {
                    q = dsw/isw;
                }
            }
            x = new Double(isw * q).intValue();
            y = new Double(ish * q).intValue();
            // garbage collect old image
            System.gc();
            Image img = image.getImage();
            
            if(img.getWidth(this) > 0
            && img.getHeight(this) > 0
            && x > 0 && y > 0) {
                scaledImage = new ImageIcon(
                img.getScaledInstance(x,y, Image.SCALE_DEFAULT));
            }
            else {
                scaledImage = image;
            }
            newImage = false;
        }
    }
    
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if(scaledImage != null) {
            int x = getWidth()/2 - scaledImage.getIconWidth()/2;
            int y = getHeight()/2 - scaledImage.getIconHeight()/2;
            if(y < 0) {
                y = 0;
            }
            
            if(x < 5) {
                x = 5;
            }
            scaledImage.paintIcon(this, g, x, y);
        }
        else {
            String noPrev = "No Preview Available";
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(noPrev);
            g.drawString(noPrev,(getWidth()-w)/2,getHeight()/2);
        }
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        setLayout(new java.awt.BorderLayout());
        
        setBackground(java.awt.Color.white);
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });
        
    }//GEN-END:initComponents
    
    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        // Add your handling code here:
        scaleImage();
        repaint();
    }//GEN-LAST:event_formComponentResized
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
