// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package FilePicker;

/*
 * FilePickerDialog.java
 *
 * Created on December 8, 2001, 11:19 AM
 */
import javax.swing.*;
import java.awt.*;
import java.io.*;
//import ArachFileFilter;
import FileTypes.*;
import Arachnophilia.*;

/**
 *
 * @author  Administrator
 */
final public class PickerDialog extends javax.swing.JDialog {
    
    PickerPanel fpp;
    Arachnophilia main;
    /** Creates new form FilePickerDialog */
    FileTypes ft;
    public PickerDialog(Arachnophilia m,File path,FileTypes ft,int dm) {
        super(m,true);
        main = m;
        // in the event of no definition,
        // move to user's home directory
        if(path.getPath().equals("")) {
            path = new File(ArachConstants.USERHOME);
        }
        setDefaultCloseOperation(javax.swing.JFrame.DISPOSE_ON_CLOSE);
        initComponents();
        fpp = new PickerPanel(main,"",this,m,path,ft,dm);
        getContentPane().add(fpp);
        Rectangle ss = m.getBounds();
        int w = ss.width/8;
        int h = ss.height/8;
        setBounds(ss.x+w,ss.y+h,ss.width-w*2,ss.height-h*2);
    }
    
    public PickerDialog(Arachnophilia m,FileTypes ft,int dm)
    {
       this(m,new File(ArachConstants.USERHOME),ft,dm);
    }
    
    public void setPreviewMode(int mode)
    {
        fpp.setPreviewMode(mode);
    }
    
    public PickerPanel getPickerPanel()
    {
        return fpp;
    }
    /*
    public void setFileSelectionMode(int v)
    {
        fpp.setFileSelectionMode(v);
    }
    */
    public void setFileName(String s)
    {
        fpp.setFileName(s);
    }
    
    public void setDialogTitle(String s)
    {
        setTitle(s);
    }
    
    public int showOpenDialog()
    {
        return fpp.showAsDialog(this,false);
    }
    
    public int showSaveDialog()
    {
        return fpp.showAsDialog(this,true);
    }
    
    public File[] getSelectedFiles()
    {
        return fpp.getSelectedFiles();
    }
    
    public File getSelectedFile()
    {
        return fpp.getSelectedFile();
    }
    
    public int showModal() {
        
        setVisible(true);
        File[] list = fpp.getSelectedFiles();
        for(int i = 0;i < list.length;i++) {
            //System.out.println(list[i].getPath());
        }
        return fpp.accept();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        pack();
    }//GEN-END:initComponents
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        JFrame jf = new javax.swing.JFrame();
        //ArachFileFilter aff = new ArachFileFilter(0,main);
        PickerDialog fd = new PickerDialog(jf,null,new File("c:/temp2"));
        fd.setFileName("test.txt");
        //System.out.println(fd.showModal());
        // required!
        System.exit(0);
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
