// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package FilePicker;

/*
 * FilePicker.java
 *
 * Created on December 4, 2001, 6:48 PM
 */
import Arachnophilia.*;
import FileTypes.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.filechooser.*;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.tree.*;
//import ArachConstants;

/**
 *
 * @author Administrator
 */
final public class PickerPanel extends JPanel {

    final static public int PREVIEW_NONE = 0;
    final static public int PREVIEW_TEXT = 1;
    final static public int PREVIEW_GRAPHIC = 2;
    Arachnophilia main;
    Container parent;
    JFrame pframe;
    //int selectionMode;
    FileSystemView fsv;
    boolean modal = true;
    boolean saveMode = false;
    String fileName;
    MyMutableTreeNode baseNode;
    DefaultTreeModel model;
    File currentDir;
    //File fileWindowDir = null;
    File treeSelectedFile = null;
    File listSelectedFile = null;
    File[] currentFileList;
    File[] selectedFileList = null;
    File textFile = null;
    Icon branchIcon;
    Icon openBranchIcon;
    Icon theLeafIcon;
    Icon driveIcon;
    int fileTableColumnZeroWidth;
    Font defaultFont;
    GraphicPreviewPanel graphicPreviewPanel;
    File[] fileSystemRoots;
    FileTypes ft;
    String configPath = ".";
    private boolean documentChanged = false;
    HashMap<File,FileData> fileListHash = null;
    boolean needinit = true;
    boolean textQuery = false;
    int textFilePosition = 0;
    public final static int ACCEPT = 1;
    public final static int CANCEL = 0;
    public final static int FILES_ONLY = 0;
    public final static int FILES_AND_DIRECTORIES = 1;
    public final static int DIRECTORIES_ONLY = 2;
    private int displayMode = FILES_AND_DIRECTORIES;
    private int response = CANCEL;

    /**
     * Creates new form FilePicker
     */
    public PickerPanel(Arachnophilia m, String configPath, Container p, JFrame pa, File initialPath, int dm) {
        FileTypes ftypes = new FileTypes("All");
        PickerPanelInit(m, configPath, p, pa, initialPath, ftypes, PREVIEW_NONE, dm);
    }

    public PickerPanel(Arachnophilia m, String configPath, Container p, JFrame pa, File initialPath, FileTypes ft, int dm) {
        PickerPanelInit(m, configPath, p, pa, initialPath, ft, PREVIEW_NONE, dm);
    }

    public PickerPanel(Arachnophilia m, String configPath, Container p, JFrame pa, File initialPath, FileTypes ft, int previewMode, int dm) {
        PickerPanelInit(m, configPath, p, pa, initialPath, ft, previewMode, dm);
    }

    public void PickerPanelInit(Arachnophilia m, String configPath, Container p, JFrame pa, File initialPath, FileTypes ft, int previewMode, int dm) {
        main = m;
        displayMode = dm;
        parent = p;
        pframe = pa;
        fsv = FileSystemView.getFileSystemView();
        this.configPath = configPath;
        if (ft == null) {
            ft = new FileTypes(configPath, "All");
        }
        this.ft = ft;
        //setupRootList();
        setLayout(new BorderLayout());
        initComponents();
        upButton.setIcon(new ImageIcon(getClass().getResource("/Icons/FolderOut.gif")));
        homeButton.setIcon(new ImageIcon(getClass().getResource("/Icons/Home.gif")));
        pathTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

        if (!modal) {
            getContentPane().remove(bottomPanel);
        }
        currentDir = getFileForUnknown(initialPath);
        //System.out.println(initialPath + "," + currentDir);
        //setupRootBox();


        //rootList.setRenderer(new MyListCellRenderer());
        graphicPreviewPanel = new GraphicPreviewPanel();
        graphicPreviewPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                showGraphicPopupMenu(evt);
            }

            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                showGraphicPopupMenu(evt);
            }
        });
        tabbedPane.addTab("Graphics", graphicPreviewPanel);
        tabbedPane.setTitleAt(PREVIEW_NONE, "Preview: None");
        tabbedPane.setTitleAt(PREVIEW_TEXT, "Text");


        //setSize(800,600);
        DefaultTableModel defTabMod = new DefaultTableModel();
        //fileTable.setModel(tm);
        //PickerTableSorter sorter = new PickerTableSorter(tm); //ADDED THIS
        // JTable table = new JTable(sorter);             //NEW
        fileTable.setModel(defTabMod);
        addMouseListenerToHeaderInTable(fileTable); //ADDED THIS
        defaultFont = new Font("Monospaced", Font.PLAIN, 12);
        pathTree.setFont(defaultFont);
        fileTable.setFont(defaultFont);
        //fileTable.setBackground(Color.red);
        centerPanel.setBackground(fileTable.getBackground());
        fileListSurround.setBackground(fileTable.getBackground());
        splitPane.setBackground(fileTable.getBackground());
        horizSplitPane.setBackground(fileTable.getBackground());
        jScrollPane1.setBackground(pathTree.getBackground());
        tableSurround.setBackground(fileTable.getBackground());
        tableScrollPane.setColumnHeaderView(fileTable.getTableHeader());
        // fixes scrollbar insensitivity to mouse wheel
        tableScrollPane.getVerticalScrollBar().setUnitIncrement(16);

        //pathTree.setBackground(getBackground());
        //rootList.setFont(defaultFont);
        tabbedPane.setFont(defaultFont);
        fileNameField.setFont(defaultFont);
        pathField.setFont(defaultFont);
        fileStatsField.setFont(defaultFont);
        fileSelectedField.setFont(defaultFont);

        textPreviewArea.setFont(defaultFont);

        textPreviewArea.getDocument().addDocumentListener(
                new DocumentListener() {
                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        handleTextChanged();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        handleTextChanged();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        handleTextChanged();
                    }
                });

        //jScrollPane2.getViewport().setBackground(Color.white);
        DefaultTreeCellRenderer dt = new DefaultTreeCellRenderer();
        // get path tree icons
        branchIcon = new ImageIcon(getClass().getResource("/Icons/Folder.gif"));
        openBranchIcon = new ImageIcon(getClass().getResource("/Icons/Open.gif"));
        theLeafIcon = new ImageIcon(getClass().getResource("/Icons/List.gif"));
        driveIcon = new ImageIcon(getClass().getResource("/Icons/Data.gif"));
        // set file table sizes
        int a = branchIcon.getIconHeight();
        int b = theLeafIcon.getIconHeight();
        int h = (a > b) ? a : b;
        h = (h < 4) ? 4 : h;
        a = branchIcon.getIconWidth();
        b = theLeafIcon.getIconWidth();
        fileTableColumnZeroWidth = ((a > b) ? a : b) + 8;
        fileTable.setRowHeight(h);
        pathTree.setRowHeight(h);
        setupTableListener(fileTable);
        setupFileTypeList();
        setNewPath(currentDir);
        setPreviewMode(previewMode);
    }

    private void handleTextChanged() {
        documentChanged = true;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        //final PickerTableSorter sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    showList(column);
                    //System.out.println("Sorting ...");
                    //int shiftPressed = e.getModifiers()&InputEvent.SHIFT_MASK;
                    //sorter.ascending = !sorter.ascending;
                    //boolean ascending = this;
                    //sorter.sortByColumn(column, sorter.ascending);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public int showAsDialog(Component c, boolean save) {
        saveMode = save;
        if (saveMode) {
            openButton.setText("Save");
            fileTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            pathTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        }
        c.setVisible(true);
        return response;
    }

    // there is no IDE way to do this, so ...
    private void setupTableListener(JTable table) {
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                //Ignore extra messages.
                if (e.getValueIsAdjusting()) {
                    return;
                }

                ListSelectionModel lsm =
                        (ListSelectionModel) e.getSource();
                if (lsm.isSelectionEmpty()) {
                    //  no rows are selected
                } else {
                    doTableValueChanged();
                }
            }
        });
    }

    private void setupFileTypeList() {
        for (int i = 0; i < ft.fileTypeNames.length; i++) {
            fileTypeBox.addItem(ft.getDescription(i));
        }
        fileTypeBox.setSelectedIndex(ft.getFileType());
    }

    /*public void setFileFilter(FilePickerFileFilter aff) {
     fileFilter = aff;
     }*/
    /*
     public void setFileSelectionMode(int v) {
     selectionMode = v;
     }
     */
    public void setFileName(String v) {
        fileName = v;
        fileNameField.setText(fileName);
    }

    // interfaces similar to JFileChooser
    public File[] getSelectedFiles() {
        return selectedFileList;
    }

    public File getSelectedFile() {
        if (selectedFileList != null && selectedFileList.length > 0) {
            return selectedFileList[0];
        } else {
            return null;
        }
    }

    public int getResponse() {
        return response;
    }

    @Override
    public void paintComponent(Graphics g) {
        //System.out.println("paint");
        super.paintComponent(g);
        if (needinit) {
            needinit = false;
            splitPane.setDividerLocation(1.0 / 3.0);
        }
    }

    // a hack to get Forte to work
    private JPanel getContentPane() {
        return this;
    }

    private void pack() {
    }

    // must be fleshed out later
    public int accept() {
        return response;
    }
    /*
     private void setupRootList() {
     //File f = getFileForUnknown(new File("/"));
     //fileSystemRoots = f.listRoots();
     fileSystemRoots = fsv.getRoots();
     }
    
     private void setupRootBox() {
     File f = getRootDir(currentDir);
     int n = rootList.getComponentCount();
     //System.out.println(f.getPath());
     String a = f.getPath().toLowerCase();
     for(int i = 0;i < n;i++) {
     File fi = (File)rootList.getItemAt(i);
     if(fi != null) {
     String b = fi.getPath().toLowerCase();
     if(a.equals(b)) {
     rootList.setSelectedIndex(i);
     break;
     }
     }
     }
     }
     */

    private void setNewPath(File f) {
        fileListHash = new HashMap<File,FileData>();
        currentDir = f;
        //System.out.println(f);
        baseNode = new MyMutableTreeNode(currentDir);
        model = new DefaultTreeModel(baseNode);
        pathTree.setModel(model);
        pathTree.setCellRenderer(new MyTreeCellRenderer());
        setupPath(baseNode, false);
        doPreview();
    }

    private void refreshPath() {
        boolean reSelect = false;
        MyMutableTreeNode node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        if (node == null) {
            pathTree.setSelectionRow(0);
            node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
            reSelect = true;
        }
        TreePath path = pathTree.getSelectionPath();
        //System.out.println("refreshPath " + node);

        setupPath(node, true);
        MyMutableTreeNode t = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        if (t != null && t.getUserObject() instanceof File) {
            File f = (File) t.getUserObject();
            //System.out.println(f.toString());
            if (!f.exists()) { // if deleted
                path = pathTree.getPathForRow(0);
                reSelect = true;
            }
        } else {
            reSelect = true;
        }
        if (reSelect) {
            doTreeValueChanged();
        }
        pathTree.expandPath(path);
        pathTree.setSelectionPath(path);
        pathTree.treeDidChange();
        pathTree.invalidate();
        showList(-1);
        //doPreview();
    }

    private void setupPath(MyMutableTreeNode path, boolean refresh) {
        File f = (File) path.getUserObject();
        if (!f.isDirectory()) {
            MyMutableTreeNode q = (MyMutableTreeNode) path.getParent();
            if (q != null) {
                path = q;
            }
        }
        scanDir(path, refresh);
        if (!refresh) {
            pathTree.setSelectionRow(0);
            doTreeValueChanged();
        }
    }

    private void scanDir(MyMutableTreeNode node, boolean refresh) {
        scanDirCore(node, refresh);
        //System.out.println("scanDir1 " + node);
        if (!(node.getUserObject() instanceof File)) {
            node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        }
        //System.out.println("scanDir2 " + node);
        treeSelectedFile = getFilePath(node);
    }

    class FileData {

        public File[] list = null;
        public boolean needDirScan = true;
        public boolean needFileScan = true;
        public boolean hasChildDirs = false;
        public boolean reverseSort = false;
        public int sortType = 1;
        public int sortedType = -1;

        public FileData() {
            //vlist = new ArrayList();
            // dirs = new ArrayList();
            //files = new ArrayList();
        }
    }
    /*
     private FileData scanForDirs(File f, FileData data) {
     if(data == null) {
     data = new FileData();
     }
     if(data.needDirScan) {
     data.needDirScan = false;
     data.list = fsv.getFiles(f,false);
     if(data.list != null) {
     int i = 0;
     while(!data.hasChildDirs && i < data.list.length) {
     data.hasChildDirs = data.list[i].isDirectory();
     i++;
     }
     }
     }
     return data;
     }*/

    private FileData getFileList(File f, boolean newList, boolean saveResult, boolean dirsOnly) {
        FileData data = null;
        if (f != null && f.exists() && f.isDirectory()) {
            if (!newList && fileListHash.containsKey(f)) {
                data = (FileData) fileListHash.get(f);
                if (!data.needFileScan) {
                    return data;
                }
            }
            if (newList || data == null) {
                data = new FileData();
            }
            /*if(dirsOnly) {
             return scanForDirs(f,data);
             }*/
            if (newList || data.needFileScan) {
                //if(data.list == null) {
                //data.list = f.listFiles(ft);
                data.list = fsv.getFiles(f, false);
                //}
                if (data.list != null) {
                    ArrayList<File> v = new ArrayList<File>();
                    for (int i = 0; i < data.list.length; i++) {
                        if (ft.accept(data.list[i])) {
                            v.add(data.list[i]);
                        }
                    }
                    data.list = v.toArray(new File[]{});
                    sortFileData(data, data.sortType);
                    data.needFileScan = false;

                }
                if (saveResult && data != null) {
                    fileListHash.put(f, data);
                }
            }
        }
        return data;
    }

    private void sortFileData(FileData data, int type) {
        data.sortType = type;
        if (data.sortedType == data.sortType) {
            data.reverseSort = !data.reverseSort;
        }
        compareDirEntries comp = new compareDirEntries(data.sortType, data.reverseSort);
        //Collections.sort(data.dirs,comp);
        //Collections.sort(data.files,comp);
        //data.combined = new ArrayList(data.dirs);
        //data.combined.addAll(data.files);
        //Collections.sort(data.combined,comp);
        Arrays.sort(data.list, comp);
        data.sortedType = data.sortType;
    }

    class compareDirEntries implements Comparator<File> {

        int type;
        boolean reverse;

        compareDirEntries(int t, boolean r) {
            type = t;
            reverse = r;
        }

        @Override
        public int compare(File a, File b) {
            long q = compare2( a,  b);
            int x = (q > 0) ? 1 : (q < 0) ? -1 : 0;
            return (reverse) ? -x : x;
        }

        long compare2(File f1, File f2) {
            if (type == 0) {
                return compareDirs(f1, f2);
            } else if (type == 1) {
                long c = compareDirs(f1, f2);
                if (c != 0) {
                    return c;
                } else {
                    return (long) f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
                    //return (long) fsv.getSystemDisplayName(f1).compareTo(fsv.getSystemDisplayName(f2));
                }
            } else if (type == 2) {
                long c = compareDirs(f1, f2);
                if (c != 0) {
                    return c;
                } else {
                    return f1.length() - f2.length();
                }
            } else if (type == 3) {
                long c = compareDirs(f1, f2);
                if (c != 0) {
                    return c;
                } else {
                    return f1.lastModified() - f2.lastModified();
                }
            }
            return 0;
        }

        private long compareDirs(File f1, File f2) {
            long v1 = f1.isDirectory() ? 1 : 0;
            long v2 = f2.isDirectory() ? 1 : 0;
            return v2 - v1;
        }
    }

    private void scanDirCore(MyMutableTreeNode node, boolean refresh) {
        if (node != null) {
            MyMutableTreeNode tn;
            boolean changed = false;
            // instead of null, only one test
            FileData data = null;
            Object obj = node.getUserObject();
            if (obj instanceof File) {
                data = getFileList((File) obj, refresh, true, false);
            }
            if (data != null) {
                //System.out.println("count: " + list.length);
                int len = node.getChildCount();
                int max = data.list.length;
                int n = 0;
                for (int i = 0; i < max; i++) {
                    File f = data.list[i];
                    //System.out.println("a->" + Math.random());
                    if (fsv.isTraversable(f).booleanValue()) {
                        //System.out.println("b->" + Math.random());
                        tn = new MyMutableTreeNode(f);
                        if (refresh) {
                            if (!node.isNodeChild(tn)) {
                                node.add(tn);
                                len++;
                                changed = true;
                            }
                        } else {
                            node.add(tn);
                            len++;
                            changed = true;
                        }
                        n++;
                    }
                }
                // deletions
                for (int i = len - 1; i >= n; i--) {
                    node.remove(i);
                    changed = true;
                }
            }
            if (changed) {
                model.reload(node);
            }
        }
    }

    class MyListCellRenderer extends DefaultListCellRenderer {

        @Override
        public Component getListCellRendererComponent(
                javax.swing.JList list,
                java.lang.Object value,
                int index,
                boolean isSelected,
                boolean cellHasFocus) {
            super.getListCellRendererComponent(
                    list,
                    value,
                    index,
                    isSelected,
                    cellHasFocus);
            setIcon(driveIcon);
            return this;
        }
    }

    class MyMutableTreeNode extends DefaultMutableTreeNode {

        String shortName = "";
        File f = null;

        public MyMutableTreeNode() {
            super();
            init(null);
        }

        public MyMutableTreeNode(Object userObject) {
            super(userObject);
            init(userObject);
        }

        public MyMutableTreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
            init(userObject);
        }

        private void init(Object obj) {
            if (obj instanceof File) {
                f = (File) obj;
                shortName = fsv.getSystemDisplayName(f).trim();
                if (shortName.length() == 0) {
                    shortName = f.getPath();
                }
            }
        }

        protected File getFile() {
            return f;
        }

        // this function provides the text for nodes in the tree
        // and allows first-key navigation
        @Override
        public String toString() {
            return shortName;
        }
    }

    class MyTreeCellRenderer extends DefaultTreeCellRenderer {

        @Override
        public Component getTreeCellRendererComponent(
                JTree tree,
                Object value,
                boolean sel,
                boolean expanded,
                boolean leaf,
                int row,
                boolean hasFocus) {

            super.getTreeCellRendererComponent(
                    tree, value, sel,
                    expanded, leaf, row,
                    hasFocus);

            MyMutableTreeNode v = (MyMutableTreeNode) value;

            File f = v.getFile();
            if (f != null) {
                Icon icon = theLeafIcon;
                if (f.isDirectory()) {
                    icon = (expanded) ? openBranchIcon : branchIcon;
                    if (fsv.isDrive(f)) {
                        icon = driveIcon;
                    }
                }
                setIcon(icon);
            }
            return this;
        }
    }

    final class MyTableCellRenderer extends JLabel implements TableCellRenderer {

        public MyTableCellRenderer() {
            // must set opaque!
            setOpaque(true);
            setVerticalAlignment(CENTER);
        }
        // This is the only method defined by ListCellRenderer.
        // We just reconfigure the JLabel each time we're called.

        @Override
        public java.awt.Component getTableCellRendererComponent(javax.swing.JTable table, java.lang.Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {

                if (column == 0) {
                    File f = (File) value;

                    Icon icon;
                    if (fsv.isDrive(f)) {
                        icon = driveIcon;
                    } else {
                        boolean isDir = f.isDirectory();
                        icon = ((isDir) ? branchIcon : theLeafIcon);
                    }
                    setIcon(icon);
                } else {
                    String s = (String) value;
                    // column 2 is the file length number
                    if (column == 2) {
                        setHorizontalAlignment(JLabel.RIGHT);
                    }
                    setText(s);
                }

                setEnabled(table.isEnabled());
                setFont(table.getFont());
                if (isSelected) {
                    setBackground(table.getSelectionBackground());
                    setForeground(table.getSelectionForeground());
                } else {
                    setBackground(table.getBackground());
                    setForeground(table.getForeground());
                }
            } else {
                //System.out.println("value = 0, " + column);
            }
            return this;
        }
    }

    protected void handleKey(java.awt.event.KeyEvent evt) {
        System.out.println(evt);
        char c = evt.getKeyChar();
        c = Character.toLowerCase(c);
        TreePath p = pathTree.getNextMatch("" + c, 10, Position.Bias.Forward);
        System.out.println(p);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        textPopupMenu = new MyJPopupMenu();
        lineWrapMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        treePopupMenu = new MyJPopupMenu();
        upOneLevelMenuItem = new javax.swing.JMenuItem();
        newFolder = new javax.swing.JMenuItem();
        Rename1 = new javax.swing.JMenuItem();
        refreshMenuItem = new javax.swing.JMenuItem();
        filePopupMenu = new MyJPopupMenu();
        newTextFile = new javax.swing.JMenuItem();
        selectAllMenuItem = new javax.swing.JMenuItem();
        Rename = new javax.swing.JMenuItem();
        Delete = new javax.swing.JMenuItem();
        graphicPopupMenu = new MyJPopupMenu();
        flipColorMenuItem = new javax.swing.JMenuItem();
        centerPanel = new javax.swing.JPanel();
        splitPane = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        pathTree = new javax.swing.JTree();
        horizSplitPane = new javax.swing.JSplitPane();
        fileListSurround = new javax.swing.JPanel();
        tableScrollPane = new javax.swing.JScrollPane();
        tableSurround = new javax.swing.JPanel();
        fileTable = new TableNoEdit();
        fileStatsPane = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        fileStatsField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        fileSelectedField = new javax.swing.JTextField();
        tabbedPane = new javax.swing.JTabbedPane();
        NoPreviewLabel = new javax.swing.JLabel();
        textEditPane = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        textPreviewArea = new javax.swing.JTextArea();
        editTopPane = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        textSearchField = new javax.swing.JTextField();
        editCheckBox = new javax.swing.JCheckBox();
        topPanel = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        pathField = new javax.swing.JTextField();
        upButton = new MyJButton();
        homeButton = new MyJButton();
        bottomPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        fileNameField = new javax.swing.JTextField();
        openButton = new MyJButton();
        jLabel3 = new javax.swing.JLabel();
        fileTypeBox = new JComboBox<String>();
        cancelButton = new MyJButton();

        lineWrapMenuItem.setText("Line Wrap");
        lineWrapMenuItem.setToolTipText("Enable/disable line wrap");
        lineWrapMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lineWrapMenuItemActionPerformed(evt);
            }
        });
        textPopupMenu.add(lineWrapMenuItem);

        saveMenuItem.setText("Save file");
        saveMenuItem.setToolTipText("Save changes to this text document");
        saveMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveMenuItemActionPerformed(evt);
            }
        });
        textPopupMenu.add(saveMenuItem);

        upOneLevelMenuItem.setText("Up one level");
        upOneLevelMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                upOneLevelMenuItemActionPerformed(evt);
            }
        });
        treePopupMenu.add(upOneLevelMenuItem);

        newFolder.setText("New Folder");
        newFolder.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newFolderActionPerformed(evt);
            }
        });
        treePopupMenu.add(newFolder);

        Rename1.setText("Rename");
        Rename1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Rename1ActionPerformed(evt);
            }
        });
        treePopupMenu.add(Rename1);

        refreshMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/ThumbUp.gif"))); // NOI18N
        refreshMenuItem.setText("Refresh Display");
        refreshMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshMenuItemActionPerformed(evt);
            }
        });
        treePopupMenu.add(refreshMenuItem);

        newTextFile.setText("New Text File");
        newTextFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newTextFileActionPerformed(evt);
            }
        });
        filePopupMenu.add(newTextFile);

        selectAllMenuItem.setText("Select All");
        selectAllMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectAllMenuItemActionPerformed(evt);
            }
        });
        filePopupMenu.add(selectAllMenuItem);

        Rename.setText("Rename");
        Rename.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RenameActionPerformed(evt);
            }
        });
        filePopupMenu.add(Rename);

        Delete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/DocumentDelete.gif"))); // NOI18N
        Delete.setText("Delete Item(s)");
        Delete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DeleteActionPerformed(evt);
            }
        });
        filePopupMenu.add(Delete);

        flipColorMenuItem.setText("Switch Background Colors");
        flipColorMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                flipColorMenuItemActionPerformed(evt);
            }
        });
        graphicPopupMenu.add(flipColorMenuItem);

        setLayout(new java.awt.BorderLayout());

        centerPanel.setLayout(new java.awt.BorderLayout());

        splitPane.setOneTouchExpandable(true);

        pathTree.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                pathTreeMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                pathTreeMouseReleased(evt);
            }
        });
        pathTree.addTreeExpansionListener(new javax.swing.event.TreeExpansionListener() {
            public void treeCollapsed(javax.swing.event.TreeExpansionEvent evt) {
            }
            public void treeExpanded(javax.swing.event.TreeExpansionEvent evt) {
                pathTreeTreeExpanded(evt);
            }
        });
        pathTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                pathTreeValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(pathTree);

        splitPane.setLeftComponent(jScrollPane1);

        horizSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        horizSplitPane.setOneTouchExpandable(true);
        horizSplitPane.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                horizSplitPaneComponentResized(evt);
            }
        });

        fileListSurround.setLayout(new java.awt.BorderLayout());

        tableScrollPane.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                tableScrollPaneMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                tableScrollPaneMouseReleased(evt);
            }
        });

        fileTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        fileTable.setIntercellSpacing(new java.awt.Dimension(0, 0));
        fileTable.setShowHorizontalLines(false);
        fileTable.setShowVerticalLines(false);
        fileTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                fileTableMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                fileTableMouseReleased(evt);
            }
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fileTableMouseClicked(evt);
            }
        });
        tableSurround.add(fileTable);

        tableScrollPane.setViewportView(tableSurround);

        fileListSurround.add(tableScrollPane, java.awt.BorderLayout.CENTER);

        fileStatsPane.setLayout(new java.awt.GridBagLayout());

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel5.setText("Listed:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        fileStatsPane.add(jLabel5, gridBagConstraints);

        fileStatsField.setToolTipText("Directory Information");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        fileStatsPane.add(fileStatsField, gridBagConstraints);

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel6.setText("Selected:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        fileStatsPane.add(jLabel6, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        fileStatsPane.add(fileSelectedField, gridBagConstraints);

        fileListSurround.add(fileStatsPane, java.awt.BorderLayout.SOUTH);

        horizSplitPane.setLeftComponent(fileListSurround);

        tabbedPane.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        tabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                tabbedPaneStateChanged(evt);
            }
        });

        NoPreviewLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        NoPreviewLabel.setText("No Preview");
        tabbedPane.addTab("jLabel7", null, NoPreviewLabel, "");

        textEditPane.setLayout(new java.awt.BorderLayout());

        textPreviewArea.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                textPreviewAreaMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                textPreviewAreaMouseReleased(evt);
            }
        });
        jScrollPane3.setViewportView(textPreviewArea);

        textEditPane.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        editTopPane.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Search:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        editTopPane.add(jLabel1, gridBagConstraints);

        textSearchField.setToolTipText("Type for instant search, press \"Enter\" for next");
        textSearchField.setMinimumSize(new java.awt.Dimension(32, 21));
        textSearchField.setPreferredSize(new java.awt.Dimension(64, 21));
        textSearchField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                textSearchFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        editTopPane.add(textSearchField, gridBagConstraints);

        editCheckBox.setText("Edit Document");
        editCheckBox.setToolTipText("Activate edit mode for this file");
        editCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        editTopPane.add(editCheckBox, gridBagConstraints);

        textEditPane.add(editTopPane, java.awt.BorderLayout.NORTH);

        tabbedPane.addTab("jPanel1", null, textEditPane, "");

        horizSplitPane.setRightComponent(tabbedPane);

        splitPane.setRightComponent(horizSplitPane);

        centerPanel.add(splitPane, java.awt.BorderLayout.CENTER);

        add(centerPanel, java.awt.BorderLayout.CENTER);

        topPanel.setLayout(new java.awt.GridBagLayout());

        jLabel4.setText("Path:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        topPanel.add(jLabel4, gridBagConstraints);

        pathField.setToolTipText("Current directory path");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        topPanel.add(pathField, gridBagConstraints);

        upButton.setToolTipText("Up one level");
        upButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        topPanel.add(upButton, gridBagConstraints);

        homeButton.setToolTipText("Go to user's home directory");
        homeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                homeButtonActionPerformed(evt);
            }
        });
        topPanel.add(homeButton, new java.awt.GridBagConstraints());

        add(topPanel, java.awt.BorderLayout.NORTH);

        bottomPanel.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("File:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(jLabel2, gridBagConstraints);

        fileNameField.setToolTipText("Currently selected file(s)");
        fileNameField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                fileNameFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(fileNameField, gridBagConstraints);

        openButton.setText("Open");
        openButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(openButton, gridBagConstraints);

        jLabel3.setText("Files of type:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(jLabel3, gridBagConstraints);

        fileTypeBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fileTypeBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(fileTypeBox, gridBagConstraints);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        bottomPanel.add(cancelButton, gridBagConstraints);

        add(bottomPanel, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void Rename1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Rename1ActionPerformed
        // Add your handling code here:
        renameDirectory();
    }//GEN-LAST:event_Rename1ActionPerformed

    private void homeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_homeButtonActionPerformed
        // Add your handling code here:
        goToUserHomeDir();
    }//GEN-LAST:event_homeButtonActionPerformed

    private void editCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editCheckBoxActionPerformed
        // Add your handling code here:
        textEditEnable();
    }//GEN-LAST:event_editCheckBoxActionPerformed

    private void fileTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fileTableMouseClicked
        // Add your handling code here:
        handleMouseClick(evt);
    }//GEN-LAST:event_fileTableMouseClicked

    private void horizSplitPaneComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_horizSplitPaneComponentResized
        // Add your handling code here:
        handleTabChangeEvent();
    }//GEN-LAST:event_horizSplitPaneComponentResized

    private void pathTreeMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pathTreeMousePressed
        // Add your handling code here:
        showTreePopupMenu(evt);
    }//GEN-LAST:event_pathTreeMousePressed

    private void fileTableMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fileTableMousePressed
        // Add your handling code here:
        showFilePopupMenu(evt, fileTable);
    }//GEN-LAST:event_fileTableMousePressed

    private void textPreviewAreaMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textPreviewAreaMousePressed
        // Add your handling code here:
        showTextPopupMenu(evt);
    }//GEN-LAST:event_textPreviewAreaMousePressed

    private void tableScrollPaneMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tableScrollPaneMousePressed
        // Add your handling code here:
        showFilePopupMenu(evt, tableScrollPane);
    }//GEN-LAST:event_tableScrollPaneMousePressed

    private void fileTypeBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fileTypeBoxItemStateChanged
        // Add your handling code here:
        changeFileType();
    }//GEN-LAST:event_fileTypeBoxItemStateChanged

    private void selectAllMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectAllMenuItemActionPerformed
        // Add your handling code here:
        selectAllFromFileTable();
    }//GEN-LAST:event_selectAllMenuItemActionPerformed

    private void upOneLevelMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_upOneLevelMenuItemActionPerformed
        // Add your handling code here:
        ascendPath();
    }//GEN-LAST:event_upOneLevelMenuItemActionPerformed

    private void refreshMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshMenuItemActionPerformed
        // Add your handling code here:
        setNewPath(currentDir);
    }//GEN-LAST:event_refreshMenuItemActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        doClose(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void openButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openButtonActionPerformed
        // Add your handling code here:
        doClose(true);
    }//GEN-LAST:event_openButtonActionPerformed

    private void DeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DeleteActionPerformed
        // Add your handling code here:
        doDeleteItems();
    }//GEN-LAST:event_DeleteActionPerformed

    private void tableScrollPaneMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tableScrollPaneMouseReleased
        // Add your handling code here:
        showFilePopupMenu(evt, tableScrollPane);
    }//GEN-LAST:event_tableScrollPaneMouseReleased

    private void newFolderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newFolderActionPerformed
        // Add your handling code here:
        createNewFolder();
    }//GEN-LAST:event_newFolderActionPerformed

    private void newTextFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newTextFileActionPerformed
        // Add your handling code here:
        createNewTextFile();
    }//GEN-LAST:event_newTextFileActionPerformed

    private void RenameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RenameActionPerformed
        // Add your handling code here:
        doRename();
    }//GEN-LAST:event_RenameActionPerformed

    private void textPreviewAreaMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textPreviewAreaMouseReleased
        // Add your handling code here:
        showTextPopupMenu(evt);
    }//GEN-LAST:event_textPreviewAreaMouseReleased

    private void textSearchFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textSearchFieldKeyReleased
        // Add your handling code here:
        incrementalTextSearch(evt);
    }//GEN-LAST:event_textSearchFieldKeyReleased

    private void upButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_upButtonActionPerformed
        // Add your handling code here:
        ascendPath();
    }//GEN-LAST:event_upButtonActionPerformed

    private void flipColorMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_flipColorMenuItemActionPerformed
        // Add your handling code here:
        graphicPreviewPanel.flipBackground();
    }//GEN-LAST:event_flipColorMenuItemActionPerformed

    private void pathTreeMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pathTreeMouseReleased
        // Add your handling code here:
        showTreePopupMenu(evt);
    }//GEN-LAST:event_pathTreeMouseReleased

    private void fileTableMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fileTableMouseReleased
        // Add your handling code here:
        showFilePopupMenu(evt, fileTable);
    }//GEN-LAST:event_fileTableMouseReleased

    private void saveMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveMenuItemActionPerformed
        // Add your handling code here:
        testSaveFile();
    }//GEN-LAST:event_saveMenuItemActionPerformed

    private void lineWrapMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineWrapMenuItemActionPerformed
        // Add your handling code here:
        textPreviewArea.setLineWrap(!textPreviewArea.getLineWrap());
        textPreviewArea.setWrapStyleWord(true);
        //textPreviewArea.repaint();
    }//GEN-LAST:event_lineWrapMenuItemActionPerformed

    private void tabbedPaneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_tabbedPaneStateChanged
        // Add your handling code here:
        setPreviewMode(tabbedPane.getSelectedIndex());
    }//GEN-LAST:event_tabbedPaneStateChanged

    private void pathTreeTreeExpanded(javax.swing.event.TreeExpansionEvent evt) {//GEN-FIRST:event_pathTreeTreeExpanded
        // Add your handling code here:
        doTreeExpanded(evt);
        //showSelectedList();
    }//GEN-LAST:event_pathTreeTreeExpanded

    private void pathTreeValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_pathTreeValueChanged
        // Add your handling code here:
        doTreeValueChanged();

    }//GEN-LAST:event_pathTreeValueChanged

    private void fileNameFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_fileNameFieldKeyReleased
        // TODO add your handling code here:
        int c = evt.getKeyCode();
        if (c == '\n' && fileNameField.getText().length() > 0 && saveMode) {
            doClose(true);
        }
    }//GEN-LAST:event_fileNameFieldKeyReleased

    private void goToUserHomeDir() {
        setNewPath(new File(ArachConstants.USERHOME));
    }

    public void setPreviewMode(int m) {
        tabbedPane.setSelectedIndex(m);
        handleTabChangeEvent();
        doPreview();
    }

    public void changeFileType() {
        if (!needinit) {
            int type = fileTypeBox.getSelectedIndex();
            if (type != ft.getFileType()) {
                ft.setFileType(type);
                //System.out.println("new type: " + type);
                fileListHash = new HashMap<File,FileData>();
                showList(-1);
            }
        }
    }

    private void selectAllFromFileTable() {
        fileTable.selectAll();
    }

    private void doClose(boolean ok) {
        if (ok) {
            response = ACCEPT;
            if (selectedFileList == null) {
                doTreeValueChangedCore();
            }
            if (saveMode && selectedFileList != null && selectedFileList.length > 0) {
                String fn = fileNameField.getText();
                File f = selectedFileList[0];
                if (f.isDirectory() && fn.length() > 0) {
                    selectedFileList[0] = new File(f.getPath(), fn);
                    //System.out.println("to save: " + selectedFileList[0]);
                } // test for user editing
                else if (selectedFileList.length == 1 && !f.getName().equals(fn)) {
                    selectedFileList[0] = new File(fsv.getParentDirectory(selectedFileList[0]), fn);
                }
            }
        } else {
            response = CANCEL;
        }
        if (modal) {
            parent.setVisible(false);
        }
    }

    private void wrongSelectionDialog(boolean multiple) {
        JOptionPane.showMessageDialog(this, (multiple) ? "Too many items have been selected." : "No items have been selected.", "File/Dialog operations", JOptionPane.OK_OPTION);
    }

    private void notFolderDialog() {
        JOptionPane.showMessageDialog(this, "A folder must be selected.", "File/Dialog operations", JOptionPane.OK_OPTION);
    }

    private void doDeleteItems() {
        selectedFileList = null;
        testFileSelection();
        if (selectedFileList != null && selectedFileList.length > 0) {
            int deleteCount = 0;
            boolean deleteAll = false;
            for (int i = 0; i < selectedFileList.length; i++) {
                File f = selectedFileList[i];
                boolean ok = true;
                if (!deleteAll) {
                    String id = ((f.isDirectory()) ? "directory" : "file");
                    String warning = "Warning - " + id + " deletion \n\n";
                    Object[] possibleValues = {"Yes to All", "Yes", "No", "Cancel"};
                    int r = JOptionPane.showOptionDialog(this, warning.toUpperCase() + "Okay to delete " + id + " \n" + "\"" + f.getPath() + "\"", "Delete " + id, JOptionPane.DEFAULT_OPTION,
                            JOptionPane.WARNING_MESSAGE, null, possibleValues // set default to "no"
                            , possibleValues[2]);
                    if (r == 0) {
                        deleteAll = true;
                    } else if (r > 1) {
                        ok = false;
                    }
                } else { // delete all
                    ok = true;
                }
                if (ok) {
                    boolean result = f.delete();
                    if (result) {
                        deleteCount++;
                    } else {
                        JOptionPane.showMessageDialog(this, "Deletion of \n\"" + f.getPath() + "\"\n" + "failed.\n" + "If this is a directory, it must be empty.\n" + "If this is a file, you must have write permission.", "Delete failed", JOptionPane.OK_OPTION);

                    }
                }
            }
            if (deleteCount > 0) {
                selectedFileList = deleteMissingItems(selectedFileList);
                refreshPath();
            }
        } else {
            wrongSelectionDialog(false);
        }
    }

    private File[] deleteMissingItems(File[] list) {
        ArrayList<File> v = new ArrayList<File>();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                //System.out.println("test " + list[i]);
                if (list[i] != null && list[i].exists()) {
                    //System.out.println("accept " + list[i]);
                    v.add(list[i]);
                }
            }
            list = v.toArray(new File[]{});
        }
        return list;
    }

    private void createNewTextFile() {
        if (treeSelectedFile != null) {
            int i = 0;
            File f;
            String name;
            do {
                i++;
                name = "NewText" + i + ".txt";
                f = new File(treeSelectedFile, name);
            } while (f.exists());
            try {
                f.createNewFile();
                refreshPath();
                int type = ft.getFileType();
                if (type == ft.getFileTypeForName("Text") || type == ft.getFileTypeForName("All")) {
                } else {
                    JOptionPane.showMessageDialog(this, "You have created a new text file, but it will not be visible\n" + "because filename filtering is in effect. To see the file,\n" + "Choose \"All Files (*.*)\" for the file type at the bottom\n" + "of the file picker dialog.", "Text File Creation", JOptionPane.OK_OPTION);
                }
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else {
            notFolderDialog();
        }
    }

    private void renameDirectory() {
        if (treeSelectedFile != null) {
            String oldName = treeSelectedFile.getName();
            TextInputDialog t = new TextInputDialog(pframe);
            String newName = t.showDialog("File/Dialog operations", "Enter new directory name:", oldName);
            if (newName != null) {
                if (!newName.equals(oldName)) {
                    File newf = new File(treeSelectedFile.getParent(), newName);
                    if (!newf.exists()) {
                        treeSelectedFile.renameTo(newf);
                        setNewPath(newf);
                    } else {
                        main.beep();
                    }
                }
            }
        } else {
            main.beep();
        }
    }

    private void createNewFolder() {
        if (treeSelectedFile != null) {
            int i = 0;
            File f;
            String name;
            do {
                i++;
                name = "NewFolder" + i;
                f = new File(treeSelectedFile, name);
            } while (f.exists());
            try {
                f.mkdir();
                setNewPath(treeSelectedFile);
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else {
            notFolderDialog();
        }
    }

    private void doRename() {
        selectedFileList = null;
        testFileSelection();
        if (selectedFileList != null && selectedFileList.length == 1) {
            File f = selectedFileList[0];
            if (!f.isDirectory()) {
                String oldName = f.getName();
                //System.out.println("old name: \"" + oldName + "\"");
                TextInputDialog t = new TextInputDialog(pframe);
                String newName = t.showDialog("File/Dialog operations", "Enter new file name:", oldName);
                if (newName != null) {
                    if (!newName.equals(oldName)) {
                        //System.out.println("renaming: \"" + f.getParent() + "\" -> \"" + newName + "\"");
                        File newf = new File(f.getParent(), newName);
                        if (!newf.exists()) {
                            f.renameTo(newf);
                            refreshPath();
                        } else {
                            main.beep();
                        }
                    }
                }
            } else {
                main.beep();
            }
        } else if (selectedFileList != null && selectedFileList.length > 1) {
            wrongSelectionDialog(true);
        } else {
            wrongSelectionDialog(false);
        }
    }

    private int findText(String search, int pos, boolean caseSens, Document d) {
        int findex = -1;
        try {
            int top = d.getLength();
            int len = search.length();
            top -= len;
            if (caseSens) {
                for (int i = pos; i < top; i++) {
                    if (search.equals(d.getText(i, len))) {
                        findex = i;
                        break;
                    }
                }
            } else {
                for (int i = pos; i < top; i++) {
                    if (search.equalsIgnoreCase(d.getText(i, len))) {
                        findex = i;
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return findex;
    }

    private void incrementalTextSearch(java.awt.event.KeyEvent evt) {
        String search = textSearchField.getText();
        //System.out.println(search);
        int s = 0;
        int c = evt.getKeyCode();
        if (c == '\n' || c == KeyEvent.VK_F3) {
            s = textFilePosition;
        } else {
            textFilePosition = 0;
        }
        int p = findText(search, textFilePosition, false, textPreviewArea.getDocument());
        int len = search.length();
        if (p == -1) {
            main.beep();
            p = 0;
            len = 0;
        }
        textPreviewArea.setCaretPosition(p);
        textPreviewArea.moveCaretPosition(p + len);
        textPreviewArea.getCaret().setSelectionVisible(true);
        textFilePosition = p + len;
    }

    private void textEditEnable() {
        boolean enable = editCheckBox.getSelectedObjects() != null;
        if (textFile != null) {
            testSaveFile();
        }
        if (enable) {
            if (!textPreviewArea.isEditable() && listSelectedFile != null) {
                editCheckBox.setSelected(true);
                textPreviewArea.setEditable(true);
                textFile = listSelectedFile;
                requestFocusInWindow();
                textPreviewArea.requestFocusInWindow();
                documentChanged = false;
            }
        }
    }
    /*
     private void selectRoot() {
     if(!needinit) {
     File f = (File) rootList.getSelectedItem();
     if(f != null) {
     setNewPath(f);
     }
     }
     }
     */

    private File getFileForUnknown(File q) {
        File f = new File(".");
        if (q != null) {
            f = new File(q.getPath());
        }
        try {
            f = f.getCanonicalFile();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return f;
    }

    File getRootDir(File f) {
        File result;
        do {
            result = f;
            f = fsv.getParentDirectory(f);
        } while (f != null);
        return result;
    }

    private void ascendPath() {
        File localParent = fsv.getParentDirectory(currentDir);
        if (localParent != null) {
            setNewPath(localParent);
        }
    }

    private void showTextPopupMenu(java.awt.event.MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            ((MyJPopupMenu) textPopupMenu).show(textPreviewArea, evt.getX(), evt.getY());
        }
    }

    private void showFilePopupMenu(java.awt.event.MouseEvent evt, Component parent) {
        if (evt.isPopupTrigger()) {
            ((MyJPopupMenu) filePopupMenu).show(parent, evt.getX(), evt.getY());
        }
    }

    // allow a double-click to open or save a file
    private void handleMouseClick(java.awt.event.MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            doClose(true);
        }
    }

    private void showTreePopupMenu(java.awt.event.MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            ((MyJPopupMenu) treePopupMenu).show(pathTree, evt.getX(), evt.getY());
        }
    }

    private void showGraphicPopupMenu(java.awt.event.MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            ((MyJPopupMenu) graphicPopupMenu).show(graphicPreviewPanel, evt.getX(), evt.getY());
        }
    }

    private void handleTabChangeEvent() {
        tabbedPane.invalidate();
        int p = tabbedPane.getSelectedIndex();
        if (p == PREVIEW_NONE) {
            Dimension d = horizSplitPane.getSize();
            Dimension td = tabbedPane.getSize();
            Dimension cd = tabbedPane.getComponentAt(0).getSize();
            horizSplitPane.setDividerLocation(d.height - (td.height - cd.height) - horizSplitPane.getDividerSize());
        } else {
            horizSplitPane.setDividerLocation(.5);
        }
    }

    private void doPreview() {
        testSaveFile();
        //fileWindowDir = null;


        //System.out.println(fileWindowDir);
        int p = tabbedPane.getSelectedIndex();
        //if(p == 0) {
        //showList();
        //}


        // text preview

        if (p == PREVIEW_TEXT) {
            String result = readFile(listSelectedFile);
            if (result == null) {
                result = "\n\n\t*** No Preview Available ***";
            }
            textPreviewArea.setText(result);
            textPreviewArea.setCaretPosition(0);
            textPreviewArea.repaint();
        } else if (p == PREVIEW_GRAPHIC) { // graphic
            graphicPreviewPanel.loadGraphic(listSelectedFile);
        }
    }

    public void testSaveFile() {
        if (textPreviewArea.isEditable() && textFile != null && documentChanged == true) {
            String data = textPreviewArea.getText();
            queryWriteFile(textFile, data);
        }
        textPreviewArea.setEditable(false);
        textFile = null;
        documentChanged = false;
        editCheckBox.setSelected(false);
    }

    public void queryWriteFile(File f, String data) {
        if (f != null) {
            int r = JOptionPane.showConfirmDialog(this, "You have changed\n\"" + f.getPath() + "\"\nOkay to save?", "Save Edited File", JOptionPane.YES_NO_OPTION);

            if (r == JOptionPane.YES_OPTION) {
                writeFile(f, data);
            }
        }
    }

    public boolean writeFile(File f, String data) {
        boolean success = false;
        try {
            if (f != null) {
                BufferedWriter bos = new BufferedWriter(new FileWriter(f));
                //data = toSystemLineEndings(data);
                int len = data.length();
                bos.write(data.toCharArray());
                bos.close();
                success = true;
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return success;
    }

    public String readFile(File f) {
        textFile = null;
        String result = null;
        try {
            //System.out.println("preview text");
            if (f != null && !f.isDirectory()) {
                //System.out.println("not null");
                result = "Error: Unable to read \"" + f.getPath() + "\"";
                int len = (int) f.length();
                BufferedReader bis = new BufferedReader(new FileReader(f));
                char[] buf = new char[len];
                bis.read(buf);
                bis.close();
                result = new String(buf);
                if (result.length() > 0) {
                    textFile = f;
                }
                //result = toJavaLineEndings(result);
            }
        } catch (Exception e) {
            //ErrorMessageLogger.trace(e);
        }
        return result;

    }

    private void doTreeExpanded(javax.swing.event.TreeExpansionEvent evt) {
        TreePath tp = evt.getPath();
        if (tp != null) {
            MyMutableTreeNode node = (MyMutableTreeNode) tp.getLastPathComponent();
            //System.out.println("expand " + node);
            scanDir(node, false);
            //pathTree.revalidate();
            //showList(node);
        }
    }

    private void doTableValueChanged() {
        int[] rows = fileTable.getSelectedRows();
        if (rows.length == 0) {
            //doTreeValueChanged();
        } else {
            selectedFileList = new File[rows.length];
            //String localFileName;
            // rows may be sorted, so don't use
            // the file table for this
            for (int i = 0; i < rows.length; i++) {
                selectedFileList[i] = (File) fileTable.getValueAt(rows[i], 0);
            }
            updateFileStats();
            if (selectedFileList.length == 1) {
                listSelectedFile = selectedFileList[0];
            }
        }
        doPreview();
    }

    private void testFileSelection() {
        if (selectedFileList == null || selectedFileList.length == 0) {
            // doTreeValueChangedCore();
            doTableValueChanged();
        }
    }

    private void doTreeValueChanged() {
        //doTreeValueChangedCore();
        MyMutableTreeNode node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        treeSelectedFile = getFilePath(node);
        if (treeSelectedFile != null && treeSelectedFile.exists()) {
            pathField.setText(treeSelectedFile.getPath());
        } else {
            pathField.setText("");
        }
        //System.out.println("tree value changed " + node);
        showList(-1);
        //doPreview();
    }

    private void doTreeValueChangedCore() {
        int[] rows = pathTree.getSelectionRows();
        if (rows != null) {
            int len = rows.length;
            selectedFileList = new File[len];
            for (int i = 0; i < len; i++) {
                TreePath t = pathTree.getPathForRow(rows[i]);
                if (t != null) {
                    MyMutableTreeNode node = (MyMutableTreeNode) t.getLastPathComponent();
                    File f = (File) node.getUserObject();
                    selectedFileList[i] = f;
                }
            }
        } else {
            selectedFileList = null;
        }
        updateFileStats();
    }

    private File getFilePath(MyMutableTreeNode node) {
        if (node != null) {
            Object obj = node.getUserObject();
            if (obj != null && obj instanceof File) {
                return (File) obj;
            }
        }
        return null;
    }

    private void tweakWidth(String v, FontMetrics fm, int[] array, int n) {
        int len = fm.stringWidth(v) + 16;
        if (len > array[n]) {
            array[n] = len;
        }
    }

    private ArrayList<Object> makeTableEntry(File f, FontMetrics fm, int[] array) {
        ArrayList<Object> item = new ArrayList<Object>();
        //String path = f.getPath();
        String name = (fsv.getSystemDisplayName(f).trim()) + " ";
        String len = " ";
        String modDate = " ";
        if (!fsv.isDrive(f)) {
            len = String.valueOf(f.length()) + " ";
            Date d = new Date(f.lastModified());
            modDate = d.toString();
        }
        tweakWidth(name, fm, array, 1);
        tweakWidth(len, fm, array, 2);
        tweakWidth(modDate, fm, array, 3);
        item.add(f);
        item.add(name);
        item.add(len);
        item.add(modDate);
        return item;
    }

    private void showSelectedList() {
        MyMutableTreeNode node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        treeSelectedFile = getFilePath(node);

        doPreview();
    }

    private void showList(int sortType) {
        currentFileList = null;
        int files = 0;
        int directories = 0;
        long size = 0;
        if (treeSelectedFile != null && treeSelectedFile.exists()) {
            //System.out.println("show " + selectedFile);
            FontMetrics fm = getFontMetrics(fileTable.getFont());
            //column 0 is an icon column, no text
            int[] widths = {0, 0, 0, 0};
            ArrayList<ArrayList<Object>> v = new ArrayList<ArrayList<Object>>();
            if (fsv.isTraversable(treeSelectedFile).booleanValue()) {
                FileData fd = getFileList(treeSelectedFile, false, true, false);
                if (sortType != -1) {
                    sortFileData(fd, sortType);
                }
                currentFileList = fd.list;//(File[])fd.vlist.toArray(new File[] {});
                //fileWindowDir = treeSelectedFile;
                // update parent so it shows
                // discovered child directories
                updateTree(fd);
            } else {
                //fileWindowDir = null;
                currentFileList = new File[1];
                currentFileList[0] = treeSelectedFile;
            }

            if (currentFileList != null && currentFileList.length > 0) {
                for (int i = 0; i < currentFileList.length; i++) {
                    if (fsv.isTraversable(currentFileList[i]).booleanValue()) {
                        directories++;
                        if (displayMode == DIRECTORIES_ONLY || displayMode == FILES_AND_DIRECTORIES) {
                            v.add(makeTableEntry(currentFileList[i], fm, widths));
                        }
                    } else {
                        files++;
                        if (displayMode == FILES_ONLY || displayMode == FILES_AND_DIRECTORIES) {
                            v.add(makeTableEntry(currentFileList[i], fm, widths));
                        }
                    }
                    if (!fsv.isDrive(currentFileList[i])) {
                        size += currentFileList[i].length();
                    }
                    //v.add(makeTableEntry(currentFileList[i],fm,widths));
                }
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("D/F");
                headers.add("Name");
                headers.add("Size");
                headers.add("Modified");
                Object[][] data = new Object[v.size()][];
                int k = 0;
                Iterator<ArrayList<Object>> iter = v.iterator();
                while (iter.hasNext()) {
                    data[k] = iter.next().toArray();
                    k += 1;
                }
                DefaultTableModel tm = new DefaultTableModel(data, headers.toArray());
                fileTable.setModel(tm);
                //fileTable.configureEnclosingScrollPane();
                //fileTable.setDataArrayList(v,headers);
                int n = fileTable.getColumnModel().getColumnCount();
                //System.out.println("columns: " + n);
                for (int i = 0; i < fileTable.getColumnModel().getColumnCount(); i++) {
                    TableColumn c = fileTable.getColumnModel().getColumn(i);
                    c.setCellRenderer(new MyTableCellRenderer());
                    c.setPreferredWidth(widths[i]);
                }
            }
            int cc = fileTable.getColumnModel().getColumnCount();
            if (cc > 0) {
                fileTable.getColumnModel().getColumn(0).setMinWidth(fileTableColumnZeroWidth);
            }
            fileTable.revalidate();
            updateFileStats();

        }
        if (currentFileList == null || currentFileList.length == 0) {
            DefaultTableModel tm = new DefaultTableModel();
            fileTable.setModel(tm);
            fileStatsField.setText("");
            fileSelectedField.setText("");

        }

    }

    private void updateTree(FileData fd) {
        MyMutableTreeNode node = (MyMutableTreeNode) pathTree.getLastSelectedPathComponent();
        for (int i = 0; i < fd.list.length; i++) {
            if (fd.list[i].isDirectory()) {
                MyMutableTreeNode child = new MyMutableTreeNode(fd.list[i]);
                if (!node.isNodeChild(child)) {
                    node.add(child);
                }
            }
        }
    }

    private void updateFileStats() {

        selectedFileList = deleteMissingItems(selectedFileList);
        if (selectedFileList != null && selectedFileList.length > 0) {
            if (saveMode) {
                File f = selectedFileList[0];
                if (!fsv.isTraversable(f).booleanValue()) {
                    setFileName(fsv.getSystemDisplayName(f));
                }
            } else {
                fileName = "";
                for (int i = 0; i < selectedFileList.length; i++) {
                    fileName += ((i > 0) ? ";" : "") + fsv.getSystemDisplayName(selectedFileList[i]);
                }
                fileNameField.setText(fileName);
            }
        }

        fileStatsField.setText(formatStats(currentFileList));
        if (selectedFileList != null && selectedFileList.length > 0) {
            fileSelectedField.setText(formatStats(selectedFileList));
        }
    }

    private String formatStats(File[] list) {
        String s = "";
        if (list != null) {
            int files = 0;
            int direcs = 0;
            long size = 0;
            for (int i = 0; i < list.length; i++) {
                if (fsv.isTraversable(list[i]).booleanValue()) {
                    direcs++;
                } else {
                    files++;
                }
                if (!fsv.isDrive(list[i])) {
                    size += list[i].length();
                }
            }


            if (files > 0) {
                s = +files + " files, ";
            }
            if (direcs > 0) {
                s += direcs + " folders, ";
            }
            s += size + " bytes";
        }
        return s;
    }


    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem Delete;
    private javax.swing.JLabel NoPreviewLabel;
    private javax.swing.JMenuItem Rename;
    private javax.swing.JMenuItem Rename1;
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel centerPanel;
    private javax.swing.JCheckBox editCheckBox;
    private javax.swing.JPanel editTopPane;
    private javax.swing.JPanel fileListSurround;
    private javax.swing.JTextField fileNameField;
    private javax.swing.JPopupMenu filePopupMenu;
    private javax.swing.JTextField fileSelectedField;
    private javax.swing.JTextField fileStatsField;
    private javax.swing.JPanel fileStatsPane;
    private javax.swing.JTable fileTable;
    private javax.swing.JComboBox<String> fileTypeBox;
    private javax.swing.JMenuItem flipColorMenuItem;
    private javax.swing.JPopupMenu graphicPopupMenu;
    private javax.swing.JButton homeButton;
    private javax.swing.JSplitPane horizSplitPane;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JMenuItem lineWrapMenuItem;
    private javax.swing.JMenuItem newFolder;
    private javax.swing.JMenuItem newTextFile;
    private javax.swing.JButton openButton;
    private javax.swing.JTextField pathField;
    private javax.swing.JTree pathTree;
    private javax.swing.JMenuItem refreshMenuItem;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JMenuItem selectAllMenuItem;
    private javax.swing.JSplitPane splitPane;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JScrollPane tableScrollPane;
    private javax.swing.JPanel tableSurround;
    private javax.swing.JPanel textEditPane;
    private javax.swing.JPopupMenu textPopupMenu;
    private javax.swing.JTextArea textPreviewArea;
    private javax.swing.JTextField textSearchField;
    private javax.swing.JPanel topPanel;
    private javax.swing.JPopupMenu treePopupMenu;
    private javax.swing.JButton upButton;
    private javax.swing.JMenuItem upOneLevelMenuItem;
    // End of variables declaration//GEN-END:variables
}
