// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package FileTypes;

/*
 * FileTypes.java
 *
 * Created on February 1, 2002, 3:11 PM
 */
import java.io.*;
import java.util.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class FileTypes implements FileFilter {

    public ArrayList<ArrayList<String>> suffixList;
    HashSet<String> suffixHash;
    public String[] fileTypeNames;
    public String[] fileTemplateSuffs;
    public String[] markerClassNames;
    public String[] binTextType;
    public int fileTypeMax = 0;
    private int type = 0;
    private String path = ".";

    /** Creates new FileTypes */
    public FileTypes(String st, String path) {
        this.path = path;
        getFileTypeData();
        setFileType(st);
    }

    public FileTypes(String path) {
        this.path = path;
        getFileTypeData();
        setFileType("All");
    }

    public void getFileTypeData() {
        suffixList = new ArrayList<ArrayList<String>>();
        ArrayList<String> fileTypes = new ArrayList<String>();
        ArrayList<String> fileMarkers = new ArrayList<String>();
        ArrayList<String> suffs = new ArrayList<String>();
        ArrayList<String> binText = new ArrayList<String>();
        //String   path = "c:/data/java2/FileTypes/FileData.txt";
        String line;
        ArrayList<String> v;
        // leave room for "all"
        //System.out.println("file type names length: " + top);
        int i = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            while ((line = br.readLine()) != null) {

                //line = line.toLowerCase();
                v = parseDelimLine(line, ";");
                line = v.get(0);
                line = line.trim();
                if (line.length() > 0) {
                    v = parseDelimLine(line, "|", true); // get fields
                    if (v.size() > 3) {
                        fileTypes.add( v.get(0));
                        binText.add( v.get(1));
                        fileMarkers.add( v.get(2));
                        String s =  v.get(3);
                        ArrayList<String> w = parseDelimLine(s, ",", true);
                        suffixList.add(w);
                        suffs.add( w.get(0));
                        i++;
                    }
                }
            }
            br.close();
            fileTypeMax = i;
            fileTypeNames =  fileTypes.toArray(new String[fileTypes.size()]);
            fileTemplateSuffs =  suffs.toArray(new String[suffs.size()]);
            markerClassNames =  fileMarkers.toArray(new String[fileMarkers.size()]);
            binTextType =  binText.toArray(new String[binText.size()]);
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    // returns text type if none found
    public int getFileType(String path) {
        int fileType = getFileTypeForName("Text");
        return getFileType(path, fileType);
    }

    // returns -1 if none found
    public int testFileType(String path) {
        int fileType = -1;
        return getFileType(path, fileType);
    }

    // returns -1 if none found
    public int getValidFileType(String path) {
        return getFileType(path, -1);
    }

    private int getFileType(String path, int type) {
        int p = path.lastIndexOf(".");
        if (p != -1) {
            String suff = path.substring(p + 1);
            suff = suff.toLowerCase();
            suff = suff.trim();
            boolean found = false;
            for (int y = 0; !found && y < suffixList.size(); y++) {
                ArrayList<String> v = suffixList.get(y);
                for (int x = 0; !found && x < v.size(); x++) {
                    found = (suff.equals( v.get(x)));
                    if (found) {
                        type = y;
                        break;
                    }
                }
            }
        }
        return type;
    }

    // for FTP binary/text determination
    public boolean isTextFile(String fileName) {
        boolean isText = false;
        int fileType = testFileType(fileName);
        if (fileType != -1) {
            isText = binTextType[fileType].toLowerCase().equals("t");
        }
        return isText;
    }

    public boolean isValidTextFile(int type) {
        boolean accept = false;
        if (type >= 0 && type < fileTypeMax) {
            return markerClassNames[type].length() > 0;
        }
        return accept;
    }

    public int getFileTypeForName(String s) {
        for (int i = 0; i < fileTypeNames.length; i++) {
            if (s.equals(fileTypeNames[i])) {
                return i;
            }
        }
        return -1;
    }

    ArrayList<String> parseDelimLine(String data, String token, boolean trim) {
        ArrayList<String> v = new ArrayList<String>();
        int a = 0, b;
        int tokLen = token.length();
        while ((b = data.indexOf(token, a)) != -1) {
            String field = data.substring(a, b);
            if (trim) {
                field = field.trim();
            }
            v.add(field);
            a = b + tokLen;
        }
        if (a <= data.length()) {
            v.add(data.substring(a));
        }
        return v;
    }

    ArrayList<String> parseDelimLine(String data, String token) {
        return parseDelimLine(data, token, false);
    }

    public void setFileType(String s) {
        int t = getFileTypeForName(s);
        if (t >= 0) {
            setFileType(t);
        }
    }

    public void setFileType(int t) {
        type = t;
        suffixHash = new HashSet<String>();
        ArrayList<String> v = suffixList.get(type);
        for (int i = 0; i < v.size(); i++) {
            suffixHash.add(v.get(i));
        }
    }

    // Accept all directories and any files that match suffix list
    @Override
    public boolean accept(java.io.File f) {
        if (f.isDirectory()) {
            return true;
        } else if (suffixHash.isEmpty()) {
            return true;
        } else if (suffixHash.contains("*.*")) {
            return true;
        } else {
            String suff = f.getName();
            int p = suff.lastIndexOf(".");
            if (p != -1) {
                suff = suff.substring(p + 1);
                suff = suff.toLowerCase();
                suff = suff.trim();
                if (suff.length() > 0) {
                    return suffixHash.contains(suff);
                }
            }
        }
        return false;
    }

    public String getDescription() {
        return getDescription(type);
    }

    public int getFileType() {
        return type;
    }

    public String getFileTypeName(int t) {
        if (t >= 0 && t < fileTypeNames.length) {
            return fileTypeNames[t];
        } else {
            return "";
        }
    }
    
    public String getFileTypeName() {
        return getFileTypeName(type);
    }

    public String[] getFileTypeNames() {
        return fileTypeNames;
    }

    // The description of this filter
    public String getDescription(int type) {
        ArrayList<String> v =  suffixList.get(type);
        String s = fileTypeNames[type] + " Files (";
        if (v.isEmpty()) {
            s += "*.*";
        } else {
            for (int i = 0; i < v.size(); i++) {
                if (i > 0) {
                    s += ",";
                }
                s += v.get(i);
            }
        }
        s += ")";
        return s;
    }
}
