// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * SetFileType.java
 *
 * Created on March 5, 2002, 7:02 AM
 */

package FileTypes;

import Arachnophilia.*;
//import ArachDocument;
import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 */
public class SetFileType extends javax.swing.JPanel {
    
    Arachnophilia main;
    ArachDocument doc;
    SetFileTypeDialog parent;
    boolean needInit = true;
    int fileType;
    String[] initialData;
    /** Creates new form SetFileType */
    public SetFileType(Arachnophilia m,SetFileTypeDialog p,ArachDocument d) {
        main = m;
        parent = p;
        doc = d;
        initialData = main.fileTypes.getFileTypeNames();
        initComponents();
        fileType = doc.getFileType();
        // this is an unbelievable but necessary hack
        Rectangle r = fileTypeList.getCellBounds(0,0);
        int v = r.height * (initialData.length);
        Dimension dd = new Dimension(fileTypeList.getSize().width,v);
        fileTypeList.setPreferredSize(dd);
        if(fileType >= 0) {
            fileTypeList.setSelectedIndex(fileType);
        }
        
        String message = "Choose a file type for the current document. This choice affects syntax coloring and code beautification. Press \"OK\" to accept the current choice.";
        messageArea.setText(message);
        
        //setVisible(true);
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        if(needInit) {
            needInit = false;
            fileTypeList.ensureIndexIsVisible(fileType);
            //fileTypeList.revalidate();
            //fileTypeList.repaint();
        }
        
    }
    
    private void acceptChoice() {
        int type = fileTypeList.getSelectedIndex();
        doc.changeFileType(type);
        parent.quit();
    }
    
    private void cancelChoice() {
        parent.quit();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        southPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        centerPane = new javax.swing.JScrollPane();
        fileTypeList = new JList<String>(initialData);
        northPane = new javax.swing.JScrollPane();
        messageArea = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        okButton.setText("OK");
        okButton.setToolTipText("Accept the present choice");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        southPanel.add(okButton);

        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Discard this choice, make no change");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        southPanel.add(cancelButton);

        add(southPanel, java.awt.BorderLayout.SOUTH);

        centerPane.setPreferredSize(new java.awt.Dimension(400, 100));

        fileTypeList.setPreferredSize(new java.awt.Dimension(500, 200));
        fileTypeList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fileTypeListMouseClicked(evt);
            }
        });
        centerPane.setViewportView(fileTypeList);

        add(centerPane, java.awt.BorderLayout.CENTER);

        northPane.setPreferredSize(new java.awt.Dimension(400, 100));

        messageArea.setBackground(new java.awt.Color(204, 204, 204));
        messageArea.setEditable(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        messageArea.setPreferredSize(new java.awt.Dimension(500, 200));
        northPane.setViewportView(messageArea);

        add(northPane, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        cancelChoice();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // Add your handling code here:
        acceptChoice();
    }//GEN-LAST:event_okButtonActionPerformed
    
    private void fileTypeListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fileTypeListMouseClicked
        // Add your handling code here:
        if(evt.getClickCount() > 1) {
            acceptChoice();
        }
    }//GEN-LAST:event_fileTypeListMouseClicked
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane centerPane;
    private javax.swing.JList<String> fileTypeList;
    private javax.swing.JTextArea messageArea;
    private javax.swing.JScrollPane northPane;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel southPanel;
    // End of variables declaration//GEN-END:variables
    
}
