// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * HTMLValidator.java
 *
 * Created on November 4, 2006, 10:06 AM
 */

package HTMLValidator;

import Arachnophilia.*;
import java.util.*;
import java.util.regex.*;

/**
 *
 * @author  Administrator
 */
public class HTMLValidator {
    
    Pattern regex_suspend_resume[][] = {
        { Pattern.compile("<script\\b"), Pattern.compile("</script>") },
        //{ Pattern.compile("<pre>"), Pattern.compile("</pre>") },
        //{ Pattern.compile("<code>"), Pattern.compile("</code>") },
        { Pattern.compile("<\\?php"), Pattern.compile("\\?>") },
        { Pattern.compile("<%"), Pattern.compile("%>") },
        { Pattern.compile("<style\\b"), Pattern.compile("</style>") }
    };
    
    Pattern doctypePat = Pattern.compile("^(<!doctype|<\\?php\\b)");
    Pattern stripPat = Pattern.compile("^\\s*(.*?)\\s*$");
    Pattern tagPat = Pattern.compile("<.*?>");
    Pattern indentPat = Pattern.compile("(<[^/].*?[^/]>|<\\w+?>)");
    Pattern outdentPat = Pattern.compile("</.*?>");
    Pattern orphanPat = Pattern.compile("<.*?/>");
    
    Pattern delCommentPat = Pattern.compile("<!--.*?-->");
    Pattern delPhpXmlPat = Pattern.compile("<\\?(php|xml).*?\\?>");
    Pattern delAspPat = Pattern.compile("<%.*?%>");
    Pattern delScriptPat = Pattern.compile("<script.*?>.*?</script>");
    
    Pattern extractTagNamePat = Pattern.compile("</?(\\w+)\\b");
    
    HTMLValidatorDialog dialog = null;
    
    int docPosToggle = 0;
    
    /** Creates a new instance of HTMLValidator */
    Arachnophilia main;
    public HTMLValidator(Arachnophilia m) {
        main = m;
    }
    
    public void validateHTML(String content) {
        String hline = "----------------------------------------------------\n";
        String  dialogContent = "Click error lines to navigate within document.\n";
        dialogContent += "Click again to jump to opposite tag.\n";
        dialogContent += hline;
        String lines[] = content.split("\n");
        Stack<TagData> tagStack = new Stack<TagData>();
        int len = lines.length;
        int suspend = 0;
        int level = 0;
        boolean errors = false;
        Matcher m;
        for(int ln = 0;ln < len;ln++) {
            String line = lines[ln].toLowerCase();
            line = delPhpXmlPat.matcher(line).replaceAll("");
            line = delAspPat.matcher(line).replaceAll("");
            line = delScriptPat.matcher(line).replaceAll("");
            line = delCommentPat.matcher(line).replaceAll("");
            m = stripPat.matcher(line);
            if(m.find()) {
                line = m.group(1);
            }
            //System.out.println(line + " suspend: " + suspend);
            if(line.length() > 0) {
                for(int j = 0; j < regex_suspend_resume.length;j++) {
                    if(regex_suspend_resume[j][1].matcher(line).find()
                    && !regex_suspend_resume[j][0].matcher(line).find()) {
                        suspend--;
                    }
                }
                if(suspend <= 0) {
                    String tags[] = ArachComp.extractAllRegexMatches(line,tagPat);
                    int tln = tags.length;
                    for(int i = 0;i < tln;i++) {
                        String tag = tags[i];
                        if(!(doctypePat.matcher(tag).find() || orphanPat.matcher(tag).find())) {
                            //System.out.println("line: " + (ln+1) + " tag:" + tag);
                            m = extractTagNamePat.matcher(tag);
                            if(!m.find()) {
                                //FIXME: error here if no match
                                String err = "Malformed/unidentified tag: " + tag + ", line " + (ln+1) + ".";
                                dialogContent += err + "\n";
                                errors = true;
                            }
                            else {
                                String name = m.group(1);
                                TagData newTag = new TagData(name,ln);
                                if(indentPat.matcher(tag).find()) {
                                    tagStack.push(newTag);
                                    level++;
                                }
                                else if(outdentPat.matcher(tag).find()) {
                                    level--;
                                    if(tagStack.size() <= 0) {
                                        String err = "  Orphan: " + newTag  + " no corresponding tag.";
                                        dialogContent += err + "\n";
                                        errors = true;
                                    }
                                    else {
                                        TagData oldTag = (TagData) tagStack.pop();
                                        if(!oldTag.name.equals(name)) {
                                            String err = "Mismatch: " + newTag + " doesn't match " + oldTag + ".";
                                            dialogContent += err + "\n";
                                            errors = true;
                                        }
                                    }
                                }
                                else { // unidentified tag type
                                    // FIXME: unidentified tag
                                    String err = "Unidentified tag type: " + tag + ", line " + (ln+1) + ".";
                                    dialogContent += err + "\n";
                                    errors = true;
                                }
                            }
                        }
                    }
                } // suspend <= 0
                for(int j = 0; j < regex_suspend_resume.length;j++) {
                    if(regex_suspend_resume[j][0].matcher(line).find()
                    && !regex_suspend_resume[j][1].matcher(line).find()) {
                        suspend++;
                    }
                }
            } // line length > 0
        } // for loop
        while(tagStack.size() > 0) {
            TagData tag = (TagData) tagStack.pop();
            String err = "  Orphan: " + tag + " no corresponding tag.";
            dialogContent += err + "\n";
            errors = true;
        }
        dialogContent += hline;
        if(level != 0) {
            String err = "Error: start/end tag mismatch: n = " + level + "\n";
            err += "n > 0 means more <starting> tags than </ending> tags.\n";
            err += "n < 0 means more </ending> tags than <starting> tags.\n\n";
            err += "This error can be caused by validating a selection\n"
            + "rather than the entire document.";
            
            dialogContent += err + "\n";
        }
        else if(!errors) {
            dialogContent = "No errors.";
        }
        if(dialog != null) {
            dialog.quit();
        }
        dialog = new HTMLValidatorDialog(main,this);
        dialog.setText(dialogContent);
        if(!errors) {
            dialog.closeButton.requestFocus();
        }
    }
    
    Pattern extractLineNumsPat = Pattern.compile(".*?line (\\d+)");
    
    public boolean isValidLine(String lt) {
        return (extractLineNumsPat.matcher(lt).find());
    }
    
    public void gotoLine(String lt) {
        Matcher m = extractLineNumsPat.matcher(lt);
        ArrayList<String> vec = new ArrayList<String>();
        while(m.find()) {
            vec.add(m.group(1));
        }
        int vs = vec.size();
        if(vs > 0) {
            int n = docPosToggle++ % vs;
            String ln = vec.get(n);
            int line = Integer.parseInt(ln);
            ArachDocument doc = main.currentSelectedDocument;
            //doc.changeDisplayModes(true);
            doc.gotoLine(line-1);
        }
    }
}

class TagData {
    String name;
    int lineNumber;
    TagData(String ns,int ln) {
        name = ns;
        lineNumber = ln;
    }
    @Override
    public String toString() {
        return ("([" + name + "] line " + (lineNumber+1) + ")");
    }
}