// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * LookAndFeelFrame.java
 *
 * Created on March 10, 2002, 8:45 AM
 */

package LookAndFeel;

import Arachnophilia.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
public class LookAndFeelDialog extends javax.swing.JDialog {

    Arachnophilia main;
    /** Creates new form LookAndFeelFrame */
    public LookAndFeelDialog(Arachnophilia m,String arg) {
        super(m,true);
        setTitle("Choose Look & Feel");
        main = m;
        getContentPane().add(new LookAndFeelPanel(m,this,arg));
        initComponents();
        Rectangle ss = m.getBounds();
        int w = ss.width/8;
        int h = ss.height/8;
        setLocation(ss.x+w,ss.y+h);
        setVisible(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
        pack();
    }//GEN-END:initComponents

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        // Add your handling code here:
        pack();
        invalidate();
    }//GEN-LAST:event_formComponentResized

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        quit();
    }//GEN-LAST:event_exitForm

    public void quit()
    {
        setVisible(false);
        dispose();
    }
    
    /**
    * @param args the command line arguments
    *//*
    public static void main(String args[]) {
        new LookAndFeelFrame().show();
    }*/


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
