// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * OldTemplateConverter.java
 *
 * Created on February 5, 2002, 12:30 PM
 */

package MacroManager;
import Arachnophilia.*;
import java.io.*;
import java.util.*;
//import ArachComp;
//import ArachConstants;
//import SearchReplace;
// import QuotedTextHandler;
//import EscapeUnescapeStringHandler;

/**
 *
 * @author  Administrator
 * @version
 */
final public class LegacyToolbarConverter {
    
    /** Creates new OldTemplateConverter */
    public LegacyToolbarConverter() {
    }
    
    private String combineToolTipStatus(String a, String b) {
        return ((a.length() > 0 && !a.equals(b))?a + "/" + b:b);
    }
    
    public String convertFile(String sourcePath) {
        String out = null;
        String title, toolTip, content;
        StringBuilder output = new StringBuilder();
        output.append(ArachConstants.xmlDecl + "\n");
        String data = ArachComp.readProgramFile(sourcePath,true);
        ArrayList<String> record;
        if(data != null) {
            ArrayList<String> v = ArachComp.parseDelimLine(data,"\n",true);
            if(v.size() > 3) {
                String validTest = v.get(1);
                if(validTest.indexOf("Arachnophilia") == -1) {
                    return null;
                }
                record = ArachComp.parseDelimLine(v.get(3),"\t",true);
                if(record.size() > 3) {
                    title = record.get(1);
                    toolTip = combineToolTipStatus(record.get(2),record.get(3));
                    
                    output.append("<node>\n" + "\t<title>").append(title).append("</title>\n" + "\t<tooltip>").append(toolTip).append("</tooltip>\n");
                    for(int i = 5;i < v.size();i++) {
                        record = ArachComp.parseDelimLine(v.get(i),"\t",false);
                        if(record.size() > 3) {
                            title = record.get(0);
                            title = ArachComp.escapeXMLContent(title);
                            content = record.get(1);
                            content = escapeLegacyContent(content);
                            toolTip = combineToolTipStatus(record.get(2), record.get(3));
                            toolTip = ArachComp.escapeXMLContent(toolTip);
                            output.append("\t<leaf>\n\t\t<title>").append(title).append("</title>\n\t\t<tooltip>").append(toolTip).append("</tooltip>\n\t\t<content>").append(content).append( "</content>\n\t</leaf>\n");
                            //System.out.println("content: " + content);
                        }
                    }
                    output.append("</node>\n");
                }
            }
            out = output.toString();
        }
        return out;
        
    }
    
    private String escapeLegacyContent(String content) {
        SearchReplace srch = new SearchReplace();
        content = srch.srchRplc(content,"\\p","\\n",false);
        content = srch.srchRplc(content,"<","&lt;",true);
        content = srch.srchRplc(content,">","&gt;",true);
        return content;
    }
    
    private String createOneLineTag(String tag,String content) {
        return "<" + tag + ">" + content + "</" + tag + ">\n";
    }
    
    private String wrapTag(String tag,String content) {
        return "<" + tag + ">\n" + content + "\n</" + tag + ">\n";
    }
    
    public void convertBatch(String sourcePath, String destPath) {
        File f = new File(sourcePath);
        File[] list = f.listFiles();
        
        for(int i = 0;i < list.length;i++) {
            String fileName = list[i].getName().toLowerCase();
            if(fileName.endsWith(".tbd")) {
                String out = convertFile(list[i].getPath());
                if(out != null) {
                    int p = fileName.lastIndexOf(".");
                    if(p != -1) {
                        fileName = fileName.substring(0,p);
                        String outPath = destPath + ArachConstants.SYSTEM_FILESEP + fileName + ".txt";
                        ArachComp.writeProgramFile(outPath,out,true);
                    }
                }
            }
        }
        
    }
    
}
