// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * MacroEditor.java
 *
 * Created on February 6, 2002, 12:59 PM
 */
package MacroManager;

import Arachnophilia.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;
//import IconSelector;

/**
 *
 * @author Administrator
 */
// this was a JDialog, it because a JPanel
final public class MacroEditor extends javax.swing.JPanel {

    public boolean validData = false;
    public boolean changed = false;
    public boolean oldChanged = false;
    private DefaultMutableTreeNode node = null;
    public MacroTreeNodeData data = null;
    private boolean keyTrap = false;
    private KeyDescription keyboardHook = null;
    private boolean keyAccepted = false;
    private boolean suppressChanges = false;
    int tabSize = 8;
    Arachnophilia main;
    MyJTree parent = null;
    ArrayList<String> comList;
    String icon;

    /**
     * Creates new form MacroEditor
     */
    /*
     public MacroEditor(Arachnophilia m,Container parent,int tab, DefaultMutableTreeNode n) {
     //super(m, modal);
     main = m;
     this.parent = parent;
     tabSize = tab;
     node = n;
     init(parent);
     }*/
    public MacroEditor(Arachnophilia m) {
        main = m;
        init();
    }

    private void init() {
        // comList must be the argument to systemCombox
        comList = main.comSwitchboard.getArrayListList();
        setLayout(new BorderLayout());
        initComponents();
        keyHookField.setFocusTraversalKeysEnabled(false);
        MacroTreePanel panel = main.getMacroPanel();
        if (panel != null) {
            ArrayList<String> macroList = panel.mjt.getMacroList();
            updateMacroList(macroList);

        }


        // for the future
        // systemComBox.setRenderer(new MyCellRenderer());
        macroTextArea.setLineWrap(true);
        macroTextArea.setWrapStyleWord(true);
        // this copes with a known bug
        macroTextArea.setTabSize(tabSize);
        macroTextArea.setUI(macroTextArea.getUI());
        // edit(parent,node);
    }

    private void updateMacroList(ArrayList<String> data) {
        suppressChanges = true;
        int i = macroComboBox.getSelectedIndex();
        macroComboBox.setModel(new DefaultComboBoxModel<String>(data.toArray(new String[]{})));
        if (i > -1 && i < macroComboBox.getItemCount()) {
            macroComboBox.setSelectedIndex(i);
        }
        suppressChanges = false;
    }

    public void saveOnExit() {
        testSaveChanges();
    }

    public void testSaveChanges() {
        // if node being edited
        if (node != null && changed) {
            TreePath path = new TreePath(node.getPath());
            int reply = JOptionPane.showConfirmDialog(this,
                    "You have made changes to\n" + path.toString() + "\nDo you want to save these changes?",
                    "Macro edit not saved", JOptionPane.YES_NO_OPTION);
            if (reply == JOptionPane.OK_OPTION) {
                acceptData();
            }
        }
        setChanged(false);
    }

    private void doCancel() {
        setChanged(false);
        edit(parent, node);
    }

    public void edit(MyJTree parent, DefaultMutableTreeNode n) {
        if (n != null) {
            testSaveChanges();
            this.parent = parent;
            node = n;
            data = (MacroTreeNodeData) node.getUserObject();
            macroTextArea.setText(data.content);
            nameField.setText(data.name);
            titleField.setText(data.title.trim());
            toolTipField.setText(data.toolTip);
            if (data.keyboardHook != null) {
                keyHookField.setText(data.keyboardHook.getDescription());
                keyboardHook = (KeyDescription) data.keyboardHook.clone();
            } else {
                keyHookField.setText("");
                keyboardHook = null;
            }
            isToolBarCheckBox.setSelected(data.isToolBar);
            isMenuCheckBox.setSelected(data.isMenu);
            isHiddenCheckBox.setSelected(data.isHidden);
            separatorCheckBox.setSelected(data.isSeparator);
            showTitleCheckBox.setSelected(data.showTitleAndIcon);
            updateMacroList(parent.getMacroList());

            icon = data.icon;
            setupIcon(icon);
            // force a change in button state
            setChanged(true);
            setChanged(false);
        }
    }

    /*
     setTitle(ArachConstants.APPNAME + " Macro Editor");
     Rectangle r = main.getBounds();
     int w = r.width/8;
     int h = r.height/8;
     setBounds(r.x+w,r.y+h,r.width-w*2,r.height-h*2);
     **/
    // **** these are hacks to allow me to change from a dialog to a panel
    private Container getContentPane() {
        return this;
    }

    private void pack() {
    }

    private void dispose() {
    }

    // ****
    // this renderer should produces a tooltip,
    // if one exists, for system commands,
    // but a bug in 1.2 prevents it from working for now
    // I am keeping it for future reference
    class MyCellRenderer extends JLabel implements ListCellRenderer {

        public MyCellRenderer() {
            setOpaque(true);
        }

        @Override
        public java.awt.Component getListCellRendererComponent(javax.swing.JList list, java.lang.Object value, int index, boolean isSelected, boolean cellHasFocus) {
            setText(value.toString());
            //if(index >= 0 && index < main.comSwitchboard.sortedTips.length) {
            //    setToolTipText(main.comSwitchboard.sortedTips[index]);
            //}
            //else {
            setToolTipText("????");
            //}
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            return this;
        }
    }

    private void dockUndock() {
        main.configValues.showMacroEditorInFrame = !main.configValues.showMacroEditorInFrame;
        main.showMacroEditPanel(true, true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        popupMenu = new MyJPopupMenu();
        lineWrapMenuItem = new javax.swing.JMenuItem();
        dockUndockMenuItem = new javax.swing.JMenuItem();
        topPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        titleField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        toolTipField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        keyHookField = new javax.swing.JTextField();
        keyTestButton = new javax.swing.JToggleButton();
        clearKeyDef = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        bottomPanel = new javax.swing.JPanel();
        controlPanel = new javax.swing.JPanel();
        isToolBarCheckBox = new javax.swing.JCheckBox();
        isHiddenCheckBox = new javax.swing.JCheckBox();
        showTitleCheckBox = new javax.swing.JCheckBox();
        okButton = new MyJButton();
        separatorCheckBox = new javax.swing.JCheckBox();
        cancelButton = new MyJButton();
        chooseIconButton = new MyJButton();
        isMenuCheckBox = new javax.swing.JCheckBox();
        closeButton = new MyJButton();
        topControlPanel = new javax.swing.JPanel();
        systemComBox = new JComboBox<String>(comList.toArray(new String[]{}));
        macroComboBox = new javax.swing.JComboBox<String>();
        jLabel4 = new javax.swing.JLabel();
        middlePanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        macroTextArea = new MyJTextArea(main);

        lineWrapMenuItem.setText("Toggle line wrap");
        lineWrapMenuItem.setToolTipText("Set/clear editor display line wrap");
        lineWrapMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lineWrapMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(lineWrapMenuItem);

        dockUndockMenuItem.setText("Dock/Undock");
        dockUndockMenuItem.setToolTipText("Dock or undock the macro editor panel");
        dockUndockMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dockUndockMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(dockUndockMenuItem);

        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                formComponentHidden(evt);
            }
        });
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                formKeyTyped(evt);
            }
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });
        setLayout(new java.awt.BorderLayout());

        topPanel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Title");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topPanel.add(jLabel1, gridBagConstraints);

        titleField.setToolTipText("The title appears on the tree display");
        titleField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                titleFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(titleField, gridBagConstraints);

        jLabel2.setText("ToolTip");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topPanel.add(jLabel2, gridBagConstraints);

        toolTipField.setToolTipText("The \"tool tip\" is one of these floating messages");
        toolTipField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                toolTipFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(toolTipField, gridBagConstraints);

        jLabel5.setText("Shortcut Key");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topPanel.add(jLabel5, gridBagConstraints);

        keyHookField.setToolTipText("The key used  to get this macro (optional)");
        keyHookField.setRequestFocusEnabled(false);
        keyHookField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                keyHookFieldKeyTyped(evt);
            }
            public void keyPressed(java.awt.event.KeyEvent evt) {
                keyHookFieldKeyPressed(evt);
            }
            public void keyReleased(java.awt.event.KeyEvent evt) {
                keyHookFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(keyHookField, gridBagConstraints);

        keyTestButton.setText("Define");
        keyTestButton.setToolTipText("Press this button, then press the desired key or combination");
        keyTestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyTestButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(keyTestButton, gridBagConstraints);

        clearKeyDef.setText("Clear");
        clearKeyDef.setToolTipText("Erase the current key definition");
        clearKeyDef.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearKeyDefActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(clearKeyDef, gridBagConstraints);

        jLabel6.setText("Macro Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topPanel.add(jLabel6, gridBagConstraints);

        nameField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topPanel.add(nameField, gridBagConstraints);

        jLabel3.setText("Macro Editing Area:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topPanel.add(jLabel3, gridBagConstraints);

        add(topPanel, java.awt.BorderLayout.NORTH);

        bottomPanel.setLayout(new java.awt.BorderLayout());

        controlPanel.setLayout(new java.awt.GridBagLayout());

        isToolBarCheckBox.setText("ToolBar");
        isToolBarCheckBox.setToolTipText("Select if you want this item's children to appear as a toolbar");
        isToolBarCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isToolBarCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(isToolBarCheckBox, gridBagConstraints);

        isHiddenCheckBox.setText("Hidden");
        isHiddenCheckBox.setToolTipText("Select to hide this item (used for toolbars, buttons and menus)");
        isHiddenCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isHiddenCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        controlPanel.add(isHiddenCheckBox, gridBagConstraints);

        showTitleCheckBox.setText("Title and Icon");
        showTitleCheckBox.setToolTipText("Display both a title and icon");
        showTitleCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showTitleCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(showTitleCheckBox, gridBagConstraints);

        okButton.setText("Accept");
        okButton.setToolTipText("Accept editing changes");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(okButton, gridBagConstraints);

        separatorCheckBox.setText("Separator");
        separatorCheckBox.setToolTipText("Used for toolbars and menus");
        separatorCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                separatorCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(separatorCheckBox, gridBagConstraints);

        cancelButton.setText("Discard");
        cancelButton.setToolTipText("Discard your changes");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(cancelButton, gridBagConstraints);

        chooseIconButton.setText("Choose Icon");
        chooseIconButton.setToolTipText("Choose an icon");
        chooseIconButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseIconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(chooseIconButton, gridBagConstraints);

        isMenuCheckBox.setText("Menu");
        isMenuCheckBox.setToolTipText("Make this item a menu");
        isMenuCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isMenuCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        controlPanel.add(isMenuCheckBox, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.setToolTipText("Close this window");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        controlPanel.add(closeButton, gridBagConstraints);

        bottomPanel.add(controlPanel, java.awt.BorderLayout.CENTER);

        topControlPanel.setLayout(new java.awt.GridBagLayout());

        systemComBox.setToolTipText("System commands");
        systemComBox.setAutoscrolls(true);
        systemComBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                systemComBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topControlPanel.add(systemComBox, gridBagConstraints);

        macroComboBox.setToolTipText("Menu, toolbar, user macros");
        macroComboBox.setAutoscrolls(true);
        macroComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                macroComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        topControlPanel.add(macroComboBox, gridBagConstraints);

        jLabel4.setText("Insert system command or user macro:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 1);
        topControlPanel.add(jLabel4, gridBagConstraints);

        bottomPanel.add(topControlPanel, java.awt.BorderLayout.NORTH);

        add(bottomPanel, java.awt.BorderLayout.SOUTH);

        middlePanel.setLayout(new java.awt.BorderLayout());

        macroTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                macroTextAreaKeyPressed(evt);
            }
        });
        macroTextArea.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                macroTextAreaMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                macroTextAreaMouseReleased(evt);
            }
        });
        jScrollPane1.setViewportView(macroTextArea);

        middlePanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(middlePanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void dockUndockMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dockUndockMenuItemActionPerformed
        // Add your handling code here:
        dockUndock();
    }//GEN-LAST:event_dockUndockMenuItemActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        main.getMacroPanel().setEditMode(false, true);
    }//GEN-LAST:event_closeButtonActionPerformed

    private void macroComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_macroComboBoxActionPerformed
        // Add your handling code here:
        if (!suppressChanges) {
            insertMacro(evt.getSource());
        }
    }//GEN-LAST:event_macroComboBoxActionPerformed

    private void formComponentHidden(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentHidden
        // Add your handling code here:
        testSaveChanges();
    }//GEN-LAST:event_formComponentHidden

    private void isMenuCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isMenuCheckBoxActionPerformed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_isMenuCheckBoxActionPerformed

    private void clearKeyDefActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearKeyDefActionPerformed
        // Add your handling code here:
        clearKeyDef();
        setChanged();
    }//GEN-LAST:event_clearKeyDefActionPerformed

    private void keyHookFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyHookFieldKeyReleased
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_keyHookFieldKeyReleased

    private void keyHookFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyHookFieldKeyTyped
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_keyHookFieldKeyTyped

    private void formKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyTyped
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_formKeyTyped

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed
        // Add your handling code here:
        handleKey(evt);
    }//GEN-LAST:event_formKeyPressed

    private void macroTextAreaMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_macroTextAreaMouseReleased
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_macroTextAreaMouseReleased

    private void macroTextAreaMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_macroTextAreaMousePressed
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_macroTextAreaMousePressed

    private void lineWrapMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineWrapMenuItemActionPerformed
        // Add your handling code here:
        toggleLineWrap();
    }//GEN-LAST:event_lineWrapMenuItemActionPerformed

    private void titleFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_titleFieldKeyPressed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_titleFieldKeyPressed

    private void toolTipFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_toolTipFieldKeyPressed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_toolTipFieldKeyPressed

    private void keyHookFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyHookFieldKeyPressed
        // Add your handling code here:
        handleKey(evt);
        setChanged();
    }//GEN-LAST:event_keyHookFieldKeyPressed

    private void macroTextAreaKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_macroTextAreaKeyPressed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_macroTextAreaKeyPressed

    private void isHiddenCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isHiddenCheckBoxActionPerformed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_isHiddenCheckBoxActionPerformed

    private void showTitleCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showTitleCheckBoxActionPerformed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_showTitleCheckBoxActionPerformed

    private void separatorCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_separatorCheckBoxActionPerformed
        // Add your handling code here:
        execSeparator(evt);

    }//GEN-LAST:event_separatorCheckBoxActionPerformed

    private void isToolBarCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isToolBarCheckBoxActionPerformed
        // Add your handling code here:
        setChanged();
    }//GEN-LAST:event_isToolBarCheckBoxActionPerformed

    private void chooseIconButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseIconButtonActionPerformed
        // Add your handling code here:
        setChanged();
        chooseIcon();
    }//GEN-LAST:event_chooseIconButtonActionPerformed

    private void keyTestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyTestButtonActionPerformed
        // Add your handling code here:
        setChanged();
        keyTrap = true;
        keyHookField.grabFocus();
        //handleDefineKey();
    }//GEN-LAST:event_keyTestButtonActionPerformed

    private void systemComBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_systemComBoxActionPerformed
        // Add your handling code here:
        insertMacro(evt.getSource());
    }//GEN-LAST:event_systemComBoxActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        doCancel();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // Add your handling code here:
        acceptClose();
    }//GEN-LAST:event_okButtonActionPerformed

    private void execSeparator(java.awt.event.ActionEvent evt) {
        if (separatorCheckBox.getSelectedObjects() != null) {
            titleField.setText("* Separator *");
        }
        setChanged();
    }

    private void clearKeyDef() {
        keyHookField.setText("");
        keyboardHook = null;
        setChanged();
    }

    private void handleKey(java.awt.event.KeyEvent evt) {
        //System.out.println("The key is -> " + evt);
        if (keyTrap) {
            if (evt.getID() == KeyEvent.KEY_PRESSED /*|| evt.getID() == KeyEvent.KEY_TYPED*/) {

                //System.out.println("The key is still -> " + evt);
                String macroCode = main.macroKeyHandler.createCode(evt);
                if (macroCode != null && macroCode.length() > 0) {
                    //System.out.println("The key is accepted -> " + evt);
                    keyAccepted = true;
                    keyTestButton.setSelected(false);
                    processDefineKey(evt);
                    //String code = "" + evt.getKeyModifiersText(evt.getModifiers()) + " " + evt.getKeyText(evt.getKeyCode());

                }
            } else if ((evt.getID() == KeyEvent.KEY_RELEASED) && keyAccepted) {
                keyTrap = false;
                macroTextArea.requestFocusInWindow();

            }
            evt.consume();

        } // else if not trapping keys
        else {
            main.macroKeyHandler.execute(evt);
        }
    }

    public void setChanged() {
        //System.out.println(evt);
        setChanged(true);
    }

    public void setChanged(boolean v) {
        if (v != oldChanged) {
            okButton.setEnabled(v);
            cancelButton.setEnabled(v);
        }
        changed = v;
        oldChanged = v;
    }

    private void handleMouse(java.awt.event.MouseEvent evt) {
        if (popupMenu.isPopupTrigger(evt)) {
            ((MyJPopupMenu) popupMenu).show(macroTextArea, evt.getX(), evt.getY());
        }
    }

    private void toggleLineWrap() {
        macroTextArea.setLineWrap(!macroTextArea.getLineWrap());
        macroTextArea.setWrapStyleWord(true);
    }

    private void chooseIcon() {
        IconSelector is = new IconSelector(icon, main, true);
        setupIcon(is.choice);
    }

    private void setupIcon(String ic) {
        if (ic != null) {
            icon = ic;
            if (icon.length() == 0) {
                chooseIconButton.setIcon(null);
            } else {
                chooseIconButton.setIcon(ArachComp.loadIcon("/" + icon));
            }
            repaint();
        }
    }

    private void processDefineKey(KeyEvent evt) {
        keyboardHook = new KeyDescription(evt);
        String newKey = keyboardHook.getDescription();
        String newCode = keyboardHook.toString();
        //System.out.println("key desc: " + newKey + "," + newCode);
        keyHookField.setText(newKey);
        //System.out.println(newKey + " : " + newCode);
        String prior = main.macroKeyHandler.checkDefinition(newCode);
        if (prior != null) {
            //System.out.println(prior);
            DefaultMutableTreeNode them = main.macroKeyHandler.getNodeForString(newCode);
            if (them != node) {
                int reply = JOptionPane.showConfirmDialog(this,
                        "The key code you have chosen is already mapped\nby \"" + prior + "\".\nOkay to overwrite that mapping?",
                        "Key code already in use", JOptionPane.YES_NO_OPTION);
                if (reply == JOptionPane.OK_OPTION) {
                    main.macroKeyHandler.removeKeyMacro(newCode);
                } else {
                    keyHookField.setText("");
                }
            }
        }
    }

    private void insertMacro(Object ob) {
        setChanged();
        String s = (String) ((JComboBox) ob).getSelectedItem();
        macroTextArea.replaceSelection(s);
    }

    private void acceptClose() {
        acceptData();
        closeIt();
    }

    private void acceptData() {
        if (node != null) {
            data.title = titleField.getText().trim();
            data.toolTip = toolTipField.getText();
            data.keyboardHook = keyboardHook;
            data.icon = icon;
            data.refreshIcon();
            data.content = macroTextArea.getText();
            data.isToolBar = isToolBarCheckBox.getSelectedObjects() != null;
            data.isMenu = isMenuCheckBox.getSelectedObjects() != null;
            data.isHidden = isHiddenCheckBox.getSelectedObjects() != null;
            data.isSeparator = separatorCheckBox.getSelectedObjects() != null;
            data.showTitleAndIcon = showTitleCheckBox.getSelectedObjects() != null;
            node.setUserObject(data);
            data.name = ArachComp.getStringForNode(node);
            nameField.setText(data.name);
            if (parent instanceof MyJTree) {
                ((MyJTree) parent).isChanged = true;
            }
            //node = null;
            setChanged(false);
            parent.acceptEdit(node);
            updateMacroList(parent.getMacroList());
        }
        //validData = true;

    }

    /**
     * Closes the dialog
     */
    private void closeIt() {
        //System.out.println(parent.getClass());
        //setVisible(false);
        //dispose();
        /*
         if(parent instanceof JDialog) {
         //System.out.println("OK");
         ((JDialog)parent).setVisible(false);
         ((JDialog)parent).dispose();
         }*/
        //else if(parent instanceof MyJTree) {
        //    ((MyJTree)parent).acceptEdit(node);
        //}
    }
    /**
     * @param args the command line arguments
     */
    /*
     public static void main(String args[]) {
     MacroTreeNodeData d = new MacroTreeNodeData("Title","Tooltip","Content");
     new MacroEditor(new javax.swing.JFrame(), true,d).show();
     System.exit(0);
     }*/
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton chooseIconButton;
    private javax.swing.JButton clearKeyDef;
    private javax.swing.JButton closeButton;
    private javax.swing.JPanel controlPanel;
    private javax.swing.JMenuItem dockUndockMenuItem;
    private javax.swing.JCheckBox isHiddenCheckBox;
    private javax.swing.JCheckBox isMenuCheckBox;
    private javax.swing.JCheckBox isToolBarCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField keyHookField;
    private javax.swing.JToggleButton keyTestButton;
    private javax.swing.JMenuItem lineWrapMenuItem;
    private javax.swing.JComboBox<String> macroComboBox;
    private javax.swing.JTextArea macroTextArea;
    private javax.swing.JPanel middlePanel;
    private javax.swing.JTextField nameField;
    private javax.swing.JButton okButton;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JCheckBox separatorCheckBox;
    private javax.swing.JCheckBox showTitleCheckBox;
    private javax.swing.JComboBox<String> systemComBox;
    private javax.swing.JTextField titleField;
    private javax.swing.JTextField toolTipField;
    private javax.swing.JPanel topControlPanel;
    private javax.swing.JPanel topPanel;
    // End of variables declaration//GEN-END:variables
}
