// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * NodeData.java
 *
 * Created on February 5, 2002, 3:32 PM
 */

package MacroManager;
import javax.swing.*;
import Arachnophilia.*;

/**
 *
 * @author  Administrator
 * @version
 */

final public class MacroTreeNodeData {
    public String name = "";
    public String title = "";
    public String toolTip = "";
    public KeyDescription keyboardHook = new KeyDescription();
    public String icon = "";
    public String content = "";
    public ImageIcon imageIcon = null;
    public boolean isToolBar = false;
    public boolean isMenu = false;
    public boolean isHidden = false;
    public boolean isSeparator = false;
    public boolean showTitleAndIcon = false;
    public MacroTreeNodeData() {
    }
    public MacroTreeNodeData(String a, String b,String c,String d,String e,String f,boolean g, boolean h,boolean i,boolean j,boolean k) {
        name = a;
        title = b;
        toolTip = c;
        keyboardHook = new KeyDescription(d);
        content = e;
        icon = f;
        isToolBar = g;
        isMenu = h;
        isHidden = i;
        isSeparator = j;
        showTitleAndIcon = k;
        init();
    }
    
    public MacroTreeNodeData(String a, String b,String c,KeyDescription d,String e,String f,boolean g, boolean h,boolean i,boolean j,boolean k) {
        name = a;
        title = b;
        toolTip = c;
        if(d != null) {
            keyboardHook = (KeyDescription) d.clone();
        }
        content = e;
        icon = f;
        isToolBar = g;
        isMenu = h;
        isHidden = i;
        isSeparator = j;
        showTitleAndIcon = k;
        init();
    }
    
    private void init() {
        refreshIcon();
        if (keyboardHook == null) {
            keyboardHook = new KeyDescription();
        }
    }
    
    public void refreshIcon() {
        if(icon.length() > 0) {
            imageIcon = ArachComp.loadIcon("/" + icon);
        }
        else {
            imageIcon = null;
        }
    }
    
    // title, tooltip
    
    public MacroTreeNodeData(String a, String b,String c) {
        this(a,b,c,"","","",false,false,false,false,false);
    }
    
    // title, tooltip, content
    
    public MacroTreeNodeData(String a, String b,String c,String d) {
        this(a,b,c,"",d,"",false,false,false,false,false);
    }
    
    public Object clone() {
        return new MacroTreeNodeData(name,title,toolTip,keyboardHook,content,icon,isToolBar,isMenu,isHidden,isSeparator,showTitleAndIcon);
    }
    
    public String toString() {
        return title;
    }
    
    public String debugString() {
        return
        "{" + name + ","
        + title + ","
        + toolTip + ","
        + keyboardHook.getDescription() + ","
        + content + ","
        + icon + "}";
    }
    
    
}
