// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * MacroTreePanel.java
 *
 * Created on February 6, 2002, 10:48 AM
 */

package MacroManager;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;
import Arachnophilia.*;

/**
 *
 * @author  Administrator
 */
final public class MacroTreePanel extends javax.swing.JPanel {
    
    Arachnophilia main = null;
    public MyJTree mjt;
    int tabValue;
    DefaultMutableTreeNode buttonNode = null;
    Frame frame = null;
    /** Creates new form MacroTreePanel */
    public MacroTreePanel(Arachnophilia m) {
        main = m;
        tabValue = m.configValues.tabSize;
        init(m,tabValue);
    }
    /*
    public MacroTreePanel(Frame f,int tab) {
        init(f,tab);
    }*/
    
    private void init(Arachnophilia m,int tab) {
        frame = m;
        initComponents();
        if(main != null) {
            mjt = new MyJTree(main,tab);
            setEditMode(false,false);
        }
        else {
            mjt = new MyJTree(m,tabValue); 
        }
        mjt.setBackground(Color.WHITE);
        internalPanel.add(mjt,BorderLayout.CENTER);
        internalPanel.setBackground(mjt.getBackground());
        jScrollPane1.setViewportView(internalPanel);
        if(main != null) {
            oneClickBox.setSelected(main.configValues.oneClickMacroMode);
        }
        mjt.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                mouseHandler(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                mouseHandler(evt);
            }
        });
        //setVisible(true);
    }
    
    public boolean macroExists(String s) {
        if(mjt != null) {
            if(mjt.macroMap != null) {
                return mjt.macroMap.containsKey(s);
            }
        }
        return false;
    }
    
    public String getMacroContent(String s) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) mjt.macroMap.get(s);
        MacroTreeNodeData data = (MacroTreeNodeData) node.getUserObject();
        return data.content;
    }
    
    public JPopupMenu getButtonMenu(DefaultMutableTreeNode n) {
        buttonNode = n;
        //System.out.println("getButtonMenu: " + n);
        return (MyJPopupMenu)buttonPopupMenu;
    }
    
    public void saveOnExit() {
        mjt.saveOnExit();
    }
    
    private void mouseHandler(java.awt.event.MouseEvent evt) {
        //System.out.println("MacroTreePanel: " + evt);
        if(popupMenu.isPopupTrigger(evt)) {
            int x = evt.getX();
            int y = evt.getY();
            x -= jScrollPane1.getHorizontalScrollBar().getValue();
            y -= jScrollPane1.getVerticalScrollBar().getValue();
            mjt.selectOnRightClick(evt);
            showHideMenuItem.setSelected(mjt.itemVisible());
            ((MyJPopupMenu)popupMenu).show(this,x,y);
        }
    }
    
    private void changeEditMode(boolean force) {
        setEditMode(!mjt.editMode,force);
    }
    
    public void setEditMode(boolean mode,boolean force) {
        if(mode) {
            setOneClickMode(false);
        }
        mjt.setEditMode(mode,force);
        setEditCheckBox(mode);
    }
    
    public void setEditCheckBox(boolean v) {
        editModeCheckBox.setSelected(v);
        mjt.editMode = v;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        popupMenu = new MyJPopupMenu();
        showHideMenuItem = new javax.swing.JCheckBoxMenuItem();
        cutMenuItem = new javax.swing.JMenuItem();
        copyMenuItem = new javax.swing.JMenuItem();
        pasteMenuItem = new javax.swing.JMenuItem();
        moveUpMenuItem = new javax.swing.JMenuItem();
        moveDownMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        newMenuItem = new javax.swing.JMenuItem();
        deleteMenuItem = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        sortNormalMenuItem = new javax.swing.JMenuItem();
        sortReversemenuItem = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        readFile = new javax.swing.JMenuItem();
        readLegacyFile = new javax.swing.JMenuItem();
        writeFileMenuItem = new javax.swing.JMenuItem();
        buttonPopupMenu = new MyJPopupMenu();
        editMenuButton = new javax.swing.JMenuItem();
        moveUpMenu = new javax.swing.JMenuItem();
        moveDownMenu = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        internalPanel = new javax.swing.JPanel();
        bottomPanel = new javax.swing.JPanel();
        oneClickBox = new javax.swing.JCheckBox();
        editModeCheckBox = new javax.swing.JCheckBox();

        showHideMenuItem.setText("Show/(Hide) selected item  (key x)");
        showHideMenuItem.setToolTipText("Hiding applies to toolbars, buttons and menus");
        showHideMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showHideMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(showHideMenuItem);

        cutMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
        cutMenuItem.setText("Cut");
        cutMenuItem.setToolTipText("Cut this item");
        cutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cutMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(cutMenuItem);

        copyMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
        copyMenuItem.setText("Copy");
        copyMenuItem.setToolTipText("Copy this item");
        copyMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                copyMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(copyMenuItem);

        pasteMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
        pasteMenuItem.setText("Paste");
        pasteMenuItem.setToolTipText("Paste previously cut/copied item");
        pasteMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pasteMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(pasteMenuItem);

        moveUpMenuItem.setText("Move item up (key -)");
        moveUpMenuItem.setToolTipText("Move this item up the list");
        moveUpMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(moveUpMenuItem);

        moveDownMenuItem.setText("Move item down (key +)");
        moveDownMenuItem.setToolTipText("Move this item down the list");
        moveDownMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveDownMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(moveDownMenuItem);
        popupMenu.add(jSeparator1);

        newMenuItem.setText("New");
        newMenuItem.setToolTipText("Create new item");
        newMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(newMenuItem);

        deleteMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_DELETE, 0));
        deleteMenuItem.setText("Delete");
        deleteMenuItem.setToolTipText("Delete this item and all its children");
        deleteMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(deleteMenuItem);
        popupMenu.add(jSeparator2);

        sortNormalMenuItem.setText("Sort normal");
        sortNormalMenuItem.setToolTipText("Sort children in normal order");
        sortNormalMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortNormalMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(sortNormalMenuItem);

        sortReversemenuItem.setText("Sort reverse");
        sortReversemenuItem.setToolTipText("Sort children in reverse order");
        sortReversemenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortReversemenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(sortReversemenuItem);
        popupMenu.add(jSeparator3);

        readFile.setText("Read macro file");
        readFile.setToolTipText("Read commands from macro file");
        readFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                readFileActionPerformed(evt);
            }
        });
        popupMenu.add(readFile);

        readLegacyFile.setText("Read legacy file");
        readLegacyFile.setToolTipText("Read pre-version 5.0 \"toolbar file\"");
        readLegacyFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                readLegacyFileActionPerformed(evt);
            }
        });
        popupMenu.add(readLegacyFile);

        writeFileMenuItem.setText("Write macro file");
        writeFileMenuItem.setToolTipText("Write contents of selected node and its children");
        writeFileMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                writeFileMenuItemActionPerformed(evt);
            }
        });
        popupMenu.add(writeFileMenuItem);

        editMenuButton.setText("Edit");
        editMenuButton.setToolTipText("Edit this button");
        editMenuButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editMenuButtonActionPerformed(evt);
            }
        });
        buttonPopupMenu.add(editMenuButton);

        moveUpMenu.setText("Move Up/Left");
        moveUpMenu.setToolTipText("Move this item");
        moveUpMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpMenuActionPerformed(evt);
            }
        });
        buttonPopupMenu.add(moveUpMenu);

        moveDownMenu.setText("Move Down/Right");
        moveDownMenu.setToolTipText("Move this item");
        moveDownMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveDownMenuActionPerformed(evt);
            }
        });
        buttonPopupMenu.add(moveDownMenu);

        setBackground(new java.awt.Color(255, 255, 255));
        setToolTipText("JPanel");
        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));

        internalPanel.setBackground(java.awt.Color.white);
        internalPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        internalPanel.setLayout(new java.awt.BorderLayout());
        jScrollPane1.setViewportView(internalPanel);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

        bottomPanel.setMinimumSize(new java.awt.Dimension(0, 35));
        bottomPanel.setLayout(new java.awt.GridLayout(1, 0));

        oneClickBox.setText("One-click");
        oneClickBox.setToolTipText("Select one-click mode to use macros, deselect to edit them");
        oneClickBox.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        oneClickBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                oneClickBoxActionPerformed(evt);
            }
        });
        bottomPanel.add(oneClickBox);

        editModeCheckBox.setText("Edit");
        editModeCheckBox.setToolTipText("Select to allow macro editing");
        editModeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editModeCheckBoxActionPerformed(evt);
            }
        });
        bottomPanel.add(editModeCheckBox);

        add(bottomPanel, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents
    
    private void moveDownMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveDownMenuActionPerformed
        // Add your handling code here:
        moveDownButton();
    }//GEN-LAST:event_moveDownMenuActionPerformed
    
    private void moveUpMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpMenuActionPerformed
        // Add your handling code here:
        moveUpButton();
    }//GEN-LAST:event_moveUpMenuActionPerformed
    
    private void editMenuButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editMenuButtonActionPerformed
        // Add your handling code here:
        editButton();
    }//GEN-LAST:event_editMenuButtonActionPerformed
    
    private void editModeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editModeCheckBoxActionPerformed
        // Add your handling code here:
        changeEditMode(true);
    }//GEN-LAST:event_editModeCheckBoxActionPerformed
    
    private void showHideMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showHideMenuItemActionPerformed
        // Add your handling code here:
        mjt.showHide();
    }//GEN-LAST:event_showHideMenuItemActionPerformed
    
    private void writeFileMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_writeFileMenuItemActionPerformed
        // Add your handling code here:
        if(main != null)
            mjt.promptWriteMacroFile(main);
    }//GEN-LAST:event_writeFileMenuItemActionPerformed
    
    private void oneClickBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_oneClickBoxActionPerformed
        // Add your handling code here:
        toggleOneClickMode();
        
    }//GEN-LAST:event_oneClickBoxActionPerformed
    
    private void readLegacyFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_readLegacyFileActionPerformed
        // Add your handling code here:
        if(main != null)
            mjt.promptReadMacroFile(main,true);
    }//GEN-LAST:event_readLegacyFileActionPerformed
    
    private void readFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_readFileActionPerformed
        // Add your handling code here:
        if(main != null)
            mjt.promptReadMacroFile(main,false);
    }//GEN-LAST:event_readFileActionPerformed
    
    private void sortReversemenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortReversemenuItemActionPerformed
        // Add your handling code here:
        mjt.sortReverse();
    }//GEN-LAST:event_sortReversemenuItemActionPerformed
    
    private void sortNormalMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortNormalMenuItemActionPerformed
        // Add your handling code here:
        mjt.sortNormal();
    }//GEN-LAST:event_sortNormalMenuItemActionPerformed
    
    private void newMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newMenuItemActionPerformed
        // Add your handling code here:
        mjt.newNode();
    }//GEN-LAST:event_newMenuItemActionPerformed
    
    private void editMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editMenuItemActionPerformed
        // Add your handling code here:
        mjt.editNode(frame,tabValue);
    }//GEN-LAST:event_editMenuItemActionPerformed
    
    private void moveDownMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveDownMenuItemActionPerformed
        // Add your handling code here:
        mjt.moveDown();
    }//GEN-LAST:event_moveDownMenuItemActionPerformed
    
    private void moveUpMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpMenuItemActionPerformed
        // Add your handling code here:
        mjt.moveUp();
    }//GEN-LAST:event_moveUpMenuItemActionPerformed
    
    private void deleteMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteMenuItemActionPerformed
        // Add your handling code here:
        mjt.deleteNode();
    }//GEN-LAST:event_deleteMenuItemActionPerformed
    
    private void pasteMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pasteMenuItemActionPerformed
        // Add your handling code here:
        mjt.pasteNode();
    }//GEN-LAST:event_pasteMenuItemActionPerformed
    
    private void copyMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyMenuItemActionPerformed
        // Add your handling code here:
        mjt.copyNode();
    }//GEN-LAST:event_copyMenuItemActionPerformed
    
    private void cutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cutMenuItemActionPerformed
        // Add your handling code here:
        mjt.cutNode();
    }//GEN-LAST:event_cutMenuItemActionPerformed
    
    private void editButton() {
        //System.out.println("EditButton: " + buttonNode);
        if(buttonNode != null) {
            mjt.refocusNode(buttonNode);
            mjt.editNode();
        }
    }
    
    private void moveUpButton() {
        if(buttonNode != null) {
            mjt.refocusNode(buttonNode);
            mjt.moveUp();
        }
    }
    
    private void moveDownButton() {
        if(buttonNode != null) {
            mjt.refocusNode(buttonNode);
            mjt.moveDown();
        }
    }
    
    private void toggleOneClickMode() {
        if(main != null) {
            setOneClickMode(!main.configValues.oneClickMacroMode);
        }
    }
    
    private void setOneClickMode(boolean v) {
        if(main != null) {
            if(mjt.editMode && v) {
                v = false;
                main.beep();
            }
            main.configValues.oneClickMacroMode = v;
            oneClickBox.setSelected(v);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JPopupMenu buttonPopupMenu;
    private javax.swing.JMenuItem copyMenuItem;
    private javax.swing.JMenuItem cutMenuItem;
    private javax.swing.JMenuItem deleteMenuItem;
    private javax.swing.JMenuItem editMenuButton;
    private javax.swing.JCheckBox editModeCheckBox;
    private javax.swing.JPanel internalPanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JMenuItem moveDownMenu;
    private javax.swing.JMenuItem moveDownMenuItem;
    private javax.swing.JMenuItem moveUpMenu;
    private javax.swing.JMenuItem moveUpMenuItem;
    private javax.swing.JMenuItem newMenuItem;
    private javax.swing.JCheckBox oneClickBox;
    private javax.swing.JMenuItem pasteMenuItem;
    private javax.swing.JPopupMenu popupMenu;
    private javax.swing.JMenuItem readFile;
    private javax.swing.JMenuItem readLegacyFile;
    private javax.swing.JCheckBoxMenuItem showHideMenuItem;
    private javax.swing.JMenuItem sortNormalMenuItem;
    private javax.swing.JMenuItem sortReversemenuItem;
    private javax.swing.JMenuItem writeFileMenuItem;
    // End of variables declaration//GEN-END:variables
    
}
