// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * BuildToolbar.java
 *
 * Created on February 13, 2002, 8:27 PM
 */

package MacroManager;
import Arachnophilia.*;
import java.awt.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class ToolBarManager {
    
    Arachnophilia main;
    ArrayList<String> comList;
    int comIndex;
    /** Creates new BuildToolbar */
    public ToolBarManager(Arachnophilia m) {
        main = m;
    }
    
    public void buildToolBars(DefaultMutableTreeNode node) {
        main.getToolBarPanel().removeAll();
        main.getToolBar().removeAll();
        comList = new ArrayList<String>();
        comIndex = 0;
        buildToolBarsRecursive(node,0);
        main.getToolBar().updateUI();
        main.getToolBarPanel().updateUI();
    }
    
    public int buildToolBarsRecursive(DefaultMutableTreeNode parent, int index) {
        DefaultMutableTreeNode node;
        int len = parent.getChildCount();
        for(int i = 0;i < len;i++) {
            node = (DefaultMutableTreeNode) parent.getChildAt(i);
            MacroTreeNodeData data = (MacroTreeNodeData) node.getUserObject();
            if(!data.isHidden || (data.isToolBar && main.configValues.toolBarPanelVisibility == 2)) {
                boolean hasChildren = node.getChildCount() > 0;
                if(data.isToolBar && hasChildren) {
                    JToolBar toolBar;
                    if(index == 0) {
                        toolBar = addToolBar(main.getToolBar(),index);
                    }
                    else {
                        toolBar = addToolBar(new JToolBar(),index);
                    }
                    buildToolBarFromNode(toolBar,node,data.toolTip,index++);
                }
                // recursively search for toolbars
                index = buildToolBarsRecursive(node,index);
            }
        }
        return index;
    }
    
    private void buildToolBarFromNode(JToolBar toolBar, DefaultMutableTreeNode source,String toolTip,int index) {
        if(source != null) {
            
            toolBar.setToolTipText(toolTip);
            int len = source.getChildCount();
            toolBar.removeAll();
            for(int i = 0;i < len;i++) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)source.getChildAt(i);
                MacroTreeNodeData data = (MacroTreeNodeData) node.getUserObject();
                if(!data.isHidden) {
                    comList.add(data.content);
                    createToolBarButton(toolBar,node,comIndex);
                    comIndex++;
                }
            }
            toolBar.invalidate();
            //toolBar.updateUI();
        }
    }
    
    private JToolBar addToolBar(JToolBar toolBar,int index) {
        main.getToolBarPanel().setLayout(new GridLayout(index,1));
        if(index > 0) {
            main.getToolBarPanel().add(toolBar);
        }
        toolBar.setVisible(true);
        return toolBar;
    }
    
    private void createToolBarButton(JToolBar toolBar,DefaultMutableTreeNode node,int i) {
        MacroTreeNodeData data = (MacroTreeNodeData) node.getUserObject();
        if(data.isSeparator) {
            JSeparator sep = new JSeparator(JSeparator.VERTICAL);
            toolBar.add(sep);
        }
        else {
            MyJButton b = new MyJButton(main,node);
            //System.out.println("at manager: " + node);
            if(data.icon.length() > 0) {
                URL url = getClass().getResource("/" + data.icon);
                if(url != null) {
                    b.setIcon(new ImageIcon(url));
                }
                if(data.showTitleAndIcon) {
                    b.setText(data.title);
                }
            }
            else {
                b.setText(data.title);
            }
            if(data.toolTip.length() > 0) {
                b.setToolTipText(data.toolTip);
            }
            final int v = i;
            b.addActionListener(new java.awt.event.ActionListener() {
                @Override
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    execCom(v);
                }
            });
            toolBar.add(b);
        }
    }
    
    private void execCom(int i) {
        if(i >= 0 && i < comList.size()) {
            main.macroHandler.executeCommand((String)comList.get(i));
        }
    }
}