// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package SourceBeautifiers;

import Arachnophilia.*;
import java.util.*;
import java.util.regex.*;
import javax.swing.*;

/**
 *
 * @author lutusp
 */
final public class BashBeautifier {

    boolean DEBUG = false;
    String tabStr = ArachComp.getTabString();
    Arachnophilia main;

    public BashBeautifier(Arachnophilia m) {
        main = m;
    }

    private int countMatches(String data, String pattern) {
        int count = 0;
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(data);
        while (m.find()) {
            count++;
        }
        return count;
    }

    private String makeTab(int count) {
        String out = "";
        while (count-- > 0) {
            out += tabStr;
        }
        return out;
    }

    public String beautify(String path, String data) {
        int tab = 0;
        Stack<Integer> caseStack = new Stack<Integer>();
        int caseStackSize = 0;
        boolean inHereDoc = false;
        boolean deferExtQuote = false;
        boolean inExtQuote = false;
        String extQuoteString = "";
        String hereString = "";
        String debugStr;
        StringBuilder output = new StringBuilder();
        int line = 1;
        int inc;
        int outc;
        String[] array = data.split("\n");
        for (String record : array) {
            String strippedRecord = record.trim();
            // right-hand whitespace only
            record = record.replaceFirst("\\s*$", "");
            // collapse multiple quotes between ' ... '
            String testRecord = strippedRecord.replaceAll("'.*?'", "");
            // collapse multiple quotes between " ... "
            testRecord = testRecord.replaceAll("\".*?\"", "");
            // collapse multiple quotes between ` ... `
            testRecord = testRecord.replaceAll("`.*?`", "");
            // collapse multiple quotes between \` ... ' (a weird case)
            testRecord = testRecord.replaceAll("\\\\`.*?'", "");
            // now strip any escaped single characters
            testRecord = testRecord.replaceAll("\\\\.", "");
            // remove '#' comments anywhere in line
            testRecord = testRecord.replaceFirst("(\\A|\\s)(#.*)", "");
            //output.append("testrecord: " + testRecord + "\n");
            if (!inHereDoc) {
                if (testRecord.matches(".*<<-?.*")) {
                    hereString = strippedRecord.replaceFirst(".*<<-?\\s*['\"]?([\\w_]+)['\"]?.*", "$1");
                    inHereDoc = hereString.length() > 0;
                }
            }
            // pass on without change
            if (inHereDoc) {
                debugStr = (DEBUG) ? "inheredoc:" + hereString + ">" : "";
                output.append(debugStr).append(record).append("\n");
                // now test for here-doc termination string
                if (testRecord.indexOf(hereString) != -1 && testRecord.indexOf("<<") == -1) {
                    inHereDoc = false;
                }
            } else { // not in here-doc
                if (inExtQuote) {
                    if (testRecord.indexOf(extQuoteString) != -1) {
                        testRecord = testRecord.replaceFirst(".*" + extQuoteString + "(.*)", "$1");
                        inExtQuote = false;
                    }
                } else { // not in extended quote
                    if (testRecord.matches(".*(\\A|\\s)('|\").*")) {
                        // apply only after this line has been processed
                        deferExtQuote = true;
                        // get the delimiter
                        extQuoteString = testRecord.replaceFirst(".*(\\A|\\s)(['\"]).*", "$2");
                        // provide line before quote
                        testRecord = testRecord.replaceFirst("(.*)" + extQuoteString + ".*", "$1");
                    }
                }
                // pass on without change
                if (inExtQuote) {
                    debugStr = (DEBUG) ? "inext>" : "";
                    output.append(debugStr).append(record).append("\n");
                } else { // not in extended quote
                    inc = countMatches(testRecord, "(\\s|\\A|;)(case|then|do)(;|\\Z|\\s)");
                    inc += countMatches(testRecord, "(\\{|\\(|\\[)");
                    outc = countMatches(testRecord, "(\\s|\\A|;)(esac|fi|done|elif)(;|\\)|\\||\\Z|\\s)");
                    outc += countMatches(testRecord, "(\\}|\\)|\\])");
                    if (testRecord.matches(".*\\besac\\b.*")) {
                        if (caseStack.size() == 0) {
                            JOptionPane.showMessageDialog(main, "File:" + path + ", error: \"esac\" before \"case\" in line " + line, ArachConstants.APPNAME + " Code Beautifier", JOptionPane.INFORMATION_MESSAGE);
                            //System.err.println("File:" + path + ", error: \"esac\" before \"case\" in line " + line);
                        } else {
                            outc += caseStack.pop();
                            caseStackSize = caseStack.size();
                        }
                    }
                    // sepcial handling for bad syntax within case ... esac
                    if (caseStack.size() > 0) {
                        if (testRecord.matches(".*\\A[^(]*\\).*") && caseStackSize > 0) {
                            // avoid overcount
                            outc -= 2;
                            caseStack.set(caseStackSize - 1, caseStack.get(caseStackSize - 1) + 1);
                        }
                        if (testRecord.matches(".*;;.*") && caseStackSize > 0) {
                            outc += 1;
                            caseStack.set(caseStackSize - 1, caseStack.get(caseStackSize - 1) - 1);
                        }
                    }
                    // an ad-hoc solution for the "else" keyword
                    int elseCase = (testRecord.matches(".*^(else).*")) ? -1 : 0;
                    int net = inc - outc;
                    tab += Math.min(net, 0);
                    int extab = tab + elseCase;
                    extab = Math.max(0, extab);
                    debugStr = (DEBUG) ? tab + ">" + inHereDoc + ">" : "";
                    output.append(debugStr).append(makeTab(extab)).append(strippedRecord).append("\n");
                    tab += Math.max(net, 0);
                    //System.out.println(tab);
                }
                if (deferExtQuote) {
                    inExtQuote = true;
                    deferExtQuote = false;
                }
                if (testRecord.matches(".*\\bcase\\b.*")) {
                    caseStack.push(0);
                    caseStackSize = caseStack.size();
                }
            }
            line += 1;
        }
        if (tab != 0) {
            JOptionPane.showMessageDialog(main, "Error in " + path + ": indent/outdent mismatch:" + tab, ArachConstants.APPNAME + " Code Beautifier", JOptionPane.INFORMATION_MESSAGE);

            // System.err.println("File:" + path + ", error: indent/outdent mismatch: " + tab);
        }
        //System.out.println("-----------------");
        return output.toString();
    }
}
