// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * BeautifyHTML.java
 *
 * Created on February 22, 2002, 9:56 AM
 */
package SourceBeautifiers;

//import ArachConstants;
//import ArachComp;
import Arachnophilia.*;
import java.util.regex.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class XHTMLBeautifyUtils {

    Arachnophilia main;
    //Hashtable soloTags,beautifySkipTags,compressSkipTags;
    boolean validSetup = true;
    SearchReplace srch;

    /** Creates new BeautifyHTML */
    public XHTMLBeautifyUtils(Arachnophilia m) {
        main = m;
        srch = new SearchReplace();
    }
    Pattern regex_suspend_resume[][] = {
        {Pattern.compile("<script\\b"), Pattern.compile("</script>")},
        {Pattern.compile("<pre\\b"), Pattern.compile("</pre>")},
        {Pattern.compile("<code\\b"), Pattern.compile("</code>")},
        {Pattern.compile("<\\?php"), Pattern.compile("\\?>")},
        {Pattern.compile("<%"), Pattern.compile("%>")},
        {Pattern.compile("<style\\b"), Pattern.compile("</style>")}
    };
    Pattern doctypePat = Pattern.compile("^(<!doctype|<\\?php\\b|<\\?xml\\b)");
    Pattern stripPat = Pattern.compile("^\\s*(.*?)\\s*$");
    Pattern tagPat = Pattern.compile("<.*?>");
    Pattern indentPat = Pattern.compile("(<[^/].*?[^/]>|<\\w+?>)");
    Pattern outdentPat = Pattern.compile("</.*?>");
    Pattern delCommentPat = Pattern.compile("<!--.*?-->");
    Pattern delPhpPat = Pattern.compile("<\\?php.*?\\?>");
    Pattern delAspPat = Pattern.compile("<%.*?%>");
    Pattern delScriptPat = Pattern.compile("<script.*?>.*?</script>");

    public String beautifyHTML(String data) {
        return beautifyHTML(data, true);
    }

    public String beautifyHTML(String data, boolean complain) {
        // don't try to beautify files with no tag content
        if(data.indexOf("<") == -1) {
            return data;
        }
        StringBuilder output = new StringBuilder();
        String lineEnding = "\n";
        String tabChar = ArachComp.getTabString();
        String array[] = data.split(lineEnding);
        int tab = 0;
        int suspend = 0;
        for (int i = 0; i < array.length; i++) {
            int delta = 0;
            String line = array[i];
            String orig_line = line;
            Matcher m = stripPat.matcher(line);
            if (m.find()) {
                line = m.group(1);
            }
            //System.out.println(line);
            String test_line = line.toLowerCase();
            test_line = delPhpPat.matcher(test_line).replaceAll("");
            test_line = delAspPat.matcher(test_line).replaceAll("");
            test_line = delScriptPat.matcher(test_line).replaceAll("");
            test_line = delCommentPat.matcher(test_line).replaceAll("");
            if (!doctypePat.matcher(test_line).find()) {
                for (int j = 0; j < regex_suspend_resume.length; j++) {
                    if (regex_suspend_resume[j][1].matcher(test_line).find() && !regex_suspend_resume[j][0].matcher(test_line).find()) {
                        suspend--;
                    }
                }
                String tags[] = ArachComp.extractAllRegexMatches(test_line, tagPat);
                int indents = 0;
                int outdents = 0;
                for (int k = 0; k < tags.length; k++) {
                    String s = tags[k];
                    indents += ArachComp.extractAllRegexMatches(s, indentPat).length;
                    outdents += ArachComp.extractAllRegexMatches(s, outdentPat).length;
                }
                delta = indents - outdents;
            }
            if (delta < 0) {
                tab += delta;
            }
            String result;
            if (suspend > 0) {
                result = orig_line + lineEnding;
            } else {
                result = createTab(tab, tabChar) + line + lineEnding;
            }
            if (delta > 0) {
                tab += delta;
            }
            for (int j = 0; j < regex_suspend_resume.length; j++) {
                if (regex_suspend_resume[j][0].matcher(test_line).find() && !regex_suspend_resume[j][1].matcher(test_line).find()) {
                    suspend++;
                }
            }
            output.append(result);
        }
        if (tab != 0 && complain) {
            String err = "Beautify error: start/end tag mismatch: n = " + tab + "\n";
            err += "n > 0 means more <starting> tags than </ending> tags.\n";
            err += "n < 0 means more </ending> tags than <starting> tags.\n\n";
            err += "This error can be caused by beautifying a selection\n" + "rather than the entire document.";
            JOptionPane.showMessageDialog(
                    main, err,
                    ArachConstants.APPNAME + " HTML Beautify",
                    JOptionPane.INFORMATION_MESSAGE);
        }
        return output.toString();
    }

    private String createTab(int i, String tabChar) {
        StringBuilder sb = new StringBuilder();
        while (i-- > 0) {
            sb.append(tabChar);
        }
        return sb.toString();
    }

    private String isolateTag(String data, int i) {
        int len = data.length();
        while (i < len) {
            char c = data.charAt(i);
            if (c != '<' && c != '/') {
                break;
            }
            i++;
        }
        int a = i;
        while (i < len) {
            char c = data.charAt(i);
            if (Character.isWhitespace(c) || c == '>') {
                break;
            }
            i++;
        }
        return data.substring(a, i).toLowerCase();
    }

    // this routine is used to recompress plain text
    public String compressText(String content) {
        content = content.replaceAll("[ |\t]+\n", "\n");
        content = content.replaceAll("\n[ |\t]+", "\n");
        return content.replaceAll("(\\S)\\n(\\S)", "$1 $2");
    }
}
