// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 /*
 * SpellCheckFrame.java
 *
 * Created on February 26, 2002, 7:47 AM
 */

package SpellCheck;

import Arachnophilia.*;
//import ArachConstants;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
final public class SpellCheckFrame extends javax.swing.JFrame {

    SpellCheckPanel panel;
    /** Creates new form SpellCheckFrame */
    public SpellCheckFrame(Arachnophilia m) {
        initComponents();
        panel = new SpellCheckPanel(m,this);
        getContentPane().add(panel);
         setIconImage(m.getIconImage());
          setTitle(ArachConstants.APPNAME + " Spell Checker");
        pack();
        Point r = m.getLocation();
        Dimension d = m.getSize();
        
        setLocation(r.x+d.width/32,r.y+d.height/32);
        
        setVisible(true);
    }
    
    public void spellCheck()
    {
        setVisible(true);
        panel.spellCheckEntry();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        pack();
    }//GEN-END:initComponents

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        saveAndHide();
    }//GEN-LAST:event_exitForm

    
    public void saveAndHide()
    {
        panel.saveCustomDict();
        setVisible(false);
    }
    
    public void saveAndQuit()
    {
        saveAndHide();
        dispose();
    }
    /**
    * @param args the command line arguments
    *//*
    public static void main(String args[]) {
        new SpellCheckFrame().show();
    }*/


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
