// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * StyleColorDialog.java
 *
 * Created on February 28, 2002, 12:45 PM
 */
package StyleColorHandler;

//import SyntaxStyleData;
//import MyJButton;
import Arachnophilia.*;
import java.lang.reflect.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
final public class StyleColorDialog extends javax.swing.JDialog {

    Arachnophilia main;

    /** Creates new form StyleColorDialog */
    public StyleColorDialog(Arachnophilia m) {
        super(m, true);
        main = m;
        initComponents();
        String comment = "NOTE: Be sure to load the document type you are interested in changing, and make it visible while you make adjustments -- this dialog will update the display in real time.";
        commentArea.setText(comment);
        commentArea.setBackground(getContentPane().getBackground());
        loadColorPanel();
        pack();
        Rectangle ss = main.getBounds();
        int w = ss.width / 4;
        int h = ss.height / 4;
        setBounds(ss.x + w, ss.y + h, ss.width - w * 2, ss.height - h * 2);
        setTitle("Choose Syntax Colors");
        setVisible(true);
    }

    private void loadColorPanel() {
        Class cv = main.configValues.getClass();
        Field[] array = cv.getFields();
        try {
            int n = 0;
            for (int i = 0; i < array.length; i++) {
                Field f = array[i];
                Object o = f.get(main.configValues);
                if (o instanceof SyntaxStyleData) {
                    String name = String.format("%24s" , f.getName());
                    //System.out.println(f.getName());
                    StyleColorPanel panel = new StyleColorPanel(main, (SyntaxStyleData) o, name);
                    //panel.setBackground(Color.red);
                    colorsPanel.add(panel);
                    n++;
                }
            }
            colorsPanel.setLayout(new GridLayout(n, 1));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updatePanel() {
        Class cv = main.configValues.getClass();
        Field[] array = cv.getFields();
        try {
            int n = 0;
            for (int i = 0; i < array.length; i++) {
                Field f = array[i];
                Object o = f.get(main.configValues);
                if (o instanceof SyntaxStyleData) {
                    ((StyleColorPanel)colorsPanel.getComponent(n)).newStyle((SyntaxStyleData)o);
                    n++;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetDefaults() {
        main.configValues.STYLE_COMMENT = new SyntaxStyleData(new Color(128, 128, 128), true, false);
        main.configValues.STYLE_DOC_COMMENT = new SyntaxStyleData(new Color(64, 64, 64), true, false);
        main.configValues.STYLE_KEYWORD = new SyntaxStyleData(new Color(0, 0, 128), false, true);
        main.configValues.STYLE_FUNCTION = new SyntaxStyleData(new Color(173, 128, 0), false, false);
        main.configValues.STYLE_LITERAL_NUMBER = new SyntaxStyleData(new Color(100, 0, 200), false, false);
        main.configValues.STYLE_LITERAL_STRING = new SyntaxStyleData(new Color(160, 0, 0), false, false);
        main.configValues.STYLE_DATA = new SyntaxStyleData(new Color(0, 128, 128), false, false);
        main.configValues.STYLE_VARIABLE = new SyntaxStyleData(new Color(0, 128, 192), false, false);
        main.configValues.STYLE_IDENTIFIER = new SyntaxStyleData(new Color(0, 0, 0), false, false);
        main.configValues.STYLE_WHITESPACE = new SyntaxStyleData(new Color(128, 128, 128), false, false);
        main.configValues.STYLE_SEPARATOR = new SyntaxStyleData(new Color(160, 0, 0), false, false);
        main.configValues.STYLE_OPERATOR = new SyntaxStyleData(new Color(128, 64, 64), false, false);
        main.configValues.STYLE_PREPROCESSOR = new SyntaxStyleData(new Color(128, 128, 128), false, false);
        main.configValues.STYLE_MARKUP_DELIM = new SyntaxStyleData(new Color(128, 0, 128), false, false);
        main.configValues.STYLE_MARKUP_NAME = new SyntaxStyleData(new Color(0, 0, 192), false, false);
        main.configValues.STYLE_MARKUP_ATTRIB = new SyntaxStyleData(new Color(63, 127, 127), false, false);
        main.configValues.STYLE_ERROR = new SyntaxStyleData(new Color(148, 0, 0), false, false);
        updatePanel();
        refreshDocs();
    }

    private void refreshDocs() {
        ArachDocument[] a = main.fileHandler.docArray();
        for (int i = 0; i < a.length; i++) {
            ArachDocument doc = a[i];
            if (doc != null) {
                doc.textComp.readNewColorValues();
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        colorPanelScrollPane = new javax.swing.JScrollPane();
        colorsPanel = new javax.swing.JPanel();
        southPanel = new javax.swing.JPanel();
        resetButton = new MyJButton();
        closeButton = new MyJButton();
        northPanel = new javax.swing.JPanel();
        commentArea = new javax.swing.JTextArea();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        colorPanelScrollPane.setViewportView(colorsPanel);

        getContentPane().add(colorPanelScrollPane, java.awt.BorderLayout.CENTER);

        resetButton.setText("Reset to Defaults");
        resetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetButtonActionPerformed(evt);
            }
        });
        southPanel.add(resetButton);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        southPanel.add(closeButton);

        getContentPane().add(southPanel, java.awt.BorderLayout.SOUTH);

        northPanel.setLayout(new java.awt.BorderLayout());

        commentArea.setBackground(new java.awt.Color(204, 204, 204));
        commentArea.setEditable(false);
        commentArea.setLineWrap(true);
        commentArea.setWrapStyleWord(true);
        commentArea.setMargin(new java.awt.Insets(8, 8, 8, 8));
        northPanel.add(commentArea, java.awt.BorderLayout.CENTER);

        getContentPane().add(northPanel, java.awt.BorderLayout.NORTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        quit();
    }//GEN-LAST:event_closeButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        quit();
    }//GEN-LAST:event_closeDialog

    private void resetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetButtonActionPerformed
        // TODO add your handling code here:
        resetDefaults();
    }//GEN-LAST:event_resetButtonActionPerformed

    private void quit() {
        setVisible(false);
        dispose();
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
    new StyleColorDialog(new javax.swing.JFrame(), true).show();
    }*/

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JScrollPane colorPanelScrollPane;
    private javax.swing.JPanel colorsPanel;
    private javax.swing.JTextArea commentArea;
    private javax.swing.JPanel northPanel;
    private javax.swing.JButton resetButton;
    private javax.swing.JPanel southPanel;
    // End of variables declaration//GEN-END:variables
}
