// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

/*
 * StyleColorPanel.java
 *
 * Created on February 28, 2002, 12:30 PM
 */
package StyleColorHandler;

import Arachnophilia.*;
//import ArachDocument;
//import SyntaxStyleData;
//import MyJButton;
import javax.swing.*;
import java.awt.*;
import org.fife.ui.rsyntaxtextarea.*;
import javax.swing.text.StyleContext;

/**
 *
 * @author  Administrator
 */
final public class StyleColorPanel extends javax.swing.JPanel {

    SyntaxStyleData data;
    String name;
    Arachnophilia main;

    /** Creates new form StyleColorPanel */
    public StyleColorPanel(Arachnophilia m, SyntaxStyleData d, String n) {
        main = m;
        data = d;
        name = n;
        initComponents();
        String tabName = name + ":";
        while (tabName.length() < 12) {
            tabName += " ";
        }
        nameLabel.setText(tabName);
        // God, this is annoying.
        // some assholes decided to prevent
        // setting button backgrounds
        // in any meaningful way

        refreshSettings();
    }

    private void refreshSettings() {
        resetButtonColor();
        italicCheckBox.setSelected(data.italic);
        boldCheckBox.setSelected(data.bold);
    }

    public void newStyle(SyntaxStyleData d) {
        data = d;
        refreshSettings();
    }

    private void changeColor() {
        Color col = JColorChooser.showDialog(main, "Choose a color for " + name, new Color(data.color));
        if (col != null) {
            data.color = col.getRGB();
            resetButtonColor();
            refreshDocs();
        }
    }

    private void resetButtonColor() {
        int v = data.color;
        String hexcolor = Integer.toHexString(v);
        if (hexcolor.length() == 8) {
            hexcolor = hexcolor.substring(2, 8);
        }
        //colorPatch.setText("<html><span style=\"background:#" + hexcolor + ";\">&nbsp;</span></html>");
        colorPatch.setBackground(new Color(data.color));
        colorPatch.setForeground(new Color(data.color));
    }

    private void setItalic(Object b) {
        data.italic = ((JCheckBox) b).getSelectedObjects() != null;
        refreshDocs();
    }

    private void setBold(Object b) {
        data.bold = ((JCheckBox) b).getSelectedObjects() != null;
        refreshDocs();
    }

    private void refreshDocs() {
        ArachDocument[] a = main.fileHandler.docArray();
        for (int i = 0; i < a.length; i++) {
            ArachDocument doc = a[i];
            if (doc != null) {
                doc.textComp.readNewColorValues();
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        nameLabel = new javax.swing.JLabel();
        colorPatch = new javax.swing.JButton();
        setColor = new MyJButton();
        italicCheckBox = new javax.swing.JCheckBox();
        boldCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        nameLabel.setFont(new java.awt.Font("Monospaced", 0, 14)); // NOI18N
        nameLabel.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        add(nameLabel, gridBagConstraints);

        colorPatch.setText("<html>&nbsp;&nbsp;&nbsp;</html>");
        colorPatch.setPreferredSize(new java.awt.Dimension(24, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(colorPatch, gridBagConstraints);

        setColor.setText("Choose Color");
        setColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(setColor, gridBagConstraints);

        italicCheckBox.setText("Italic");
        italicCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                italicCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(italicCheckBox, gridBagConstraints);

        boldCheckBox.setText("Bold");
        boldCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                boldCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(boldCheckBox, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void boldCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_boldCheckBoxActionPerformed
        // Add your handling code here:
        setBold(evt.getSource());
    }//GEN-LAST:event_boldCheckBoxActionPerformed

    private void italicCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_italicCheckBoxActionPerformed
        // Add your handling code here:
        setItalic(evt.getSource());
    }//GEN-LAST:event_italicCheckBoxActionPerformed

    private void setColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setColorActionPerformed
        // Add your handling code here:
        changeColor();
    }//GEN-LAST:event_setColorActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox boldCheckBox;
    private javax.swing.JButton colorPatch;
    private javax.swing.JCheckBox italicCheckBox;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JButton setColor;
    // End of variables declaration//GEN-END:variables
}
