/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FileProcPanel
extends JPanel {
    final int bufferSize = 32768;
    final double requiredJavaVersion = 1.5;
    final String helpFileName = "FileProcHelp.txt";
    String[] modeButtonStrings = new String[]{"Compare dates & sizes", "Compare entire files (slow)", "Update files & directories", "Update modified times", "Synchronize compare-only", "Synchronize dest. with source"};
    String[] comlineModes = new String[]{"cd", "ce", "uf", "um", "sc", "ss"};
    static final int MODE_COMPARE_SIMPLE = 0;
    static final int MODE_COMPARE_ENTIRE = 1;
    static final int MODE_UPDATE_FILES = 2;
    static final int MODE_UPDATE_MOD_TIME = 3;
    static final int MODE_SYNC_COMPARE = 4;
    static final int MODE_SYNC_SOURCE = 5;
    String[] optionButtonStrings = new String[]{"Include subdirectories", "Strict time checking", "Update if sizes differ", "Update if comparison differs", "Prompt before deleting", "Copy read-only files", "Detailed error/event Log", "Skip nonexistent destinations", "Visible while running scripts"};
    String[] comlineOptions = new String[]{"is", "st", "us", "uc", "pd", "cr", "dl", "sd", "vi"};
    String[] comlineActions = new String[]{"sp", "dp", "se", "de", "rf", "wl", "ex", "qp"};
    String[] comlineActionStrings = new String[]{"[path] Set source path", "[path] Set destination path", "[path extension] Set source path extension", "[path extension] Set destination path extension", "[filename] Read command file, execute its contents", "[filename] Write log file", "Execute (must be present for action to be executed)", "Quit program"};
    boolean scanSubs;
    boolean strictTime;
    boolean updateIfSizeDiffers;
    boolean updateIfCompDiffers;
    boolean promptBeforeDelete;
    boolean copyReadOnly;
    boolean detailedLog;
    boolean skipNonexistentDests;
    boolean visWhileRunning;
    NumDispField[] numDisp;
    FileProc parent;
    int mode;
    boolean stop = true;
    boolean syncModes = false;
    boolean userInterrupt = false;
    boolean comScript = false;
    boolean quitAfterComs = false;
    boolean isScanning = false;
    boolean logFileWritten = false;
    boolean needInit = true;
    long srcFiles;
    long srcDirs;
    long srcBytes;
    long destFiles;
    long destDirs;
    long destBytes;
    long movedBytes;
    long createdFiles;
    long createdDirs;
    long totalErrors;
    long grandTotalErrors;
    Thread scanThread = null;
    private ButtonGroup modeGroup;
    private JRadioButton[] modeArray;
    private JCheckBox[] optionArray;
    private Vector deleteList = null;
    String userPath;
    String baseSourcePath = "";
    String baseDestPath = "";
    private JPanel behaviorsPanel;
    private JPanel blPanel;
    private JPanel brPanel;
    private JButton browseDestButton;
    private JButton browseSourceButton;
    private JPanel contentPanel;
    private JTextField destItem;
    private JTextField destPath;
    private JButton goButton;
    private JPanel helpPanel;
    private JTextArea helpTextArea;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;
    private JTextField jTextField9;
    private JPanel logPanel;
    private JTextArea logTextArea;
    private JPanel middlePanel;
    private JTextField sourceItem;
    private JTextField sourcePath;
    private JPanel statusPanel;
    private JTextField statusTextField;
    private JButton stopButton;
    private JTabbedPane tabPane;
    private JPanel topPanel;

    public FileProcPanel(FileProc fileProc) {
        this.parent = fileProc;
        this.testJavaVersion();
        this.setFont(this.parent.progFont);
        this.initComponents();
        this.tabPane.setTitleAt(0, "Control/Status");
        this.tabPane.setTitleAt(1, "Behaviors");
        this.tabPane.setTitleAt(2, "Event/Error Log");
        this.tabPane.setTitleAt(3, "Help");
        this.numDisp = new NumDispField[]{new NumDispField(this.jTextField1), new NumDispField(this.jTextField2), new NumDispField(this.jTextField3), new NumDispField(this.jTextField4), new NumDispField(this.jTextField5), new NumDispField(this.jTextField6), new NumDispField(this.jTextField7), new NumDispField(this.jTextField8), new NumDispField(this.jTextField9)};
        this.userPath = System.getProperty("user.home") + "/.FileProc";
        File file = new File(this.userPath);
        if (!file.exists()) {
            file.mkdir();
        }
        this.addButtons();
        this.setStatus("Ready.");
        this.setButtons(this.stop);
        this.setupHelp();
    }

    private void testJavaVersion() {
        String string = System.getProperty("java.version");
        int n = string.length();
        int n2 = string.indexOf(46);
        if (n2 != -1 && n2 < n - 1) {
            int n3 = string.indexOf(46, n2 + 1);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            try {
                double d = Double.parseDouble(string);
                if (1.5 > d) {
                    JOptionPane.showMessageDialog(this, "Very Sorry!\n\nArachnophilia requires a Java runtime engine (JRE)\nwith a version of1.5 or better.\nThis machine has a version " + d + " JRE.\n" + "Please acquire the correct JRE at http://java.sun.com.", "Wrong Java Runtime Version", 2);
                    this.parent.quit();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setupHelp() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.readResourceTextFile("FileProcHelp.txt"));
        stringBuffer.append("\nAppendix A: Command-line syntax\n");
        stringBuffer.append(this.dashLine(60) + "\n");
        stringBuffer.append("\nModes (only one can be active at a time):\n\n");
        for (n = 0; n < this.comlineModes.length; ++n) {
            stringBuffer.append("\t-" + this.comlineModes[n] + " " + this.modeButtonStrings[n] + "\n");
        }
        stringBuffer.append("\nOptions (multiple choices may be made):\n\n");
        for (n = 0; n < this.comlineOptions.length; ++n) {
            stringBuffer.append("\t-" + this.comlineOptions[n] + " [y/n, no arg: y] " + this.optionButtonStrings[n] + "\n");
        }
        stringBuffer.append("\nActions:\n\n");
        for (n = 0; n < this.comlineActions.length; ++n) {
            stringBuffer.append("\t-" + this.comlineActions[n] + " " + this.comlineActionStrings[n] + "\n");
        }
        this.helpTextArea.setText(stringBuffer.toString());
        this.helpTextArea.setMargin(new Insets(4, 4, 4, 4));
    }

    private String readResourceTextFile(String string) {
        String string2 = "";
        try {
            String string3;
            URL uRL = this.getClass().getResource("FileProcHelp.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            string2 = "Error reading help file: " + exception.getMessage();
        }
        return string2;
    }

    public void processArgs(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.comScript = true;
            this.userInterrupt = false;
            this.quitAfterComs = false;
            this.logFileWritten = false;
            this.grandTotalErrors = 0L;
            long l = new Date().getTime();
            this.execArgs(stringArray);
            this.comScript = false;
            if (!this.logFileWritten) {
                this.logEventOption("Grand total errors, all processes: " + this.grandTotalErrors);
            }
            if (this.quitAfterComs) {
                this.parent.quit();
            } else {
                this.setEditablePaths(true);
                long l2 = new Date().getTime();
                if (l2 - l > 15000L && this.visWhileRunning) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private void execArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length && !this.userInterrupt; ++i) {
            if (this.needInit && i == 1) {
                this.needInit = false;
                this.getOptions();
                this.parent.setVisible(this.visWhileRunning);
            }
            this.sleepWhileScanning();
            if (this.userInterrupt || stringArray[i].length() <= 0 || stringArray[i].charAt(0) != '-') continue;
            boolean bl = false;
            String string = stringArray[i];
            if (stringArray[i].length() == 3) {
                String string2 = stringArray[i].substring(1, 3).toLowerCase().trim();
                if (this.setOption(string2, stringArray, i)) {
                    bl = true;
                    continue;
                }
                if (this.setComMode(string2)) {
                    bl = true;
                    continue;
                }
                if (this.execActions(string2, stringArray, i)) {
                    bl = true;
                    continue;
                }
            }
            if (bl) continue;
            this.logError("Command Error: Command not found: \"" + string + "\".");
            this.userInterrupt = true;
        }
        this.sleepWhileScanning();
    }

    private void sleepWhileScanning() {
        while (this.isScanning) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                this.isScanning = false;
                this.userInterrupt = true;
            }
        }
    }

    private boolean setOption(String string, String[] stringArray, int n) {
        for (int i = 0; i < this.comlineOptions.length; ++i) {
            if (!string.equals(this.comlineOptions[i])) continue;
            boolean bl = true;
            if (n < stringArray.length - 1) {
                String string2 = stringArray[n + 1].toLowerCase();
                bl = !string2.equals("n");
            }
            this.optionArray[i].setSelected(bl);
            return true;
        }
        return false;
    }

    private boolean setComMode(String string) {
        for (int i = 0; i < this.comlineModes.length; ++i) {
            if (!string.equals(this.comlineModes[i])) continue;
            return this.setMode(i);
        }
        return false;
    }

    private boolean execActions(String string, String[] stringArray, int n) {
        for (int i = 0; i < this.comlineActions.length; ++i) {
            if (!string.equals(this.comlineActions[i])) continue;
            switch (i) {
                case 0: {
                    return this.readPathString(this.sourcePath, stringArray, n);
                }
                case 1: {
                    return this.readPathString(this.destPath, stringArray, n);
                }
                case 2: {
                    return this.readPathExtension(this.sourcePath, stringArray, n);
                }
                case 3: {
                    return this.readPathExtension(this.destPath, stringArray, n);
                }
                case 4: {
                    return this.readComFile(stringArray, n);
                }
                case 5: {
                    if (!this.logFileWritten) {
                        this.logEventOption("Grand total errors, all processes: " + this.grandTotalErrors);
                    }
                    this.logFileWritten = true;
                    return this.writeLogFile(stringArray, n);
                }
                case 6: {
                    this.isScanning = true;
                    this.startScan();
                    break;
                }
                case 7: {
                    this.quitAfterComs = true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean readPathString(JTextField jTextField, String[] stringArray, int n) {
        if (n < stringArray.length - 1) {
            jTextField.setText(stringArray[n + 1]);
            if (jTextField.equals(this.sourcePath)) {
                this.baseSourcePath = stringArray[n + 1];
            } else {
                this.baseDestPath = stringArray[n + 1];
            }
            return true;
        }
        return false;
    }

    private boolean readPathExtension(JTextField jTextField, String[] stringArray, int n) {
        if (n < stringArray.length - 1) {
            String string = "";
            string = jTextField.equals(this.sourcePath) ? this.baseSourcePath : this.baseDestPath;
            jTextField.setText(this.chainPath(string, stringArray[n + 1]));
            return true;
        }
        return false;
    }

    private String chainPath(String string, String string2) {
        if (string.length() > 0 && this.isPathDelim(string.charAt(string.length() - 1))) {
            string = string.substring(string.length() - 1);
        }
        if (string2.length() > 0 && this.isPathDelim(string2.charAt(0))) {
            string2 = string2.substring(1);
        }
        return string + '/' + string2;
    }

    private boolean isPathDelim(char c) {
        return c == '/' || c == '\\';
    }

    private boolean readComFile(String[] stringArray, int n) {
        if (n < stringArray.length - 1) {
            String[] stringArray2 = this.readParseFile(stringArray[n + 1]);
            if (stringArray2 != null) {
                this.execArgs(stringArray2);
                return true;
            }
            return false;
        }
        return false;
    }

    private String[] readParseFile(String string) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            string = this.userPath + '/' + string;
        }
        if (!(file = new File(string)).exists()) {
            return null;
        }
        String[] stringArray = this.parseBlock(this.readFile(file, true));
        return stringArray;
    }

    private String readFile(File file) {
        return this.readFile(file, false);
    }

    private String readFile(File file, boolean bl) {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (bl && (n = string2.indexOf(59)) != -1) {
                    string2 = string2.substring(0, n);
                }
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            this.logError("Error: file " + file.getPath() + " cannot be read");
            return null;
        }
        return string;
    }

    private boolean writeLogFile(String[] stringArray, int n) {
        if (n < stringArray.length - 1) {
            char c;
            String string = stringArray[n + 1];
            if (string.length() > 1 && !this.isPathDelim(c = string.charAt(0))) {
                string = this.userPath + '/' + string;
            }
            File file = new File(string);
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                String string2 = this.logTextArea.getText();
                string2 = this.srchRplc(0, string2, "\n", System.getProperty("line.separator"));
                printWriter.print(string2);
                printWriter.close();
                return true;
            }
            catch (Exception exception) {
                this.logError("Error writing log file " + file.getPath() + ": " + exception.getMessage());
            }
        }
        return false;
    }

    public String srchRplc(int n, String string, String string2, String string3) {
        if (string2.compareTo(string3) != 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            if (n > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            int n3 = string2.length();
            while ((n2 = string.indexOf(string2, n)) != -1) {
                stringBuffer.append(cArray, n, n2 - n);
                stringBuffer.append(string3);
                n = n2 + n3;
            }
            if (n < string.length()) {
                stringBuffer.append(cArray, n, string.length() - n);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private String[] parseBlock(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl2 && Character.isWhitespace(c)) {
                if (bl) {
                    vector.add(stringBuffer.toString());
                }
                bl = false;
                continue;
            }
            if (!bl) {
                stringBuffer = new StringBuffer();
            }
            bl = true;
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            stringBuffer.append(c);
        }
        return vector.toArray(new String[0]);
    }

    private void setEditablePaths(boolean bl) {
        int n;
        this.sourcePath.setEditable(bl);
        this.destPath.setEditable(bl);
        for (n = 0; n < this.modeArray.length; ++n) {
            this.modeArray[n].setEnabled(bl);
        }
        for (n = 0; n < this.optionArray.length; ++n) {
            this.optionArray[n].setEnabled(bl);
        }
        this.browseSourceButton.setEnabled(bl);
        this.browseDestButton.setEnabled(bl);
    }

    private void addButtons() {
        int n;
        this.blPanel.setLayout(new GridLayout(this.modeButtonStrings.length + 1, 1, 0, 0));
        this.brPanel.setLayout(new GridLayout(this.optionButtonStrings.length, 1, 0, 0));
        this.modeArray = new JRadioButton[this.modeButtonStrings.length];
        this.optionArray = new JCheckBox[this.optionButtonStrings.length];
        this.modeGroup = new ButtonGroup();
        for (n = 0; n < this.modeButtonStrings.length; ++n) {
            this.modeArray[n] = new JRadioButton("[" + this.comlineModes[n] + "] " + this.modeButtonStrings[n]);
            this.blPanel.add(this.modeArray[n]);
            this.modeGroup.add(this.modeArray[n]);
        }
        this.modeArray[0].setSelected(true);
        for (n = 0; n < this.optionButtonStrings.length; ++n) {
            this.optionArray[n] = new JCheckBox("[" + this.comlineOptions[n] + "] " + this.optionButtonStrings[n]);
            this.brPanel.add(this.optionArray[n]);
        }
        this.optionArray[0].setSelected(true);
        this.optionArray[4].setSelected(true);
        this.optionArray[5].setSelected(true);
        this.optionArray[8].setSelected(true);
    }

    private boolean setMode(int n) {
        if (n >= 0 && n < this.modeArray.length) {
            this.modeArray[n].setSelected(true);
            return true;
        }
        return false;
    }

    private int getMode() {
        for (int i = 0; i < this.modeArray.length; ++i) {
            if (!this.modeArray[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private synchronized void setStatus(String string) {
        this.statusTextField.setText(string);
    }

    private void getSourcePath() {
        this.getFileSystemPath("source", this.sourcePath);
    }

    private void getDestPath() {
        this.getFileSystemPath("destination", this.destPath);
    }

    private void getFileSystemPath(String string, JTextField jTextField) {
        String string2 = "/";
        String string3 = jTextField.getText().trim();
        if (string3.length() > 0) {
            string2 = string3;
        }
        JFileChooser jFileChooser = new JFileChooser(string2);
        jFileChooser.setDialogTitle("Select path for " + string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select");
        if (n == 0) {
            jTextField.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    private void manualStartScan() {
        this.userInterrupt = false;
        this.logTextArea.setText("");
        this.startScan();
    }

    private void startScan() {
        this.setStatus("Running.");
        String string = this.sourcePath.getText().trim();
        String string2 = this.destPath.getText().trim();
        if (string.length() > 0 && string2.length() > 0) {
            this.setEditablePaths(false);
            this.performScan(string, string2);
        } else {
            this.logError("Error: Stopping scan -- two paths not entered.");
            if (this.comScript) {
                this.userInterrupt = true;
            } else {
                this.showErrorDialog("Must enter two paths.", "Paths not entered");
            }
        }
    }

    private void stopScan() {
        this.userInterrupt = true;
        this.stop = true;
        this.setButtons(this.stop);
        if (this.scanThread != null) {
            try {
                this.scanThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setStatus("Stopped.");
    }

    private void getOptions() {
        this.scanSubs = this.optionArray[0].getSelectedObjects() != null;
        this.strictTime = this.optionArray[1].getSelectedObjects() != null;
        this.updateIfSizeDiffers = this.optionArray[2].getSelectedObjects() != null;
        this.updateIfCompDiffers = this.optionArray[3].getSelectedObjects() != null;
        this.promptBeforeDelete = this.optionArray[4].getSelectedObjects() != null;
        this.copyReadOnly = this.optionArray[5].getSelectedObjects() != null;
        this.detailedLog = this.optionArray[6].getSelectedObjects() != null;
        this.skipNonexistentDests = this.optionArray[7].getSelectedObjects() != null;
        this.visWhileRunning = this.optionArray[8].getSelectedObjects() != null;
    }

    private void performScan(final String string, final String string2) {
        this.mode = this.getMode();
        this.syncModes = this.mode == 4 || this.mode == 5;
        this.srcFiles = 0L;
        this.srcDirs = 0L;
        this.srcBytes = 0L;
        this.destFiles = 0L;
        this.destDirs = 0L;
        this.destBytes = 0L;
        this.movedBytes = 0L;
        this.createdFiles = 0L;
        this.createdDirs = 0L;
        this.totalErrors = 0L;
        this.getOptions();
        String string3 = "Source path:               " + string + "\n";
        string3 = string3 + "Destination path:          " + string2 + "\n";
        string3 = string3 + "Mode:                      " + this.modeButtonStrings[this.mode] + "\n";
        final long l = new Date().getTime();
        string3 = string3 + "Start Time:                " + new Date().toString() + "\n";
        string3 = string3 + this.dashLine(60);
        this.logError(string3);
        this.scanThread = new Thread(){

            public void run() {
                long l2;
                FileProcPanel.this.stop = false;
                FileProcPanel.this.setButtons(FileProcPanel.this.stop);
                File file = new File(string);
                File file2 = new File(string2);
                if (file.equals(file2)) {
                    FileProcPanel.this.logError("Error: Stopping scan -- the selected file paths are the same.");
                    if (FileProcPanel.this.comScript) {
                        FileProcPanel.this.userInterrupt = true;
                    } else {
                        FileProcPanel.this.showErrorDialog("The selected paths are the same.", "Path Error");
                    }
                } else {
                    boolean bl = true;
                    if (!file2.exists()) {
                        if (FileProcPanel.this.skipNonexistentDests) {
                            FileProcPanel.this.logEventOption("Skipping nonexistent destination " + file2.getPath());
                            bl = false;
                        } else if (FileProcPanel.this.mode == 2) {
                            file2.mkdirs();
                        }
                    }
                    if (bl) {
                        if (FileProcPanel.this.syncModes) {
                            if (FileProcPanel.this.mode == 5) {
                                FileProcPanel.this.deleteList = new Vector();
                            } else {
                                FileProcPanel.this.deleteList = null;
                            }
                            FileProcPanel.this.scanDir(file2, file, FileProcPanel.this.scanSubs);
                            if (!FileProcPanel.this.stop && FileProcPanel.this.mode == 5) {
                                FileProcPanel.this.deleteAll(FileProcPanel.this.deleteList);
                            }
                        } else {
                            FileProcPanel.this.scanDir(file, file2, FileProcPanel.this.scanSubs);
                        }
                    }
                }
                if (!FileProcPanel.this.stop) {
                    if (!FileProcPanel.this.userInterrupt) {
                        FileProcPanel.this.setStatus("Ready.");
                    } else {
                        FileProcPanel.this.setStatus("Interrupted.");
                    }
                }
                FileProcPanel.this.stop = true;
                FileProcPanel.this.setButtons(FileProcPanel.this.stop);
                FileProcPanel.this.setEditablePaths(!FileProcPanel.this.comScript);
                String string3 = "";
                if (FileProcPanel.this.detailedLog) {
                    string3 = string3 + FileProcPanel.this.dashLine(60) + "\n";
                }
                if ((l2 = new Date().getTime()) - l > 15000L && !FileProcPanel.this.comScript) {
                    Toolkit.getDefaultToolkit().beep();
                }
                string3 = string3 + "End Time:                  " + new Date().toString() + "\n";
                string3 = string3 + "Files examined:            " + FileProcPanel.this.srcFiles + "\n";
                string3 = string3 + "Files created or modified: " + FileProcPanel.this.createdFiles + "\n";
                string3 = string3 + "Directories created:       " + FileProcPanel.this.createdDirs + "\n";
                string3 = string3 + "Total Errors:              " + FileProcPanel.this.totalErrors + "\n";
                FileProcPanel.this.logError(string3);
                FileProcPanel.this.grandTotalErrors += FileProcPanel.this.totalErrors;
                FileProcPanel.this.isScanning = false;
            }
        };
        this.scanThread.start();
    }

    private void scanDir(File file, File file2, boolean bl) {
        if (!this.stop) {
            if (this.syncModes) {
                this.sourceItem.setText(file2.getPath());
                this.destItem.setText(file.getPath());
            } else {
                this.sourceItem.setText(file.getPath());
                this.destItem.setText(file2.getPath());
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length && !this.stop; ++i) {
                    boolean bl2;
                    File file3 = fileArray[i];
                    File file4 = new File(file2, file3.getName());
                    long l = file3.length();
                    long l2 = file3.lastModified();
                    long l3 = 0L;
                    long l4 = 0L;
                    if (file4.exists()) {
                        l3 = file4.length();
                        l4 = file4.lastModified();
                    }
                    if (bl2 = file3.isDirectory()) {
                        ++this.srcDirs;
                    } else {
                        ++this.srcFiles;
                        this.srcBytes += l;
                    }
                    if (this.mode != 0 && !this.syncModes) {
                        this.execOption(file3, file4, bl2, this.mode, l, l2, l3, l4);
                        file4 = new File(file2, file3.getName());
                        if (file4.exists()) {
                            l3 = file3.length();
                            l4 = file4.lastModified();
                        }
                    }
                    if (file4.exists()) {
                        if (bl2) {
                            ++this.destDirs;
                        } else {
                            ++this.destFiles;
                            this.destBytes += l3;
                            if (!this.syncModes) {
                                long l5 = this.timeComp(l4, l2);
                                if (l3 != l || l5 != 0L) {
                                    String string = bl2 ? "Direc" : "File ";
                                    string = string + " " + file4.getPath() + " differs in";
                                    if (l3 != l) {
                                        string = string + " length: " + (l - l3);
                                    }
                                    if (l5 != 0L) {
                                        string = string + " time: " + this.showTimes(l4, l2);
                                    }
                                    this.logErrorOption(string);
                                }
                            }
                        }
                    } else {
                        String string;
                        String string2 = string = bl2 ? "Direc" : "File ";
                        if (this.syncModes) {
                            if (this.mode == 5) {
                                string = string + " " + file3.getPath() + " marked for deletion.";
                                this.deleteList.add(file3);
                            } else {
                                string = string + " " + file3.getPath() + " would be deleted.";
                            }
                        } else {
                            string = string + " " + file4.getPath() + " not present.";
                        }
                        this.logErrorOption(string);
                    }
                    if (!bl2 || !bl) continue;
                    this.scanDir(file3, file4, bl);
                }
            } else {
                this.logError("Path " + file.getPath() + " doesn't exist");
            }
        }
        this.updateTotals();
    }

    private void execOption(File file, File file2, boolean bl, int n, long l, long l2, long l3, long l4) {
        switch (n) {
            case 1: {
                boolean bl2;
                if (bl || (bl2 = this.compareEntireFiles(file, file2)) || !this.updateIfCompDiffers) break;
                this.copyFile(file, file2);
                break;
            }
            case 2: {
                if (bl) {
                    this.makeDirectory(file2);
                    break;
                }
                if (this.timeComp(l2, l4) <= 0L && (!this.updateIfSizeDiffers || l == l3)) break;
                this.copyFile(file, file2);
                break;
            }
            case 3: {
                if (bl) break;
                this.setModTime(file, file2, file.lastModified());
            }
        }
    }

    private long timeComp(long l, long l2) {
        long l3 = 2000L;
        if (this.strictTime) {
            return l - l2;
        }
        long l4 = l - l2;
        if (l4 > 0L) {
            if ((l4 -= l3) < 0L) {
                l4 = 0L;
            }
        } else if (l4 < 0L && (l4 += l3) > 0L) {
            l4 = 0L;
        }
        return l4;
    }

    private void makeDirectory(File file) {
        if (!file.exists()) {
            file.mkdirs();
            ++this.createdDirs;
            if (this.detailedLog) {
                this.logEventOption("Created Directory " + file.getPath());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean copyFile(File var1_1, File var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setModTime(File file, File file2, long l) {
        if (!this.setModTime(file2, l) && this.copyReadOnly && file.length() == file2.length() && this.copyFile(file, file2)) {
            --this.totalErrors;
        }
    }

    private boolean setModTime(File file, long l) {
        if (this.timeComp(file.lastModified(), l) == 0L) {
            return true;
        }
        boolean bl = file.setLastModified(l);
        if (!bl) {
            this.logErrorOption("Failed to change time on " + file.getPath());
        }
        if (this.detailedLog && bl) {
            this.logEventOption("Changed time on " + file.getPath());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compareEntireFiles(File file, File file2) {
        String string;
        if (file.length() != file2.length()) {
            return false;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        boolean bl = true;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
            byte[] byArray = new byte[32768];
            Object object = new byte[32768];
            long l = 0L;
            while (true) {
                int n;
                if ((n = bufferedInputStream.read(byArray, 0, 32768)) > 0) {
                    int n2 = bufferedInputStream2.read((byte[])object, 0, 32768);
                    if (n != n2) {
                        throw new IOException("Lengths differ: " + file.length() + " != " + file2.length());
                    }
                } else {
                    bufferedInputStream.close();
                    bufferedInputStream2.close();
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        object = "Close Error on " + file.getPath() + ": " + iOException.getMessage();
                        this.logErrorOption((String)object);
                    }
                    try {
                        if (bufferedInputStream2 == null) return bl;
                        bufferedInputStream2.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        object = "Close Error on " + file2.getPath() + ": " + iOException.getMessage();
                        this.logErrorOption((String)object);
                        return bl;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    if (byArray[i] == object[i]) continue;
                    throw new IOException("First compare error at pos " + (l += (long)i));
                }
                l += (long)n;
            }
        }
        catch (Exception exception) {
            string = "Error during compare on " + file.getPath() + ": " + exception.getMessage();
            this.logErrorOption(string);
            bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                string = "Close Error on " + file.getPath() + ": " + iOException.getMessage();
                this.logErrorOption(string);
            }
            try {
                if (bufferedInputStream2 != null) {
                    bufferedInputStream2.close();
                }
            }
            catch (IOException iOException) {
                string = "Close Error on " + file2.getPath() + ": " + iOException.getMessage();
                this.logErrorOption(string);
            }
        }
    }

    private void deleteAll(Vector vector) {
        if (vector != null) {
            File[] fileArray = vector.toArray(new File[0]);
            int n = fileArray.length;
            boolean bl = false;
            for (int i = n - 1; i >= 0 && !this.userInterrupt; --i) {
                boolean bl2;
                boolean bl3 = false;
                if (!bl && this.promptBeforeDelete) {
                    int n2 = this.deletePrompt(fileArray[i]);
                    switch (n2) {
                        case 0: {
                            bl = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            this.userInterrupt = true;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (!bl3) continue;
                File file = fileArray[i];
                long l = 0L;
                boolean bl4 = file.isDirectory();
                if (!bl4) {
                    l = file.length();
                }
                if (bl2 = fileArray[i].delete()) {
                    this.logEventOption("Deleted " + fileArray[i].getPath());
                    --this.totalErrors;
                    if (bl4) {
                        --this.srcDirs;
                    } else {
                        --this.srcFiles;
                        this.srcBytes -= l;
                    }
                    this.updateTotals();
                    continue;
                }
                String string = fileArray[i].canWrite() ? "" : " (read-only)";
                this.logErrorOption("Failed to delete " + fileArray[i].getPath() + string);
            }
        }
    }

    private int deletePrompt(File file) {
        String string = "Okay to delete " + (file.isDirectory() ? "directory" : "file");
        string = string + " " + file.getName();
        string = string + "\nfrom destination?";
        Object[] objectArray = new Object[]{"All", "Yes", "No", "Abort!"};
        int n = JOptionPane.showOptionDialog(this, string, "Confirm Delete", 1, 2, new ImageIcon(this.parent.getIconImage()), objectArray, objectArray[1]);
        return n;
    }

    private void logEventOption(String string) {
        if (this.detailedLog) {
            this.logError(string);
        }
    }

    private void logErrorOption(String string) {
        ++this.totalErrors;
        if (this.detailedLog) {
            this.logError(string);
        }
    }

    private void logError(String string) {
        this.logTextArea.append(string + "\n");
    }

    private void updateTotals() {
        this.numDisp[0].setField(this.srcFiles);
        this.numDisp[1].setField(this.destFiles);
        this.numDisp[2].setField(this.srcFiles - this.destFiles);
        this.numDisp[3].setField(this.srcDirs);
        this.numDisp[4].setField(this.destDirs);
        this.numDisp[5].setField(this.srcDirs - this.destDirs);
        this.numDisp[6].setField(this.srcBytes);
        this.numDisp[7].setField(this.destBytes);
        this.numDisp[8].setField(this.srcBytes - this.destBytes);
    }

    private void setButtons(boolean bl) {
        this.goButton.setEnabled(bl);
        this.stopButton.setEnabled(!bl);
    }

    private String dashLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    private String showTimes(long l, long l2) {
        return "(dest) " + new Date(l).toString() + " vs. (source) " + new Date(l2).toString();
    }

    private void showErrorDialog(String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(this.parent, string, string2, 2);
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.statusTextField = new JTextField();
        this.tabPane = new JTabbedPane();
        this.contentPanel = new JPanel();
        this.topPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.sourcePath = new JTextField();
        this.jLabel2 = new JLabel();
        this.destPath = new JTextField();
        this.jLabel3 = new JLabel();
        this.sourceItem = new JTextField();
        this.jLabel4 = new JLabel();
        this.destItem = new JTextField();
        this.browseSourceButton = new JButton();
        this.browseDestButton = new JButton();
        this.goButton = new JButton();
        this.stopButton = new JButton();
        this.middlePanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jTextField5 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextField7 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jTextField9 = new JTextField();
        this.behaviorsPanel = new JPanel();
        this.blPanel = new JPanel();
        this.brPanel = new JPanel();
        this.logPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.logTextArea = new JTextArea();
        this.helpPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.helpTextArea = new JTextArea();
        this.setLayout(new BorderLayout());
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusTextField.setEditable(false);
        this.statusTextField.setText("Status");
        this.statusTextField.setDoubleBuffered(true);
        this.statusTextField.setMargin(new Insets(0, 4, 0, 4));
        this.statusTextField.setMinimumSize(new Dimension(0, 27));
        this.statusTextField.setPreferredSize(new Dimension(0, 27));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.statusPanel.add((Component)this.statusTextField, gridBagConstraints);
        this.add((Component)this.statusPanel, "South");
        this.tabPane.setTabPlacement(3);
        this.contentPanel.setLayout(new GridBagLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder("Path/Control"));
        this.topPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Source start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.sourcePath, gridBagConstraints);
        this.jLabel2.setText("Dest. start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.destPath, gridBagConstraints);
        this.jLabel3.setText("Source now");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.sourceItem.setEditable(false);
        this.sourceItem.setDoubleBuffered(true);
        this.sourceItem.setMargin(new Insets(0, 4, 0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.sourceItem, gridBagConstraints);
        this.jLabel4.setText("Dest. now");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.destItem.setEditable(false);
        this.destItem.setDoubleBuffered(true);
        this.destItem.setMargin(new Insets(0, 4, 0, 4));
        this.destItem.setPreferredSize(new Dimension(400, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.destItem, gridBagConstraints);
        this.browseSourceButton.setText("Browse");
        this.browseSourceButton.setRequestFocusEnabled(false);
        this.browseSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProcPanel.this.browseSourceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.browseSourceButton, gridBagConstraints);
        this.browseDestButton.setText("Browse");
        this.browseDestButton.setRequestFocusEnabled(false);
        this.browseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProcPanel.this.browseDestButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.browseDestButton, gridBagConstraints);
        this.goButton.setText("Start");
        this.goButton.setRequestFocusEnabled(false);
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProcPanel.this.goButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.goButton, gridBagConstraints);
        this.stopButton.setText("Stop");
        this.stopButton.setRequestFocusEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProcPanel.this.stopButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.stopButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.topPanel, gridBagConstraints);
        this.middlePanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.middlePanel.setLayout(new GridBagLayout());
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Destination");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Difference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField3, gridBagConstraints);
        this.jLabel9.setText("Directories");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField6, gridBagConstraints);
        this.jLabel10.setText("Bytes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.middlePanel.add((Component)this.jTextField9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.middlePanel, gridBagConstraints);
        this.tabPane.addTab("contentPanel", null, this.contentPanel, "");
        this.behaviorsPanel.setBorder(BorderFactory.createTitledBorder("Behaviors"));
        this.behaviorsPanel.setLayout(new BorderLayout());
        this.blPanel.setLayout(new BorderLayout());
        this.behaviorsPanel.add((Component)this.blPanel, "West");
        this.brPanel.setLayout(new BorderLayout());
        this.behaviorsPanel.add((Component)this.brPanel, "East");
        this.tabPane.addTab("bottomPanel", null, this.behaviorsPanel, "");
        this.logPanel.setLayout(new BorderLayout());
        this.logTextArea.setEditable(false);
        this.logTextArea.setDoubleBuffered(true);
        this.logTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.logTextArea);
        this.logPanel.add((Component)this.jScrollPane1, "Center");
        this.tabPane.addTab("jPanel3", null, this.logPanel, "");
        this.helpPanel.setPreferredSize(new Dimension(400, 300));
        this.helpPanel.setLayout(new BorderLayout());
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setWrapStyleWord(true);
        this.helpTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane2.setViewportView(this.helpTextArea);
        this.helpPanel.add((Component)this.jScrollPane2, "Center");
        this.tabPane.addTab("jPanel1", null, this.helpPanel, "");
        this.add((Component)this.tabPane, "Center");
    }

    private void goButtonActionPerformed(ActionEvent actionEvent) {
        this.manualStartScan();
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        this.stopScan();
    }

    private void browseDestButtonActionPerformed(ActionEvent actionEvent) {
        this.getDestPath();
    }

    private void browseSourceButtonActionPerformed(ActionEvent actionEvent) {
        this.getSourcePath();
    }
}

