/*
 * Decompiled with CFR 0.152.
 */
package polysolve;

import java.util.ArrayList;
import polysolve.Pair;

public class GJ {
    private GJ() {
    }

    private static void divide(double[][] A, int i, int j, int m) {
        int q = j + 1;
        while (q < m) {
            double[] dArray = A[i];
            int n = q++;
            dArray[n] = dArray[n] / A[i][j];
        }
        A[i][j] = 1.0;
    }

    private static void eliminate(double[][] A, int i, int j, int n, int m) {
        for (int k = 0; k < n; ++k) {
            if (k == i || A[k][j] == 0.0) continue;
            for (int q = j + 1; q < m; ++q) {
                double[] dArray = A[k];
                int n2 = q;
                dArray[n2] = dArray[n2] - A[k][j] * A[i][q];
            }
            A[k][j] = 0.0;
        }
    }

    private static void echelonize(double[][] A) {
        int n = A.length;
        int m = A[0].length;
        int i = 0;
        for (int j = 0; i < n && j < m; ++j) {
            int k;
            for (k = i; k < n && A[k][j] == 0.0; ++k) {
            }
            if (k >= n) continue;
            if (k != i) {
                double[] swap = A[i];
                A[i] = A[k];
                A[k] = swap;
            }
            if (A[i][j] != 1.0) {
                GJ.divide(A, i, j, m);
            }
            GJ.eliminate(A, i, j, n, m);
            ++i;
        }
    }

    static ArrayList<Double> compute_coefficients(ArrayList<Pair> data, int p) {
        int r;
        int n = data.size();
        int rs = 2 * ++p - 1;
        double[][] m = new double[p][p + 1];
        double[] mpc = new double[rs];
        mpc[0] = n;
        for (Pair pr : data) {
            double x = pr.x;
            r = 1;
            while (r < rs) {
                int n2 = r++;
                mpc[n2] = mpc[n2] + x;
                x *= pr.x;
            }
            double[] dArray = m[0];
            int n3 = p;
            dArray[n3] = dArray[n3] + pr.y;
            x = pr.x;
            for (r = 1; r < p; ++r) {
                double[] dArray2 = m[r];
                int n4 = p;
                dArray2[n4] = dArray2[n4] + x * pr.y;
                x *= pr.x;
            }
        }
        for (r = 0; r < p; ++r) {
            for (int c = 0; c < p; ++c) {
                m[r][c] = mpc[r + c];
            }
        }
        GJ.echelonize(m);
        ArrayList<Double> terms = new ArrayList<Double>();
        boolean j = false;
        for (double[] mc : m) {
            terms.add(mc[p]);
        }
        return terms;
    }
}

