/*
 * Decompiled with CFR 0.152.
 */
package polysolve;

import java.util.ArrayList;
import polysolve.Pair;

public final class MatrixFunctions {
    private MatrixFunctions() {
    }

    static double regress(double x, ArrayList<Double> terms) {
        double a = 0.0;
        double t = 1.0;
        for (double term : terms) {
            a += term * t;
            t *= x;
        }
        return a;
    }

    static double corr_coeff(ArrayList<Pair> data, ArrayList<Double> terms) {
        double r = 0.0;
        int n = data.size();
        double sx = 0.0;
        double sx2 = 0.0;
        double sy = 0.0;
        double sy2 = 0.0;
        double sxy = 0.0;
        for (Pair pr : data) {
            double x = MatrixFunctions.regress(pr.x, terms);
            double y = pr.y;
            sx += x;
            sy += y;
            sxy += x * y;
            sx2 += x * x;
            sy2 += y * y;
        }
        double div = Math.sqrt((sx2 - sx * sx / (double)n) * (sy2 - sy * sy / (double)n));
        if (div != 0.0) {
            r = Math.pow((sxy - sx * sy / (double)n) / div, 2.0);
        }
        return r;
    }

    static double std_error(ArrayList<Pair> data, ArrayList<Double> terms) {
        double r = 0.0;
        int n = data.size();
        if (n > 2) {
            double a = 0.0;
            for (Pair pr : data) {
                a += Math.pow(MatrixFunctions.regress(pr.x, terms) - pr.y, 2.0);
            }
            r = Math.sqrt(a / (double)(n - 2));
        }
        return r;
    }
}

