/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef GRAVITY_H
#define GRAVITY_H
#include <cstdlib>
#include <iostream>

#include <gtk/gtk.h>
#include <glib.h>
#include <glade/glade.h>

#include <libglademm/xml.h>
#include <gtkmm.h>

#include "Pattern.h"
#include "Matcher.h"
#include "cart3.h"
#include <string>

#include "rotationmatrix.h"
#include "planet.h"
#include "solarsystem.h"
#include "orbitalphysics.h"


using namespace std;

void* perform_thread ( void *args );

class Gravity : public Gtk::Window
{

	public:
		Gravity ( BaseObjectType* cobject,
		          const Glib::RefPtr<Gnome::Glade::Xml>& glade_xml );
		~Gravity();

		static const double  ToRad = M_PI / 180.0;
		static const double  ToDeg = 180.0 / M_PI;

		Gdk::Color planet_colors[8];
		static const string anim_strings[];
		static const string comet_strings[];

		static const string version;

		//QTimer *timer;
		//QPixmap *qpm;
		int oldXSize,oldYSize;
		int min_draw_radius;
		int anim_time;
		int frame_counter;
		unsigned long total_time_hours;
		double rotx,roty;
		double time_step;
		double drawing_scale;
		double screen_scale;
		double x_screen_center,y_screen_center;
		double mouse_press_rx;
		double mouse_press_ry;
		double mouse_press_x;
		double mouse_press_y;
		bool anaglyph_mode;
		bool sun_only;
		bool erase_option;
		bool symmetric;
		bool nice;
		bool thread_active;
		bool mouse_down;

		RotationMatrix *rotator;
		vector<Planet *> planet_list;
		Gtk::Button *gui_quit_button;
		Gtk::Button *gui_step_button;
		Gtk::Button *gui_run_stop_button;
		Gtk::CheckButton *gui_solar_system_checkbutton;
		Gtk::CheckButton *gui_comets_checkbutton;
		Gtk::CheckButton *gui_anaglyphic_checkbutton;
		Gtk::CheckButton *gui_trails_checkbutton;
		Gtk::CheckButton *gui_nice_checkbutton;
		Gtk::ComboBox *gui_time_step_combobox;
		Gtk::ComboBox *gui_comet_combobox;
		Gtk::SpinButton *gui_pixels_spinbutton;
		Gtk::Label *gui_status_bar;
		Gtk::Image *gui_graphic_pane;
		Gtk::EventBox *gui_event_box;
		void setup_controls ( Glib::RefPtr<Gnome::Glade::Xml> refXml );
		void close();
		void load_combobox ( Gtk::ComboBox *cb, const string* array,int n );

	class ModelColumns : public Gtk::TreeModel::ColumnRecord
		{
			public:

				ModelColumns()
				{ add ( m_col_name ); }
				Gtk::TreeModelColumn<Glib::ustring> m_col_name;
		};

		ModelColumns m_Columns;

		string get_combobox_selection ( Gtk::ComboBox *cb );


		void step_button_clicked();
		void run_stop_button_clicked();

		void solar_system_checkbutton_toggled();
		void comets_checkbutton_toggled();
		void anaglyphic_checkbutton_toggled();
		void time_step_combobox_changed();
		void comets_combobox_changed();
		void pixels_spinbutton_changed();
		void trails_checkbutton_toggled();
		void nice_checkbutton_toggled();

		bool mouse_move_event ( GdkEventMotion* event );
		bool mouse_press_event ( GdkEventButton* event );
		bool mouse_release_event ( GdkEventButton* e );
		bool wheel_event ( GdkEventScroll* event );
		bool expose_event ( GdkEventExpose* e );

		void draw_image ( bool erase = true );
		void set_time_step();
		void load_orbital_data ( string data,bool sun_only = false );
		void load_objects();
		void toggle_animation();
		void erase_planet_list();


		//void closeEvent( QCloseEvent* );
		void draw_planets ( int xsize,int ysize,Glib::RefPtr<Gdk::GC>& gc,Glib::RefPtr<Gdk::Pixmap>& pm,Gdk::Color td_color,int anaglyph_flag = 0 );
		Glib::RefPtr<Gdk::Pixmap> pixmap;
		Gdk::Color color_red;
		Gdk::Color color_cyan;
		Gdk::Color color_white;
		Gdk::Color color_black;
		Gdk::Color create_color ( int r, int g, int b );
		void load_comets();
		void show_status();

		void perform_orbit_calc();

};


#endif
