/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ROTATIONMATRIX_H
#define ROTATIONMATRIX_H

#include "cart3.h"
#include <cmath>

/**
	@author Paul Lutus <lutusp@pl-alpha>
*/
class RotationMatrix
{
public:
  RotationMatrix();

  ~RotationMatrix();
  void populate_matrix(double xa, double ya);
  void convert_3d_to_2d(Cart3& v,int anaglyph_flag = 0);
  void rotate(Cart3& v);

  double sx,cx,sy,cy;
  double oxa,oya;
  static const double PerspectiveDepth = 16;
  static const double AnaglyphScale = 0.03;

};

#endif
