/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class SatFinder
extends JFrame {
    static final String VERSION = "5.5";
    static final int programBuild = 1422;
    static final String requiredJavaVersion = "1.7.0";
    public static final String programName = "SatFinder";
    public static String copyright = "Satellite Finder is &copy; Copyright 2016, P. Lutus";
    public static final String zipDir = "ZipCodeData";
    public static final String zipFileName = "zip_database.txt";
    public static final String satListFileName = "satlist.txt";
    static final String programTitle = "SatFinder 5.5";
    public String userDir;
    public String userPath;
    public String configPath;
    public String zipPath;
    String fileSep;
    String lineSep;
    private ProgramValues programValues;
    LocationHandler locationHandler;
    MagneticDeclination magDec;
    ZipRecord currentPosition = null;
    boolean propagate = true;
    private JComboBox cityComboBox;
    protected JButton copyButton;
    private JTextField declTextField;
    private JRadioButton eastRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JTabbedPane jTabbedPane1;
    private ButtonGroup latButtonGroup;
    private JTextField latTextField;
    private JPanel leftPanel;
    private ButtonGroup lngButtonGroup;
    private JTextField lngTextField;
    private JRadioButton northRadioButton;
    private JProgressBar progressBar;
    private JButton quitButton;
    private JPanel rightPanel;
    private JRadioButton southRadioButton;
    private JComboBox stateComboBox;
    private JRadioButton westRadioButton;
    private JTextField zipTextField;

    public SatFinder() {
        this.testJavaVersion();
        this.setDefaultCloseOperation(0);
        this.setTitle("Satellite Finder 5.5");
        URL url = this.getClass().getResource("SatFinder.png");
        Image appIcon = new ImageIcon(url).getImage();
        this.setIconImage(appIcon);
        this.userDir = System.getProperty("user.home");
        this.fileSep = System.getProperty("file.separator");
        this.lineSep = System.getProperty("line.separator");
        this.userPath = this.userDir + this.fileSep + "." + programName;
        File f = new File(this.userPath);
        f.mkdirs();
        this.configPath = this.userPath + this.fileSep + programName + ".ini";
        this.programValues = new ProgramValues();
        this.programValues.readValues(this.configPath);
        this.zipPath = this.userPath + this.fileSep + zipDir;
        this.locationHandler = new LocationHandler(this);
        this.magDec = new MagneticDeclination();
        this.initComponents();
        this.jTabbedPane1.addTab("Help", new SatFinderHelp(this));
        this.showProgressBar(false);
        this.pack();
        this.setSize(this.programValues.db_ProgWindowSize);
        this.setLocation(this.programValues.db_ProgWindowLocation);
        this.setExtendedState(this.programValues.db_ProgWindowState);
        this.setVisible(true);
        f = new File(this.zipPath);
        if (!f.exists()) {
            this.locationHandler.buildDataFiles();
        } else {
            this.setup();
        }
    }

    public void setup() {
        this.stateComboBox.setModel(new DefaultComboBoxModel<String>(this.locationHandler.getStateKeys()));
        if (this.programValues.db_directPosEntryMode) {
            this.setPositionFromComplex(new Complex(this.programValues.db_posLng, this.programValues.db_posLat));
        } else {
            this.loadPositionFromZipCode(this.programValues.db_zip);
        }
    }

    private void loadState(boolean resetCity) {
        this.programValues.db_directPosEntryMode = false;
        String key = (String)this.stateComboBox.getSelectedItem();
        this.cityComboBox.setModel(new DefaultComboBoxModel<String>(this.locationHandler.getCityNames(key)));
        this.cityComboBox.setSelectedIndex(0);
        this.loadPositionFromCity();
    }

    private void loadPositionFromCity() {
        if (this.propagate) {
            this.programValues.db_directPosEntryMode = false;
            String key = (String)this.cityComboBox.getSelectedItem();
            String state = (String)this.stateComboBox.getSelectedItem();
            ZipRecord zr = this.locationHandler.getZipRecordFromCity(state, key);
            this.zipTextField.setText(zr.zip);
            this.setPositionFromZipRecord(zr);
        }
    }

    private void loadPositionFromZipCodeEntry(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.programValues.db_directPosEntryMode = false;
            String zip = this.zipTextField.getText();
            this.loadPositionFromZipCode(zip);
        }
    }

    private void loadPositionFromZipCode(String zip) {
        if (zip.length() > 0) {
            this.zipTextField.setText(zip);
            ZipRecord zr = this.locationHandler.getZipRecordFromZip(zip);
            if (zr == null) {
                JOptionPane.showMessageDialog(this, "Please enter a valid ZIP code.", "Invalid ZIP Code entry: " + zip, 2);
            } else {
                this.propagate = false;
                this.stateComboBox.setSelectedItem(zr.state);
                this.cityComboBox.setSelectedItem(zr.city);
                this.propagate = true;
                this.setPositionFromZipRecord(zr);
            }
        }
    }

    private void setPositionFromZipRecord(ZipRecord zr) {
        this.currentPosition = zr;
        this.setPositionFromDoubles(zr.lat, zr.lng);
        ((SatList)this.rightPanel).computePositions();
    }

    private void setPositionFromComplex(Complex pos) {
        this.setPositionFromDoubles(pos.y(), pos.x());
        ((SatList)this.rightPanel).computePositions();
    }

    private void setPositionFromDoubles(double lat, double lng) {
        this.latTextField.setText(this.formatDegMin(lat));
        this.northRadioButton.setSelected(lat >= 0.0);
        this.southRadioButton.setSelected(lat < 0.0);
        this.lngTextField.setText(this.formatDegMin(lng));
        this.eastRadioButton.setSelected(lng >= 0.0);
        this.westRadioButton.setSelected(lng < 0.0);
        this.updateMagDecField(lat, lng);
    }

    public String formatDegMin(double a) {
        a = Math.abs(a);
        DecimalFormat df = new DecimalFormat("0.000");
        int deg = (int)a;
        double min = (a - (double)deg) * 60.0;
        return deg + "\u00b0 " + df.format(min) + "'";
    }

    public Complex getPositionFromForm() {
        Complex result = null;
        String sla = this.latTextField.getText();
        String sln = this.lngTextField.getText();
        if (sla.length() > 0 && sln.length() > 0) {
            double x = this.readDegMin(sln);
            double y = this.readDegMin(sla);
            if (this.westRadioButton.isSelected()) {
                x = -x;
            }
            if (this.southRadioButton.isSelected()) {
                y = -y;
            }
            result = new Complex(x, y);
            this.updateMagDecField(result.y(), result.x());
            this.setPositionFromDoubles(result.y(), result.x());
        }
        return result;
    }

    private double readDegMin(String s) {
        s = s.replaceAll("[^\\d|\\.]", " ");
        String[] array = s.split("\\s+");
        double d = 0.0;
        if (array.length > 0) {
            d = Double.parseDouble(array[0]);
            if (array.length > 1) {
                d += Double.parseDouble(array[1]) / 60.0;
            }
        }
        return Math.abs(d);
    }

    private String letterSigned(double v, String neg, String pos) {
        return this.formatDegMin(v) + (v < 0.0 ? neg : pos);
    }

    private void updateMagDecField(double lat, double lng) {
        DecimalFormat df = new DecimalFormat("#.00");
        double magDecl = this.magDec.computePoint(lat, lng);
        this.declTextField.setText(df.format(magDecl));
    }

    private void readDirectPosEntry(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.readDirectPosEntry();
        }
    }

    private void readDirectPosEntry() {
        this.programValues.db_directPosEntryMode = true;
        ((SatList)this.rightPanel).computePositions();
    }

    private void testJavaVersion() {
        boolean accept;
        String vs = System.getProperty("java.version");
        boolean bl = accept = this.convertVersionString(vs) >= this.convertVersionString(requiredJavaVersion);
        if (!accept) {
            JOptionPane.showMessageDialog(this, "Very Sorry!\n\nSatFinder 5.5 requires a Java runtime engine (JRE)\nwith a version of 1.7.0 or better.\nThis machine has a version " + vs + " JRE.\nPlease acquire the correct JRE at http://java.com.", "Wrong Java Runtime Version", 2);
            System.exit(0);
        }
    }

    private int convertVersionString(String version) {
        try {
            int q;
            int i;
            int len = version.length();
            for (i = 0; i < len && !Character.isDigit(version.charAt(i)); ++i) {
            }
            StringBuffer sb = new StringBuffer();
            char c = ' ';
            while (true) {
                block10: {
                    block9: {
                        if (i >= len) break block9;
                        char c2 = version.charAt(i);
                        c = c2;
                        if (Character.isDigit(c2)) break block10;
                    }
                    if (c != 46) break;
                }
                if (Character.isDigit(c)) {
                    sb.append(c);
                }
                ++i;
            }
            for (q = Integer.parseInt(sb.toString()); q > 0 && q < 100; q *= 10) {
            }
            return q;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String currentLocation(boolean html) {
        String lineBreak;
        String result = "";
        String string = lineBreak = html ? "<br/>" : "\n";
        if (!this.programValues.db_directPosEntryMode) {
            result = "Location: " + (String)this.cityComboBox.getSelectedItem() + ", " + this.currentPosition.county + ", " + (String)this.stateComboBox.getSelectedItem() + " " + this.zipTextField.getText() + lineBreak;
        }
        Complex pos = this.getPositionFromForm();
        result = result + "Latitude " + this.letterSigned(pos.y(), "S", "N") + ", Longitude " + this.letterSigned(pos.x(), "W", "E");
        return result + lineBreak;
    }

    private void toClipboard() {
        ((SatList)this.rightPanel).toClipboard();
    }

    public void updateProgressBar(String prompt, int min, int max, int pos) {
        int v = 0;
        if (max - min > 0) {
            v = 100 * (pos - min) / (max - min);
        }
        this.progressBar.setString(prompt + " " + v + "%");
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(pos);
    }

    public void showProgressBar(boolean show) {
        this.progressBar.setVisible(show);
    }

    private void exitProgram() {
        this.programValues.db_zip = this.zipTextField.getText();
        Complex pos = this.getPositionFromForm();
        this.programValues.db_posLat = pos.y();
        this.programValues.db_posLng = pos.x();
        this.programValues.db_ProgWindowSize = this.getSize();
        this.programValues.db_ProgWindowLocation = this.getLocation();
        this.programValues.db_ProgWindowState = this.getExtendedState();
        this.programValues.writeValues(this.configPath);
        System.exit(0);
    }

    private void initComponents() {
        this.latButtonGroup = new ButtonGroup();
        this.lngButtonGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.leftPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.stateComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cityComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.zipTextField = new JTextField();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.latTextField = new JTextField();
        this.northRadioButton = new JRadioButton();
        this.southRadioButton = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.lngTextField = new JTextField();
        this.westRadioButton = new JRadioButton();
        this.eastRadioButton = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.declTextField = new JTextField();
        this.jPanel6 = new JPanel();
        this.copyButton = new JButton();
        this.quitButton = new JButton();
        this.rightPanel = new SatList(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SatFinder.this.exitForm(evt);
            }
        });
        this.jPanel2.setLayout(new BorderLayout());
        this.progressBar.setStringPainted(true);
        this.jPanel2.add((Component)this.progressBar, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel1.setLayout(new GridBagLayout());
        this.leftPanel.setBorder(BorderFactory.createTitledBorder("Choose a location:"));
        this.leftPanel.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("By selecting a state and city:"));
        this.jPanel3.setToolTipText("First select a state, then a city");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("State:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.stateComboBox.setToolTipText("Click the arrow at the right to open this list");
        this.stateComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SatFinder.this.stateComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.stateComboBox, gridBagConstraints);
        this.jLabel2.setText("City:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.cityComboBox.setToolTipText("Click the arrow at the right to open this list");
        this.cityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SatFinder.this.cityComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.cityComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Or by entering a ZIP code:"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setText("ZIP Code:");
        this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints());
        this.zipTextField.setToolTipText("Press the \"Enter\" key to accept your change");
        this.zipTextField.setMinimumSize(new Dimension(4, 24));
        this.zipTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SatFinder.this.zipTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.zipTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Or by entering a geographic position:"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel4.setText("Latitude:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.jLabel4, gridBagConstraints);
        this.latTextField.setColumns(18);
        this.latTextField.setFont(new Font("Monospaced", 0, 12));
        this.latTextField.setToolTipText("<html>Enter format: ddd.ddd [mm.mmm]<br>Press the \"Enter\" key to accept your entry</html>");
        this.latTextField.setMinimumSize(new Dimension(112, 24));
        this.latTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SatFinder.this.latTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.latTextField, gridBagConstraints);
        this.latButtonGroup.add(this.northRadioButton);
        this.northRadioButton.setText("North");
        this.northRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SatFinder.this.northRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.northRadioButton, gridBagConstraints);
        this.latButtonGroup.add(this.southRadioButton);
        this.southRadioButton.setText("South");
        this.southRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SatFinder.this.southRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.southRadioButton, gridBagConstraints);
        this.jLabel5.setText("Longitude:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.jLabel5, gridBagConstraints);
        this.lngTextField.setColumns(18);
        this.lngTextField.setFont(new Font("Monospaced", 0, 12));
        this.lngTextField.setToolTipText("<html>Enter format: ddd.ddd [mm.mmm]<br>Press the \"Enter\" key to accept your entry</html>");
        this.lngTextField.setMinimumSize(new Dimension(112, 24));
        this.lngTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SatFinder.this.lngTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.lngTextField, gridBagConstraints);
        this.lngButtonGroup.add(this.westRadioButton);
        this.westRadioButton.setText("West");
        this.westRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SatFinder.this.westRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.westRadioButton, gridBagConstraints);
        this.lngButtonGroup.add(this.eastRadioButton);
        this.eastRadioButton.setText("East");
        this.eastRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SatFinder.this.eastRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.eastRadioButton, gridBagConstraints);
        this.jLabel6.setText("Mag. Decl.:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.jLabel6, gridBagConstraints);
        this.declTextField.setBackground(SystemColor.control);
        this.declTextField.setColumns(12);
        this.declTextField.setEditable(false);
        this.declTextField.setFont(new Font("Monospaced", 0, 12));
        this.declTextField.setMinimumSize(new Dimension(70, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.declTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.leftPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.copyButton.setText("Copy to Clipboard");
        this.copyButton.setToolTipText("Copy data table to system clipbooard");
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SatFinder.this.copyButtonMouseClicked(evt);
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SatFinder.this.copyButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.copyButton);
        this.quitButton.setText("Exit");
        this.quitButton.setToolTipText("Quit Satellite Finder");
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SatFinder.this.quitButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.quitButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.leftPanel.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.leftPanel, gridBagConstraints);
        this.rightPanel.setBorder(BorderFactory.createTitledBorder("Satellite position data"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.rightPanel, gridBagConstraints);
        this.jTabbedPane1.addTab("Program", this.jPanel1);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void quitButtonActionPerformed(ActionEvent evt) {
        this.exitProgram();
    }

    private void eastRadioButtonMouseClicked(MouseEvent evt) {
        this.readDirectPosEntry();
    }

    private void westRadioButtonMouseClicked(MouseEvent evt) {
        this.readDirectPosEntry();
    }

    private void southRadioButtonMouseClicked(MouseEvent evt) {
        this.readDirectPosEntry();
    }

    private void northRadioButtonMouseClicked(MouseEvent evt) {
        this.readDirectPosEntry();
    }

    private void lngTextFieldKeyPressed(KeyEvent evt) {
        this.readDirectPosEntry(evt);
    }

    private void latTextFieldKeyPressed(KeyEvent evt) {
        this.readDirectPosEntry(evt);
    }

    private void zipTextFieldKeyTyped(KeyEvent evt) {
        this.loadPositionFromZipCodeEntry(evt);
    }

    private void cityComboBoxItemStateChanged(ItemEvent evt) {
        this.loadPositionFromCity();
    }

    private void stateComboBoxItemStateChanged(ItemEvent evt) {
        this.loadState(false);
    }

    private void exitForm(WindowEvent evt) {
        this.exitProgram();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
    }

    private void copyButtonMouseClicked(MouseEvent evt) {
        this.toClipboard();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.setProperty("awt.useSystemAAFontSettings", "on");
                System.setProperty("swing.aatext", "true");
                new SatFinder().setVisible(true);
            }
        });
    }
}

