/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class SatList
extends JPanel {
    SatFinder parent;
    String dataPath;
    String[] fieldNames = new String[]{"Name", "Longitude", "Azimuth True", "Azimuth Mag.", "Elevation", "Skew:0", "Skew:90"};
    ArrayList<String> sat_data;
    String css = "<style type=\"text/css\">td { text-align:right;} .odd {background:#f8f8f8} .even{background:#f0f0f0} .head {background:#e0ffe0;color:blue} table {width:100%; background-color:black; border-right:1px solid black; border-bottom:1px solid black; } td {border-left:1px solid gray; border-top: 1px solid gray; padding:2px;} </style>";
    final double toDeg = 57.29577951308232;
    final double toRad = Math.PI / 180;
    int fields = this.fieldNames.length;
    DecimalFormat df = new DecimalFormat("#0.0");
    Complex oldPos;
    StringBuilder tsvBuffer = null;
    private JMenuItem copyMenuItem;
    private JScrollPane jScrollPane1;
    private JPopupMenu popupMenu;
    protected JLabel satDisplay;

    public SatList(SatFinder p) {
        this.parent = p;
        this.initComponents();
        this.sat_data = new ArrayList();
        this.dataPath = this.parent.userPath + "/satlist.txt";
    }

    public void readFile() {
        try {
            this.unpackDataFile();
            File f = new File(this.dataPath);
            if (f.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    this.sat_data.add(line);
                }
                br.close();
            } else {
                System.out.println("compute read fail");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void computePositions() {
        if (this.sat_data.size() < 10) {
            this.readFile();
            this.oldPos = null;
        }
        Complex pos = this.parent.getPositionFromForm();
        if (this.oldPos != null && pos.x() == this.oldPos.x() && pos.y() == this.oldPos.y()) {
            return;
        }
        this.oldPos = pos;
        this.satDisplay.setBackground(Color.white);
        this.satDisplay.setOpaque(true);
        this.satDisplay.setHorizontalAlignment(0);
        this.satDisplay.setText("<html><center><br/><b>One moment, please ...</b></center></html>");
        double decl = this.parent.magDec.computePoint(pos.y(), pos.x());
        ArrayList<String[]> v = new ArrayList<String[]>();
        String tableTag = "<center><table cellspacing='0' border='0'>";
        boolean inTable = false;
        int[] tabs = new int[this.fields];
        String[] header = this.fieldNames;
        try {
            for (String line : this.sat_data) {
                this.processLine(line, tabs, v, pos, decl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder pageBuffer = new StringBuilder();
        this.tsvBuffer = new StringBuilder();
        this.tsvBuffer.append(this.parent.currentLocation(false));
        int line = 0;
        for (int i = 0; i < v.size(); ++i) {
            String[] array = v.get(i);
            if (array[0].matches(".*\\*\\*\\*.*")) {
                if (inTable) {
                    pageBuffer.append("</table></center>");
                }
                line = 0;
                String title = array[0].replaceFirst("[\\W]*", "");
                this.tsvBuffer.append("*** " + title + "\n");
                pageBuffer.append("<br/><center><b>" + title + "</b></center>");
                pageBuffer.append(tableTag);
                inTable = true;
                this.formatRecord(line, '\t', pageBuffer, this.tsvBuffer, header, tabs, true);
            } else if (array.length > 2) {
                this.formatRecord(line, '\t', pageBuffer, this.tsvBuffer, array, tabs, false);
            }
            ++line;
        }
        if (inTable) {
            pageBuffer.append("</table>");
        }
        final StringBuilder output = new StringBuilder("<html>");
        output.append(this.css);
        output.append("<center>" + this.parent.currentLocation(true) + "</center>");
        output.append((CharSequence)pageBuffer);
        output.append("<br/>");
        output.append("<center>" + SatFinder.copyright + "</center>");
        output.append("</html>");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SatList.this.satDisplay.setText(output.toString());
            }
        });
    }

    private void formatRecord(int line, char delim, StringBuilder pageBuffer, StringBuilder csvBuffer, String[] array, int[] tabs, boolean head) {
        if (head) {
            pageBuffer.append("<tr class=\"head\">");
        } else if (line % 2 == 0) {
            pageBuffer.append("<tr class=\"odd\">");
        } else {
            pageBuffer.append("<tr class=\"even\">");
        }
        StringBuilder record = new StringBuilder();
        for (int i = 0; i < array.length && array[i] != null; ++i) {
            StringBuilder lb = new StringBuilder();
            if (i == 0) {
                lb.append("<td width=\"140\">");
            } else {
                lb.append("<td>");
                record.append(delim);
            }
            lb.append(array[i]);
            record.append(array[i]);
            lb.append("</td>");
            pageBuffer.append(lb.toString());
        }
        csvBuffer.append(record.toString() + "\n");
        pageBuffer.append("</tr>");
    }

    private void processLine(String line, int[] tabs, ArrayList<String[]> v, Complex pos, double decl) {
        if ((line = line.trim()).length() > 0) {
            String[] array = line.split(",");
            String[] record = new String[this.fields];
            if (array.length > 1) {
                this.updateRecord(record, 0, array[0]);
                double satLng = Double.parseDouble(array[1]);
                this.updateRecord(record, 1, this.letterSigned(satLng, " W", " E"));
                Complex spos = this.computePos(pos.y(), pos.x(), satLng);
                this.updateRecord(record, 2, this.df.format(spos.x()));
                double dd = (spos.x() - decl + 720.0) % 360.0;
                this.updateRecord(record, 3, this.df.format(dd));
                this.updateRecord(record, 4, this.df.format(spos.y()));
                double skew = this.computeSkew(pos.y(), pos.x(), satLng);
                this.updateRecord(record, 5, this.df.format(skew));
                this.updateRecord(record, 6, this.df.format(skew + 90.0));
            } else {
                record[0] = array[0];
            }
            v.add(record);
        }
    }

    private String letterSigned(double v, String neg, String pos) {
        return this.df.format(Math.abs(v)) + (v < 0.0 ? neg : pos);
    }

    private void updateRecord(String[] record, int i, String data) {
        record[i] = data = data.trim();
    }

    private void unpackDataFile() {
        File f = new File(this.dataPath);
        if (!f.exists()) {
            try {
                String line;
                URL url = this.parent.getClass().getResource("satlist.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                FileWriter fw = new FileWriter(f);
                while ((line = br.readLine()) != null) {
                    fw.write(line.trim() + this.parent.lineSep);
                }
                br.close();
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Complex computePos(double lat, double lng, double satLng) {
        double dlngr = (lng - satLng) * (Math.PI / 180);
        double az = Math.atan2(Math.sin(lat * (Math.PI / 180)), Math.tan(dlngr)) * 57.29577951308232;
        az = (270.0 - az) / 360.0;
        az -= Math.floor(az);
        az *= 360.0;
        double r1 = 6.6107;
        double clng = Math.cos(dlngr);
        double clat = Math.cos(lat * (Math.PI / 180));
        double v1 = r1 * clat * clng - 1.0;
        double v2 = r1 * Math.sqrt(1.0 - clat * clat * clng * clng);
        double el = Math.atan2(v1, v2) * 57.29577951308232;
        return new Complex(az, el);
    }

    private double computeSkew(double lat, double lng, double satLng) {
        double alat = Math.abs(lat);
        double dlngr = (satLng - lng) * (Math.PI / 180);
        double v = Math.atan2(Math.tan(alat * (Math.PI / 180)), Math.sin(dlngr)) * 57.29577951308232 - 90.0;
        return lat < 0.0 ? -v : v;
    }

    private void handleMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void toClipboard() {
        if (this.tsvBuffer != null) {
            StringSelection ss = new StringSelection(this.tsvBuffer.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.satDisplay = new JLabel();
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setToolTipText("Copy list to system clipboard");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SatList.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyMenuItem);
        this.setLayout(new BorderLayout());
        this.satDisplay.setText("jLabel1");
        this.satDisplay.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.satDisplay);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.toClipboard();
    }
}

