/***************************************************************************
 *   Copyright (C) 2016 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

final public class GeoMagConstants {
/*
  * Horiz: -180 to 180degrees longitude, steps of 5 degrees
  *
  * Vertical: -85 to 85 degrees latitude, steps of 5 degrees
  *
  * source: NOAA GEOMAG program data for years 2010 and 2020
  * 
  * python processor located at /netbackup/data/python_projects/geomagnetic_source
  *
  */
  
  final int gi = 5;
  final int year_a = 2010;
  final int year_b = 2020;
  
  final double mat_a[][] = {
    {  143.400,  137.700,  132.100,  126.567,  121.133,  115.800,  110.533,  105.383,  100.300,   95.317,   90.417,   85.567,   80.800,   76.100,   71.467,   66.867,   62.333,   57.833,   53.383,   48.950,   44.567,   40.200,   35.850,   31.533,   27.217,   22.917,   18.617,   14.317,   10.033,    5.733,    1.433,   -2.883,   -7.217,  -11.583,  -15.950,  -20.350,  -24.783,  -29.250,  -33.733,  -38.267,  -42.833,  -47.450,  -52.100,  -56.800,  -61.533,  -66.333,  -71.183,  -76.067,  -81.033,  -86.033,  -91.117,  -96.250, -101.450, -106.717, -112.067, -117.467, -122.967, -128.517, -134.150, -139.850, -145.617, -151.450, -157.333, -163.250, -169.217, -175.200,  178.800,  172.817,  166.850,  160.900,  155.017,  149.167 },
    {  131.200,  124.800,  118.700,  112.900,  107.383,  102.100,   97.050,   92.217,   87.550,   83.033,   78.650,   74.383,   70.217,   66.117,   62.083,   58.117,   54.183,   50.283,   46.417,   42.583,   38.767,   34.983,   31.200,   27.450,   23.700,   19.967,   16.233,   12.500,    8.783,    5.033,    1.283,   -2.500,   -6.317,  -10.167,  -14.067,  -18.000,  -22.000,  -26.050,  -30.167,  -34.350,  -38.583,  -42.883,  -47.233,  -51.667,  -56.133,  -60.683,  -65.283,  -69.950,  -74.700,  -79.517,  -84.417,  -89.417,  -94.533,  -99.767, -105.133, -110.650, -116.350, -122.250, -128.350, -134.683, -141.267, -148.083, -155.150, -162.433, -169.900, -177.500,  174.833,  167.150,  159.550,  152.117,  144.867,  137.900 },
    {  111.400,  105.117,   99.467,   94.350,   89.650,   85.317,   81.250,   77.433,   73.783,   70.283,   66.867,   63.517,   60.217,   56.933,   53.650,   50.367,   47.067,   43.733,   40.400,   37.033,   33.667,   30.300,   26.933,   23.567,   20.217,   16.900,   13.583,   10.300,    7.017,    3.733,    0.450,   -2.883,   -6.233,   -9.650,  -13.133,  -16.700,  -20.350,  -24.100,  -27.933,  -31.850,  -35.867,  -39.950,  -44.083,  -48.300,  -52.550,  -56.867,  -61.200,  -65.583,  -70.017,  -74.500,  -79.050,  -83.667,  -88.400,  -93.250,  -98.250, -103.467, -108.950, -114.750, -120.950, -127.650, -134.950, -142.950, -151.750, -161.350, -171.733,  177.333,  166.150,  155.150,  144.683,  135.017,  126.250,  118.400 },
    {   85.250,   81.017,   77.300,   74.000,   71.017,   68.267,   65.700,   63.250,   60.900,   58.600,   56.317,   54.000,   51.633,   49.200,   46.683,   44.050,   41.317,   38.483,   35.550,   32.517,   29.433,   26.300,   23.133,   19.983,   16.850,   13.767,   10.717,    7.733,    4.783,    1.883,   -1.000,   -3.900,   -6.833,   -9.833,  -12.950,  -16.167,  -19.517,  -23.017,  -26.633,  -30.383,  -34.233,  -38.167,  -42.167,  -46.200,  -50.267,  -54.350,  -58.417,  -62.467,  -66.500,  -70.533,  -74.550,  -78.583,  -82.650,  -86.767,  -91.000,  -95.383,  -99.983, -104.933, -110.367, -116.517, -123.733, -132.567, -143.783, -158.400, -176.967,  161.883,  141.783,  125.417,  112.967,  103.517,   96.150,   90.200 },
    {   61.900,   60.117,   58.433,   56.867,   55.383,   53.983,   52.650,   51.383,   50.117,   48.850,   47.533,   46.150,   44.633,   42.983,   41.150,   39.117,   36.883,   34.433,   31.800,   28.983,   26.033,   22.967,   19.850,   16.717,   13.600,   10.567,    7.617,    4.800,    2.083,   -0.517,   -3.050,   -5.550,   -8.067,  -10.667,  -13.383,  -16.250,  -19.317,  -22.567,  -26.017,  -29.617,  -33.350,  -37.167,  -41.050,  -44.950,  -48.817,  -52.650,  -56.400,  -60.067,  -63.633,  -67.100,  -70.467,  -73.717,  -76.883,  -79.950,  -82.950,  -85.883,  -88.767,  -91.633,  -94.533,  -97.533, -100.800, -104.717, -110.600, -127.417,  109.733,   83.983,   77.400,   73.550,   70.600,   68.100,   65.867,   63.817 },
    {   46.350,   45.850,   45.267,   44.633,   43.983,   43.350,   42.750,   42.167,   41.600,   41.033,   40.417,   39.733,   38.917,   37.900,   36.667,   35.167,   33.367,   31.267,   28.867,   26.200,   23.283,   20.167,   16.933,   13.667,   10.417,    7.250,    4.250,    1.467,   -1.133,   -3.517,   -5.733,   -7.850,   -9.933,  -12.083,  -14.383,  -16.867,  -19.583,  -22.583,  -25.817,  -29.267,  -32.883,  -36.600,  -40.350,  -44.100,  -47.767,  -51.317,  -54.717,  -57.950,  -60.983,  -63.817,  -66.400,  -68.733,  -70.783,  -72.517,  -73.883,  -74.800,  -75.100,  -74.583,  -72.833,  -69.083,  -61.900,  -48.567,  -26.050,    1.167,   21.600,   33.400,   39.900,   43.500,   45.450,   46.400,   46.733,   46.667 },
    {   36.583,   36.617,   36.483,   36.267,   35.983,   35.700,   35.417,   35.183,   34.967,   34.800,   34.617,   34.400,   34.067,   33.567,   32.833,   31.800,   30.400,   28.600,   26.417,   23.833,   20.900,   17.667,   14.233,   10.683,    7.167,    3.750,    0.567,   -2.317,   -4.883,   -7.117,   -9.083,  -10.833,  -12.483,  -14.133,  -15.917,  -17.933,  -20.233,  -22.867,  -25.833,  -29.083,  -32.533,  -36.117,  -39.717,  -43.283,  -46.717,  -49.967,  -52.983,  -55.733,  -58.183,  -60.283,  -62.000,  -63.300,  -64.117,  -64.350,  -63.867,  -62.500,  -59.967,  -55.933,  -49.933,  -41.550,  -30.633,  -17.883,   -4.933,    6.500,   15.617,   22.400,   27.317,   30.783,   33.167,   34.767,   35.767,   36.333 },
    {   30.100,   30.317,   30.383,   30.350,   30.233,   30.083,   29.950,   29.833,   29.783,   29.767,   29.783,   29.817,   29.800,   29.650,   29.300,   28.633,   27.583,   26.083,   24.100,   21.600,   18.633,   15.233,   11.533,    7.667,    3.800,    0.067,   -3.383,   -6.417,   -9.017,  -11.167,  -12.917,  -14.350,  -15.583,  -16.733,  -17.967,  -19.400,  -21.150,  -23.300,  -25.850,  -28.783,  -32.000,  -35.383,  -38.800,  -42.150,  -45.317,  -48.217,  -50.817,  -53.033,  -54.833,  -56.167,  -56.983,  -57.200,  -56.750,  -55.483,  -53.250,  -49.917,  -45.283,  -39.283,  -32.017,  -23.817,  -15.233,   -6.867,    0.767,    7.417,   13.000,   17.550,   21.183,   24.033,   26.183,   27.783,   28.900,   29.650 },
    {   25.417,   25.717,   25.867,   25.917,   25.900,   25.833,   25.733,   25.667,   25.633,   25.650,   25.717,   25.833,   25.933,   25.983,   25.867,   25.483,   24.733,   23.500,   21.700,   19.283,   16.283,   12.750,    8.783,    4.583,    0.350,   -3.683,   -7.367,  -10.533,  -13.167,  -15.233,  -16.817,  -18.000,  -18.917,  -19.650,  -20.350,  -21.167,  -22.250,  -23.733,  -25.700,  -28.150,  -30.983,  -34.083,  -37.250,  -40.333,  -43.183,  -45.717,  -47.850,  -49.517,  -50.650,  -51.200,  -51.117,  -50.317,  -48.717,  -46.200,  -42.683,  -38.150,  -32.683,  -26.517,  -20.033,  -13.617,   -7.550,   -2.000,    2.983,    7.383,   11.233,   14.550,   17.367,   19.700,   21.583,   23.050,   24.150,   24.917 },
    {   21.817,   22.133,   22.317,   22.417,   22.450,   22.433,   22.383,   22.333,   22.267,   22.250,   22.267,   22.350,   22.467,   22.550,   22.550,   22.333,   21.783,   20.750,   19.117,   16.800,   13.783,   10.133,    5.950,    1.500,   -2.983,   -7.250,  -11.050,  -14.250,  -16.817,  -18.783,  -20.233,  -21.250,  -21.967,  -22.433,  -22.733,  -22.967,  -23.300,  -23.950,  -25.083,  -26.817,  -29.100,  -31.767,  -34.583,  -37.367,  -39.900,  -42.050,  -43.733,  -44.850,  -45.367,  -45.217,  -44.367,  -42.750,  -40.333,  -37.033,  -32.917,  -28.067,  -22.783,  -17.400,  -12.250,   -7.533,   -3.300,    0.483,    3.917,    7.017,    9.833,   12.383,   14.633,   16.600,   18.233,   19.550,   20.567,   21.317 },
    {   18.900,   19.200,   19.400,   19.533,   19.617,   19.650,   19.650,   19.583,   19.517,   19.433,   19.383,   19.383,   19.400,   19.450,   19.450,   19.300,   18.850,   17.950,   16.433,   14.200,   11.183,    7.467,    3.167,   -1.433,   -6.050,  -10.350,  -14.133,  -17.250,  -19.667,  -21.467,  -22.767,  -23.667,  -24.250,  -24.533,  -24.533,  -24.267,  -23.867,  -23.550,  -23.633,  -24.367,  -25.817,  -27.883,  -30.283,  -32.750,  -35.017,  -36.883,  -38.233,  -38.950,  -39.000,  -38.350,  -37.017,  -34.950,  -32.150,  -28.633,  -24.500,  -19.983,  -15.383,  -11.017,   -7.117,   -3.733,   -0.800,    1.817,    4.233,    6.517,    8.683,   10.700,   12.550,   14.217,   15.650,   16.833,   17.750,   18.433 },
    {   16.500,   16.767,   16.950,   17.100,   17.217,   17.283,   17.317,   17.300,   17.217,   17.100,   16.983,   16.867,   16.800,   16.750,   16.700,   16.533,   16.117,   15.267,   13.817,   11.617,    8.617,    4.883,    0.550,   -4.067,   -8.650,  -12.867,  -16.500,  -19.417,  -21.633,  -23.233,  -24.333,  -25.067,  -25.467,  -25.533,  -25.200,  -24.450,  -23.300,  -22.017,  -20.950,  -20.500,  -20.933,  -22.233,  -24.150,  -26.350,  -28.467,  -30.233,  -31.450,  -32.017,  -31.900,  -31.083,  -29.617,  -27.517,  -24.783,  -21.483,  -17.750,  -13.817,  -10.017,   -6.583,   -3.700,   -1.317,    0.700,    2.500,    4.250,    5.983,    7.683,    9.350,   10.900,   12.333,   13.583,   14.650,   15.483,   16.083 },
    {   14.517,   14.733,   14.867,   15.000,   15.133,   15.250,   15.317,   15.333,   15.267,   15.133,   14.967,   14.783,   14.633,   14.517,   14.383,   14.183,   13.750,   12.900,   11.450,    9.250,    6.250,    2.517,   -1.767,   -6.300,  -10.750,  -14.767,  -18.183,  -20.850,  -22.817,  -24.150,  -24.983,  -25.417,  -25.500,  -25.183,  -24.417,  -23.100,  -21.300,  -19.200,  -17.183,  -15.717,  -15.150,  -15.633,  -16.983,  -18.900,  -20.933,  -22.767,  -24.083,  -24.767,  -24.767,  -24.100,  -22.833,  -21.000,  -18.633,  -15.800,  -12.617,   -9.317,   -6.233,   -3.567,   -1.450,    0.183,    1.533,    2.783,    4.067,    5.433,    6.833,    8.233,    9.583,   10.833,   11.950,   12.900,   13.650,   14.167 },
    {   12.900,   13.050,   13.133,   13.233,   13.350,   13.467,   13.567,   13.617,   13.583,   13.450,   13.267,   13.067,   12.867,   12.700,   12.533,   12.300,   11.817,   10.933,    9.433,    7.183,    4.167,    0.467,   -3.733,   -8.117,  -12.333,  -16.117,  -19.250,  -21.650,  -23.317,  -24.333,  -24.800,  -24.800,  -24.383,  -23.533,  -22.233,  -20.417,  -18.150,  -15.600,  -13.117,  -11.067,   -9.833,   -9.617,  -10.400,  -11.917,  -13.817,  -15.667,  -17.167,  -18.083,  -18.350,  -18.000,  -17.083,  -15.683,  -13.800,  -11.483,   -8.867,   -6.150,   -3.650,   -1.583,   -0.050,    1.067,    1.950,    2.800,    3.767,    4.883,    6.100,    7.317,    8.517,    9.650,   10.650,   11.517,   12.183,   12.633 },
    {   11.633,   11.700,   11.717,   11.767,   11.850,   11.967,   12.083,   12.133,   12.117,   12.017,   11.850,   11.650,   11.450,   11.283,   11.100,   10.833,   10.300,    9.333,    7.767,    5.450,    2.417,   -1.250,   -5.317,   -9.500,  -13.467,  -16.967,  -19.800,  -21.900,  -23.233,  -23.867,  -23.850,  -23.317,  -22.317,  -20.900,  -19.117,  -16.983,  -14.550,  -11.983,   -9.500,   -7.350,   -5.850,   -5.183,   -5.450,   -6.533,   -8.133,   -9.900,  -11.450,  -12.550,  -13.083,  -13.050,  -12.533,  -11.550,  -10.133,   -8.333,   -6.217,   -4.000,   -1.983,   -0.367,    0.750,    1.483,    2.033,    2.617,    3.383,    4.333,    5.417,    6.533,    7.650,    8.683,    9.633,   10.433,   11.050,   11.450 },
    {   10.683,   10.683,   10.633,   10.600,   10.650,   10.733,   10.850,   10.917,   10.917,   10.850,   10.700,   10.517,   10.350,   10.200,   10.017,    9.733,    9.133,    8.083,    6.400,    4.033,    0.967,   -2.633,   -6.567,  -10.517,  -14.217,  -17.417,  -19.950,  -21.700,  -22.650,  -22.850,  -22.333,  -21.233,  -19.683,  -17.817,  -15.733,  -13.500,  -11.183,   -8.867,   -6.650,   -4.683,   -3.167,   -2.300,   -2.200,   -2.883,   -4.150,   -5.700,   -7.200,   -8.350,   -9.050,   -9.267,   -9.050,   -8.450,   -7.450,   -6.067,   -4.400,   -2.617,   -0.983,    0.283,    1.100,    1.550,    1.867,    2.283,    2.900,    3.750,    4.750,    5.817,    6.883,    7.883,    8.817,    9.600,   10.183,   10.550 },
    {   10.000,    9.950,    9.833,    9.750,    9.733,    9.800,    9.917,   10.000,   10.017,    9.967,    9.850,    9.700,    9.550,    9.417,    9.233,    8.883,    8.217,    7.050,    5.267,    2.817,   -0.250,   -3.767,   -7.533,  -11.267,  -14.683,  -17.567,  -19.750,  -21.150,  -21.700,  -21.450,  -20.483,  -18.917,  -16.967,  -14.817,  -12.600,  -10.433,   -8.350,   -6.383,   -4.517,   -2.850,   -1.450,   -0.533,   -0.217,   -0.583,   -1.533,   -2.850,   -4.200,   -5.333,   -6.100,   -6.467,   -6.467,   -6.133,   -5.467,   -4.467,   -3.167,   -1.767,   -0.467,    0.500,    1.083,    1.350,    1.517,    1.783,    2.317,    3.100,    4.067,    5.100,    6.150,    7.167,    8.117,    8.917,    9.533,    9.883 },
    {    9.533,    9.467,    9.317,    9.200,    9.150,    9.200,    9.300,    9.400,    9.450,    9.417,    9.333,    9.200,    9.067,    8.917,    8.700,    8.267,    7.467,    6.183,    4.267,    1.750,   -1.300,   -4.733,   -8.317,  -11.800,  -14.933,  -17.500,  -19.333,  -20.350,  -20.517,  -19.883,  -18.533,  -16.667,  -14.483,  -12.200,   -9.983,   -7.950,   -6.133,   -4.483,   -2.950,   -1.550,   -0.333,    0.567,    1.000,    0.833,    0.117,   -0.967,   -2.167,   -3.217,   -3.983,   -4.433,   -4.567,   -4.433,   -4.033,   -3.317,   -2.367,   -1.283,   -0.300,    0.433,    0.800,    0.917,    0.967,    1.150,    1.600,    2.333,    3.267,    4.300,    5.383,    6.433,    7.450,    8.333,    9.000,    9.400 },
    {    9.217,    9.183,    9.050,    8.917,    8.867,    8.917,    9.033,    9.167,    9.250,    9.267,    9.183,    9.050,    8.900,    8.700,    8.383,    7.817,    6.867,    5.400,    3.367,    0.783,   -2.267,   -5.600,   -9.000,  -12.233,  -15.050,  -17.267,  -18.750,  -19.383,  -19.217,  -18.267,  -16.683,  -14.667,  -12.383,  -10.083,   -7.950,   -6.050,   -4.433,   -3.033,   -1.783,   -0.617,    0.450,    1.283,    1.750,    1.717,    1.183,    0.267,   -0.783,   -1.750,   -2.483,   -2.950,   -3.167,   -3.167,   -2.950,   -2.483,   -1.817,   -1.033,   -0.333,    0.150,    0.350,    0.333,    0.267,    0.367,    0.733,    1.417,    2.317,    3.367,    4.483,    5.617,    6.717,    7.717,    8.500,    9.000 },
    {    8.950,    9.033,    8.967,    8.883,    8.850,    8.933,    9.100,    9.283,    9.417,    9.467,    9.400,    9.267,    9.050,    8.767,    8.300,    7.550,    6.383,    4.733,    2.533,   -0.150,   -3.200,   -6.433,   -9.650,  -12.617,  -15.117,  -16.967,  -18.067,  -18.367,  -17.883,  -16.733,  -15.033,  -12.950,  -10.700,   -8.467,   -6.400,   -4.633,   -3.167,   -1.950,   -0.900,    0.100,    1.017,    1.783,    2.267,    2.300,    1.883,    1.117,    0.183,   -0.700,   -1.400,   -1.850,   -2.100,   -2.183,   -2.100,   -1.833,   -1.417,   -0.917,   -0.483,   -0.233,   -0.233,   -0.400,   -0.567,   -0.567,   -0.283,    0.317,    1.183,    2.217,    3.383,    4.617,    5.833,    6.983,    7.933,    8.600 },
    {    8.650,    8.933,    9.017,    9.033,    9.100,    9.250,    9.483,    9.733,    9.933,   10.017,    9.967,    9.800,    9.517,    9.083,    8.433,    7.467,    6.050,    4.150,    1.767,   -1.033,   -4.117,   -7.267,  -10.300,  -13.000,  -15.167,  -16.650,  -17.383,  -17.350,  -16.633,  -15.350,  -13.600,  -11.567,   -9.400,   -7.250,   -5.283,   -3.600,   -2.233,   -1.133,   -0.183,    0.667,    1.483,    2.183,    2.633,    2.717,    2.400,    1.733,    0.917,    0.117,   -0.517,   -0.950,   -1.217,   -1.350,   -1.383,   -1.283,   -1.083,   -0.833,   -0.667,   -0.667,   -0.867,   -1.200,   -1.517,   -1.650,   -1.483,   -0.967,   -0.167,    0.867,    2.083,    3.400,    4.750,    6.067,    7.200,    8.083 },
    {    8.250,    8.783,    9.100,    9.317,    9.533,    9.800,   10.133,   10.467,   10.717,   10.850,   10.817,   10.600,   10.233,    9.650,    8.783,    7.567,    5.883,    3.717,    1.083,   -1.883,   -5.017,   -8.133,  -11.000,  -13.433,  -15.267,  -16.383,  -16.767,  -16.467,  -15.567,  -14.183,  -12.450,  -10.483,   -8.417,   -6.367,   -4.483,   -2.867,   -1.550,   -0.483,    0.383,    1.167,    1.883,    2.517,    2.950,    3.067,    2.833,    2.283,    1.567,    0.850,    0.283,   -0.133,   -0.400,   -0.583,   -0.683,   -0.733,   -0.733,   -0.750,   -0.850,   -1.117,   -1.550,   -2.067,   -2.550,   -2.833,   -2.800,   -2.417,   -1.683,   -0.667,    0.567,    1.967,    3.450,    4.933,    6.283,    7.417 },
    {    7.683,    8.550,    9.183,    9.667,   10.100,   10.550,   11.000,   11.417,   11.733,   11.900,   11.850,   11.617,   11.133,   10.383,    9.317,    7.817,    5.850,    3.400,    0.500,   -2.667,   -5.917,   -9.017,  -11.767,  -13.950,  -15.467,  -16.267,  -16.333,  -15.800,  -14.750,  -13.317,  -11.617,   -9.717,   -7.750,   -5.783,   -3.950,   -2.367,   -1.050,    0.000,    0.850,    1.583,    2.250,    2.850,    3.267,    3.433,    3.267,    2.850,    2.250,    1.650,    1.133,    0.750,    0.467,    0.250,    0.050,   -0.150,   -0.350,   -0.617,   -1.000,   -1.550,   -2.233,   -2.983,   -3.667,   -4.133,   -4.250,   -3.983,   -3.333,   -2.350,   -1.083,    0.383,    1.983,    3.617,    5.183,    6.567 },
    {    7.000,    8.200,    9.183,   10.000,   10.717,   11.383,   12.000,   12.517,   12.900,   13.083,   13.050,   12.750,   12.167,   11.250,    9.967,    8.200,    5.933,    3.167,   -0.017,   -3.433,   -6.850,   -9.983,  -12.633,  -14.617,  -15.867,  -16.367,  -16.200,  -15.467,  -14.300,  -12.817,  -11.117,   -9.283,   -7.367,   -5.467,   -3.667,   -2.067,   -0.733,    0.333,    1.217,    1.950,    2.600,    3.183,    3.617,    3.833,    3.800,    3.517,    3.083,    2.617,    2.183,    1.817,    1.500,    1.217,    0.900,    0.533,    0.100,   -0.433,   -1.117,   -1.967,   -2.950,   -3.950,   -4.850,   -5.500,   -5.767,   -5.617,   -5.050,   -4.100,   -2.817,   -1.300,    0.400,    2.183,    3.933,    5.567 },
    {    6.233,    7.767,    9.117,   10.300,   11.333,   12.267,   13.050,   13.700,   14.150,   14.367,   14.317,   13.967,   13.267,   12.200,   10.683,    8.667,    6.067,    2.967,   -0.550,   -4.250,   -7.850,  -11.050,  -13.650,  -15.483,  -16.517,  -16.800,  -16.417,  -15.533,  -14.267,  -12.750,  -11.033,   -9.200,   -7.300,   -5.417,   -3.617,   -1.983,   -0.600,    0.550,    1.483,    2.267,    2.950,    3.550,    4.050,    4.367,    4.483,    4.400,    4.150,    3.833,    3.483,    3.150,    2.800,    2.417,    1.950,    1.383,    0.683,   -0.167,   -1.200,   -2.383,   -3.667,   -4.950,   -6.083,   -6.917,   -7.333,   -7.283,   -6.767,   -5.833,   -4.550,   -2.967,   -1.183,    0.717,    2.650,    4.500 },
    {    5.483,    7.333,    9.033,   10.567,   11.917,   13.117,   14.117,   14.917,   15.467,   15.717,   15.667,   15.250,   14.467,   13.217,   11.467,    9.133,    6.200,    2.717,   -1.183,   -5.200,   -9.033,  -12.333,  -14.917,  -16.633,  -17.517,  -17.633,  -17.100,  -16.100,  -14.733,  -13.150,  -11.383,   -9.517,   -7.600,   -5.683,   -3.833,   -2.150,   -0.667,    0.583,    1.633,    2.533,    3.317,    4.017,    4.617,    5.100,    5.417,    5.550,    5.533,    5.400,    5.150,    4.850,    4.433,    3.933,    3.267,    2.433,    1.417,    0.200,   -1.217,   -2.783,   -4.417,   -6.000,   -7.367,   -8.383,   -8.917,   -8.950,   -8.467,   -7.533,   -6.200,   -4.550,   -2.667,   -0.650,    1.433,    3.500 },
    {    4.867,    7.000,    9.000,   10.833,   12.500,   13.950,   15.183,   16.150,   16.817,   17.133,   17.100,   16.650,   15.750,   14.317,   12.300,    9.633,    6.267,    2.317,   -2.033,   -6.433,  -10.533,  -13.967,  -16.550,  -18.200,  -18.967,  -18.950,  -18.317,  -17.200,  -15.750,  -14.083,  -12.233,  -10.300,   -8.300,   -6.300,   -4.367,   -2.567,   -0.950,    0.467,    1.700,    2.767,    3.733,    4.600,    5.400,    6.100,    6.650,    7.067,    7.300,    7.350,    7.250,    6.967,    6.517,    5.833,    4.933,    3.783,    2.383,    0.733,   -1.150,   -3.167,   -5.200,   -7.100,   -8.700,   -9.867,  -10.500,  -10.583,  -10.100,   -9.117,   -7.717,   -5.983,   -4.000,   -1.850,    0.383,    2.650 },
    {    4.450,    6.817,    9.067,   11.167,   13.100,   14.800,   16.250,   17.400,   18.217,   18.667,   18.667,   18.200,   17.200,   15.567,   13.233,   10.117,    6.233,    1.683,   -3.250,   -8.150,  -12.567,  -16.167,  -18.767,  -20.350,  -21.000,  -20.883,  -20.133,  -18.917,  -17.367,  -15.567,  -13.617,  -11.550,   -9.433,   -7.300,   -5.233,   -3.267,   -1.467,    0.183,    1.667,    3.000,    4.233,    5.383,    6.450,    7.417,    8.283,    8.983,    9.483,    9.783,    9.833,    9.600,    9.083,    8.250,    7.067,    5.550,    3.667,    1.483,   -0.950,   -3.483,   -5.983,   -8.233,  -10.083,  -11.400,  -12.100,  -12.167,  -11.633,  -10.583,   -9.083,   -7.233,   -5.133,   -2.833,   -0.433,    2.017 },
    {    4.233,    6.817,    9.283,   11.633,   13.783,   15.717,   17.400,   18.767,   19.767,   20.350,   20.450,   20.000,   18.900,   17.033,   14.300,   10.600,    5.967,    0.583,   -5.133,  -10.667,  -15.483,  -19.250,  -21.850,  -23.333,  -23.850,  -23.567,  -22.683,  -21.317,  -19.617,  -17.667,  -15.550,  -13.317,  -11.017,   -8.717,   -6.450,   -4.267,   -2.183,   -0.233,    1.567,    3.267,    4.867,    6.367,    7.800,    9.117,   10.317,   11.350,   12.167,   12.717,   12.950,   12.817,   12.283,   11.283,    9.817,    7.850,    5.433,    2.600,   -0.500,   -3.667,   -6.700,   -9.367,  -11.483,  -12.917,  -13.650,  -13.683,  -13.067,  -11.900,  -10.283,   -8.300,   -6.033,   -3.583,   -1.017,    1.617 },
    {    4.233,    7.000,    9.683,   12.233,   14.617,   16.783,   18.683,   20.283,   21.500,   22.283,   22.517,   22.117,   20.917,   18.767,   15.500,   10.983,    5.267,   -1.333,   -8.183,  -14.550,  -19.800,  -23.667,  -26.150,  -27.433,  -27.700,  -27.167,  -26.050,  -24.467,  -22.550,  -20.383,  -18.033,  -15.583,  -13.050,  -10.500,   -7.967,   -5.467,   -3.067,   -0.750,    1.483,    3.600,    5.650,    7.583,    9.450,   11.183,   12.783,   14.183,   15.350,   16.200,   16.683,   16.700,   16.217,   15.133,   13.400,   10.983,    7.933,    4.350,    0.417,   -3.550,   -7.267,  -10.417,  -12.817,  -14.383,  -15.133,  -15.083,  -14.367,  -13.067,  -11.300,   -9.150,   -6.733,   -4.117,   -1.383,    1.417 },
    {    4.383,    7.333,   10.200,   12.967,   15.583,   18.000,   20.150,   22.017,   23.483,   24.500,   24.917,   24.567,   23.267,   20.750,   16.700,   10.917,    3.483,   -5.000,  -13.450,  -20.767,  -26.317,  -30.017,  -32.117,  -32.933,  -32.733,  -31.800,  -30.283,  -28.350,  -26.100,  -23.633,  -20.983,  -18.217,  -15.383,  -12.517,   -9.650,   -6.800,   -3.983,   -1.233,    1.450,    4.050,    6.583,    9.017,   11.350,   13.550,   15.600,   17.417,   18.983,   20.217,   21.033,   21.333,   21.033,   20.000,   18.133,   15.350,   11.667,    7.217,    2.267,   -2.717,   -7.300,  -11.083,  -13.867,  -15.617,  -16.383,  -16.267,  -15.433,  -14.000,  -12.100,   -9.800,   -7.233,   -4.467,   -1.567,    1.400 },
    {    4.683,    7.817,   10.883,   13.867,   16.717,   19.383,   21.817,   23.950,   25.717,   26.983,   27.583,   27.300,   25.800,   22.633,   17.233,    9.200,   -1.267,  -12.733,  -23.050,  -30.867,  -35.967,  -38.817,  -39.967,  -39.900,  -38.933,  -37.333,  -35.233,  -32.800,  -30.100,  -27.200,  -24.167,  -21.033,  -17.817,  -14.583,  -11.317,   -8.067,   -4.817,   -1.617,    1.533,    4.617,    7.633,   10.567,   13.400,   16.083,   18.600,   20.917,   22.967,   24.683,   25.967,   26.733,   26.850,   26.150,   24.467,   21.617,   17.517,   12.250,    6.150,   -0.150,   -5.917,  -10.633,  -14.017,  -16.100,  -17.017,  -16.933,  -16.050,  -14.550,  -12.533,  -10.150,   -7.467,   -4.583,   -1.567,    1.550 },
    {    5.367,    8.617,   11.850,   15.017,   18.083,   20.983,   23.683,   26.083,   28.100,   29.567,   30.250,   29.817,   27.650,   22.883,   14.283,    1.017,  -15.200,  -29.933,  -40.167,  -46.100,  -48.967,  -49.800,  -49.283,  -47.867,  -45.817,  -43.333,  -40.500,  -37.433,  -34.183,  -30.783,  -27.300,  -23.733,  -20.117,  -16.467,  -12.817,   -9.150,   -5.500,   -1.883,    1.700,    5.250,    8.717,   12.117,   15.400,   18.583,   21.600,   24.433,   27.033,   29.333,   31.267,   32.733,   33.600,   33.683,   32.767,   30.583,   26.883,   21.500,   14.617,    6.917,   -0.550,   -6.850,  -11.483,  -14.417,  -15.883,  -16.133,  -15.450,  -14.050,  -12.100,   -9.733,   -7.050,   -4.133,   -1.067,    2.133 },
    {    7.583,   10.817,   14.083,   17.317,   20.467,   23.500,   26.300,   28.800,   30.817,   32.100,   32.167,   30.150,   24.300,   11.317,  -11.783,  -37.317,  -53.600,  -61.317,  -64.267,  -64.650,  -63.567,  -61.567,  -59.000,  -56.017,  -52.750,  -49.283,  -45.650,  -41.900,  -38.067,  -34.167,  -30.217,  -26.233,  -22.217,  -18.200,  -14.167,  -10.150,   -6.133,   -2.150,    1.817,    5.717,    9.583,   13.383,   17.117,   20.733,   24.250,   27.617,   30.817,   33.800,   36.533,   38.917,   40.867,   42.250,   42.917,   42.617,   41.033,   37.833,   32.700,   25.600,   17.117,    8.500,    1.033,   -4.517,   -8.067,   -9.883,  -10.367,   -9.817,   -8.483,   -6.583,   -4.233,   -1.567,    1.333,    4.400 },
    {   26.250,   28.700,   31.500,   34.567,   37.883,   41.383,   45.083,   48.983,   53.233,   59.367, -122.817, -116.867, -112.367, -108.050, -103.750,  -99.467,  -95.167,  -90.850,  -86.517,  -82.150,  -77.800,  -73.417,  -69.017,  -64.617,  -60.217,  -55.800,  -51.383,  -46.967,  -42.533,  -38.117,  -33.700,  -29.300,  -24.900,  -20.500,  -16.133,  -11.767,   -7.417,   -3.100,    1.183,    5.450,    9.667,   13.850,   17.983,   22.067,   26.083,   30.033,   33.883,   37.633,   41.250,   44.733,   48.050,   51.150,   53.983,   56.517,   58.650,   60.283,   61.317,   61.567,   60.867,   59.000,   55.817,   51.300,   45.700,   39.600,   33.750,   28.833,   25.217,   22.950,   21.900,   21.900,   22.717,   24.217 },
  };
  
  final double mat_b[][] = {
    {  142.117,  136.467,  130.883,  125.383,  119.983,  114.667,  109.450,  104.317,   99.267,   94.300,   89.417,   84.600,   79.850,   75.167,   70.533,   65.967,   61.433,   56.950,   52.500,   48.083,   43.683,   39.333,   34.983,   30.667,   26.350,   22.050,   17.750,   13.450,    9.150,    4.850,    0.533,   -3.800,   -8.150,  -12.517,  -16.917,  -21.333,  -25.783,  -30.267,  -34.783,  -39.333,  -43.933,  -48.567,  -53.233,  -57.967,  -62.733,  -67.550,  -72.417,  -77.333,  -82.317,  -87.350,  -92.433,  -97.600, -102.817, -108.117, -113.467, -118.900, -124.400, -129.967, -135.617, -141.333, -147.100, -152.933, -158.817, -164.733, -170.683, -176.650,  177.367,  171.400,  165.450,  159.533,  153.667,  147.867 },
    {  129.950,  123.633,  117.633,  111.900,  106.433,  101.217,   96.217,   91.417,   86.783,   82.283,   77.933,   73.683,   69.517,   65.433,   61.417,   57.433,   53.517,   49.617,   45.767,   41.933,   38.117,   34.333,   30.550,   26.800,   23.050,   19.317,   15.600,   11.867,    8.133,    4.383,    0.617,   -3.183,   -7.017,  -10.900,  -14.833,  -18.817,  -22.850,  -26.950,  -31.117,  -35.333,  -39.617,  -43.967,  -48.367,  -52.833,  -57.367,  -61.950,  -66.583,  -71.300,  -76.083,  -80.933,  -85.867,  -90.900,  -96.050, -101.317, -106.717, -112.283, -118.017, -123.950, -130.100, -136.483, -143.100, -149.950, -157.033, -164.317, -171.783, -179.350,  173.017,  165.417,  157.900,  150.550,  143.417,  136.533 },
    {  110.650,  104.517,   98.950,   93.900,   89.250,   84.933,   80.900,   77.067,   73.417,   69.900,   66.467,   63.117,   59.800,   56.483,   53.200,   49.883,   46.567,   43.233,   39.883,   36.517,   33.150,   29.767,   26.400,   23.050,   19.717,   16.400,   13.117,    9.833,    6.567,    3.283,   -0.017,   -3.350,   -6.733,  -10.183,  -13.717,  -17.350,  -21.067,  -24.883,  -28.800,  -32.800,  -36.883,  -41.033,  -45.250,  -49.533,  -53.833,  -58.183,  -62.583,  -67.000,  -71.450,  -75.967,  -80.533,  -85.183,  -89.933,  -94.817,  -99.867, -105.150, -110.683, -116.567, -122.883, -129.700, -137.133, -145.267, -154.183, -163.883, -174.283,  174.867,  163.867,  153.133,  142.967,  133.600,  125.117,  117.483 },
    {   85.583,   81.367,   77.633,   74.300,   71.267,   68.467,   65.833,   63.350,   60.933,   58.567,   56.233,   53.867,   51.450,   48.967,   46.400,   43.733,   40.967,   38.083,   35.117,   32.067,   28.967,   25.817,   22.667,   19.517,   16.400,   13.333,   10.333,    7.383,    4.467,    1.600,   -1.267,   -4.167,   -7.117,  -10.167,  -13.350,  -16.650,  -20.117,  -23.717,  -27.467,  -31.333,  -35.283,  -39.333,  -43.417,  -47.533,  -51.650,  -55.767,  -59.867,  -63.933,  -67.967,  -71.983,  -76.000,  -80.033,  -84.083,  -88.217,  -92.467,  -96.883, -101.550, -106.600, -112.200, -118.583, -126.133, -135.417, -147.217, -162.417,  178.833,  158.367,  139.500,  124.233,  112.517,  103.467,   96.333,   90.500 },
    {   62.950,   61.067,   59.300,   57.633,   56.067,   54.567,   53.150,   51.767,   50.417,   49.050,   47.667,   46.183,   44.600,   42.883,   40.983,   38.883,   36.600,   34.100,   31.417,   28.567,   25.567,   22.483,   19.350,   16.217,   13.133,   10.133,    7.250,    4.500,    1.867,   -0.667,   -3.150,   -5.617,   -8.150,  -10.783,  -13.583,  -16.583,  -19.783,  -23.217,  -26.833,  -30.600,  -34.483,  -38.450,  -42.433,  -46.417,  -50.333,  -54.183,  -57.933,  -61.583,  -65.100,  -68.517,  -71.817,  -75.000,  -78.100,  -81.100,  -84.033,  -86.933,  -89.800,  -92.683,  -95.650,  -98.833, -102.433, -107.100, -114.983, -142.300,  109.250,   86.750,   79.600,   75.367,   72.183,   69.500,   67.117,   64.950 },
    {   47.433,   46.883,   46.233,   45.533,   44.800,   44.083,   43.383,   42.700,   42.050,   41.383,   40.667,   39.900,   38.983,   37.900,   36.583,   35.000,   33.133,   30.967,   28.500,   25.750,   22.783,   19.633,   16.367,   13.083,    9.850,    6.750,    3.833,    1.133,   -1.333,   -3.600,   -5.717,   -7.750,   -9.817,  -12.000,  -14.383,  -17.017,  -19.950,  -23.167,  -26.633,  -30.317,  -34.150,  -38.033,  -41.917,  -45.733,  -49.433,  -52.983,  -56.350,  -59.517,  -62.450,  -65.133,  -67.583,  -69.750,  -71.650,  -73.217,  -74.400,  -75.117,  -75.250,  -74.517,  -72.517,  -68.450,  -60.733,  -46.433,  -22.617,    4.867,   24.533,   35.667,   41.750,   45.100,   46.883,   47.717,   47.967,   47.833 },
    {   37.467,   37.483,   37.333,   37.083,   36.783,   36.433,   36.100,   35.767,   35.483,   35.200,   34.933,   34.617,   34.200,   33.617,   32.783,   31.667,   30.183,   28.300,   26.033,   23.350,   20.333,   17.017,   13.533,    9.967,    6.450,    3.100,    0.017,   -2.733,   -5.133,   -7.183,   -8.983,  -10.600,  -12.183,  -13.850,  -15.717,  -17.900,  -20.450,  -23.367,  -26.650,  -30.200,  -33.933,  -37.717,  -41.483,  -45.117,  -48.567,  -51.767,  -54.700,  -57.317,  -59.583,  -61.467,  -62.967,  -64.000,  -64.533,  -64.467,  -63.667,  -61.983,  -59.117,  -54.767,  -48.467,  -39.867,  -28.883,  -16.250,   -3.533,    7.683,   16.633,   23.367,   28.233,   31.683,   34.067,   35.667,   36.667,   37.233 },
    {   30.750,   31.000,   31.083,   31.033,   30.917,   30.767,   30.583,   30.400,   30.267,   30.167,   30.117,   30.067,   29.950,   29.717,   29.283,   28.533,   27.383,   25.783,   23.683,   21.067,   17.967,   14.467,   10.667,    6.750,    2.867,   -0.800,   -4.133,   -7.000,   -9.383,  -11.300,  -12.833,  -14.083,  -15.183,  -16.300,  -17.567,  -19.167,  -21.183,  -23.683,  -26.633,  -29.967,  -33.517,  -37.167,  -40.750,  -44.167,  -47.300,  -50.133,  -52.567,  -54.567,  -56.117,  -57.150,  -57.617,  -57.467,  -56.617,  -54.950,  -52.333,  -48.650,  -43.750,  -37.650,  -30.433,  -22.433,  -14.133,   -6.067,    1.350,    7.867,   13.400,   17.950,   21.617,   24.500,   26.700,   28.333,   29.483,   30.267 },
    {   25.850,   26.200,   26.400,   26.467,   26.467,   26.400,   26.283,   26.167,   26.067,   26.017,   26.017,   26.050,   26.100,   26.067,   25.867,   25.400,   24.533,   23.167,   21.233,   18.667,   15.500,   11.800,    7.700,    3.417,   -0.817,   -4.800,   -8.333,  -11.317,  -13.700,  -15.517,  -16.850,  -17.817,  -18.550,  -19.200,  -19.883,  -20.783,  -22.100,  -23.933,  -26.367,  -29.300,  -32.567,  -35.983,  -39.317,  -42.433,  -45.233,  -47.600,  -49.500,  -50.867,  -51.667,  -51.817,  -51.300,  -50.050,  -47.983,  -45.050,  -41.183,  -36.450,  -30.950,  -24.950,  -18.767,  -12.700,   -6.950,   -1.650,    3.167,    7.500,   11.333,   14.683,   17.533,   19.917,   21.850,   23.350,   24.483,   25.300 },
    {   22.083,   22.450,   22.700,   22.850,   22.917,   22.900,   22.833,   22.733,   22.617,   22.533,   22.500,   22.533,   22.583,   22.617,   22.533,   22.250,   21.583,   20.417,   18.617,   16.100,   12.867,    9.000,    4.667,    0.100,   -4.417,   -8.600,  -12.233,  -15.217,  -17.533,  -19.233,  -20.433,  -21.267,  -21.817,  -22.150,  -22.333,  -22.550,  -22.983,  -23.917,  -25.517,  -27.800,  -30.600,  -33.633,  -36.650,  -39.433,  -41.833,  -43.750,  -45.100,  -45.850,  -45.933,  -45.317,  -43.983,  -41.883,  -39.017,  -35.383,  -31.067,  -26.217,  -21.117,  -16.083,  -11.317,   -6.967,   -3.017,    0.583,    3.900,    6.967,    9.800,   12.367,   14.650,   16.633,   18.317,   19.683,   20.733,   21.517 },
    {   19.050,   19.417,   19.683,   19.867,   19.983,   20.033,   20.000,   19.917,   19.783,   19.650,   19.533,   19.467,   19.450,   19.450,   19.400,   19.183,   18.650,   17.600,   15.900,   13.433,   10.167,    6.183,    1.683,   -3.050,   -7.683,  -11.900,  -15.483,  -18.350,  -20.517,  -22.067,  -23.167,  -23.917,  -24.367,  -24.533,  -24.350,  -23.900,  -23.383,  -23.150,  -23.600,  -24.900,  -26.983,  -29.500,  -32.133,  -34.583,  -36.667,  -38.217,  -39.167,  -39.450,  -39.017,  -37.883,  -36.067,  -33.567,  -30.450,  -26.750,  -22.600,  -18.233,  -13.933,   -9.967,   -6.467,   -3.417,   -0.717,    1.750,    4.100,    6.367,    8.550,   10.583,   12.467,   14.150,   15.617,   16.833,   17.800,   18.517 },
    {   16.550,   16.900,   17.150,   17.350,   17.517,   17.617,   17.633,   17.550,   17.417,   17.233,   17.033,   16.883,   16.767,   16.683,   16.600,   16.383,   15.883,   14.917,   13.267,   10.800,    7.517,    3.467,   -1.100,   -5.850,  -10.433,  -14.533,  -17.950,  -20.600,  -22.550,  -23.917,  -24.850,  -25.467,  -25.800,  -25.733,  -25.183,  -24.067,  -22.567,  -21.100,  -20.217,  -20.300,  -21.417,  -23.283,  -25.533,  -27.767,  -29.700,  -31.133,  -31.933,  -32.050,  -31.450,  -30.183,  -28.300,  -25.883,  -22.983,  -19.633,  -16.000,  -12.300,   -8.817,   -5.767,   -3.250,   -1.167,    0.633,    2.333,    4.050,    5.767,    7.500,    9.183,   10.750,   12.200,   13.483,   14.567,   15.433,   16.083 },
    {   14.500,   14.800,   15.017,   15.217,   15.383,   15.517,   15.583,   15.550,   15.417,   15.200,   14.967,   14.717,   14.500,   14.350,   14.200,   13.967,   13.467,   12.483,   10.850,    8.383,    5.067,    1.017,   -3.533,   -8.183,  -12.600,  -16.483,  -19.633,  -22.033,  -23.717,  -24.817,  -25.500,  -25.833,  -25.833,  -25.367,  -24.300,  -22.533,  -20.200,  -17.733,  -15.717,  -14.667,  -14.767,  -15.900,  -17.717,  -19.783,  -21.750,  -23.300,  -24.250,  -24.517,  -24.083,  -23.017,  -21.450,  -19.417,  -16.983,  -14.183,  -11.133,   -8.067,   -5.267,   -2.950,   -1.150,    0.233,    1.400,    2.567,    3.817,    5.183,    6.617,    8.033,    9.383,   10.633,   11.767,   12.750,   13.517,   14.100 },
    {   12.850,   13.067,   13.233,   13.400,   13.567,   13.717,   13.817,   13.817,   13.700,   13.500,   13.217,   12.933,   12.667,   12.467,   12.267,   11.983,   11.450,   10.433,    8.750,    6.250,    2.917,   -1.100,   -5.533,  -10.017,  -14.183,  -17.767,  -20.633,  -22.733,  -24.100,  -24.867,  -25.150,  -25.017,  -24.483,  -23.467,  -21.817,  -19.517,  -16.717,  -13.767,  -11.200,   -9.450,   -8.783,   -9.200,  -10.483,  -12.283,  -14.233,  -15.950,  -17.167,  -17.733,  -17.633,  -16.967,  -15.850,  -14.333,  -12.450,  -10.217,   -7.717,   -5.200,   -2.933,   -1.133,    0.150,    1.033,    1.767,    2.533,    3.483,    4.617,    5.833,    7.083,    8.267,    9.400,   10.417,   11.300,   12.000,   12.517 },
    {   11.550,   11.683,   11.783,   11.900,   12.033,   12.183,   12.300,   12.317,   12.233,   12.050,   11.783,   11.483,   11.217,   10.983,   10.750,   10.433,    9.833,    8.750,    6.983,    4.433,    1.100,   -2.850,   -7.117,  -11.350,  -15.217,  -18.483,  -21.033,  -22.800,  -23.817,  -24.150,  -23.917,  -23.217,  -22.067,  -20.467,  -18.383,  -15.850,  -13.000,  -10.100,   -7.517,   -5.550,   -4.450,   -4.300,   -5.050,   -6.483,   -8.250,  -10.000,  -11.383,  -12.200,  -12.450,  -12.183,  -11.517,  -10.500,   -9.133,   -7.417,   -5.400,   -3.333,   -1.467,   -0.067,    0.850,    1.400,    1.817,    2.333,    3.083,    4.050,    5.133,    6.267,    7.350,    8.383,    9.333,   10.167,   10.817,   11.267 },
    {   10.550,   10.633,   10.667,   10.700,   10.800,   10.933,   11.033,   11.083,   11.033,   10.867,   10.617,   10.333,   10.067,    9.850,    9.617,    9.233,    8.550,    7.383,    5.533,    2.933,   -0.383,   -4.217,   -8.283,  -12.250,  -15.800,  -18.733,  -20.933,  -22.350,  -22.967,  -22.833,  -22.067,  -20.783,  -19.083,  -17.067,  -14.767,  -12.267,   -9.683,   -7.133,   -4.833,   -2.967,   -1.717,   -1.217,   -1.517,   -2.533,   -4.033,   -5.650,   -7.050,   -8.033,   -8.500,   -8.550,   -8.250,   -7.650,   -6.733,   -5.450,   -3.867,   -2.183,   -0.667,    0.450,    1.100,    1.400,    1.617,    1.967,    2.583,    3.433,    4.450,    5.517,    6.550,    7.550,    8.483,    9.283,    9.917,   10.333 },
    {    9.833,    9.867,    9.833,    9.817,    9.850,    9.967,   10.067,   10.133,   10.117,    9.967,    9.733,    9.483,    9.250,    9.033,    8.767,    8.317,    7.533,    6.233,    4.300,    1.650,   -1.617,   -5.300,   -9.150,  -12.817,  -16.050,  -18.650,  -20.500,  -21.517,  -21.733,  -21.167,  -19.917,  -18.183,  -16.100,  -13.833,  -11.533,   -9.233,   -7.000,   -4.900,   -2.967,   -1.317,   -0.067,    0.633,    0.633,   -0.033,   -1.233,   -2.667,   -4.000,   -5.000,   -5.600,   -5.850,   -5.817,   -5.550,   -4.983,   -4.083,   -2.867,   -1.533,   -0.317,    0.550,    1.000,    1.133,    1.217,    1.450,    1.983,    2.767,    3.733,    4.767,    5.800,    6.817,    7.750,    8.583,    9.233,    9.633 },
    {    9.333,    9.350,    9.283,    9.217,    9.217,    9.300,    9.417,    9.517,    9.517,    9.400,    9.200,    8.967,    8.733,    8.483,    8.150,    7.617,    6.700,    5.267,    3.217,    0.550,   -2.650,   -6.183,   -9.783,  -13.150,  -16.067,  -18.317,  -19.800,  -20.450,  -20.283,  -19.333,  -17.750,  -15.717,  -13.433,  -11.117,   -8.883,   -6.817,   -4.950,   -3.233,   -1.650,   -0.233,    0.950,    1.717,    1.917,    1.500,    0.550,   -0.700,   -1.917,   -2.883,   -3.517,   -3.867,   -4.017,   -3.967,   -3.683,   -3.100,   -2.217,   -1.200,   -0.283,    0.350,    0.633,    0.650,    0.633,    0.800,    1.250,    1.983,    2.917,    3.950,    5.017,    6.067,    7.067,    7.950,    8.650,    9.117 },
    {    8.950,    9.017,    8.967,    8.883,    8.883,    8.967,    9.100,    9.217,    9.267,    9.183,    9.000,    8.767,    8.517,    8.217,    7.783,    7.083,    6.000,    4.400,    2.233,   -0.467,   -3.583,   -6.933,  -10.283,  -13.350,  -15.933,  -17.817,  -18.933,  -19.233,  -18.733,  -17.533,  -15.750,  -13.583,  -11.250,   -8.950,   -6.850,   -5.000,   -3.400,   -1.983,   -0.683,    0.533,    1.600,    2.383,    2.700,    2.450,    1.683,    0.617,   -0.483,   -1.400,   -2.033,   -2.433,   -2.667,   -2.767,   -2.683,   -2.350,   -1.783,   -1.067,   -0.433,   -0.017,    0.100,    0.000,   -0.100,   -0.017,    0.367,    1.050,    1.950,    3.000,    4.100,    5.217,    6.317,    7.317,    8.117,    8.667 },
    {    8.617,    8.800,    8.817,    8.783,    8.800,    8.917,    9.100,    9.267,    9.350,    9.317,    9.167,    8.917,    8.617,    8.217,    7.633,    6.750,    5.433,    3.633,    1.333,   -1.400,   -4.467,   -7.650,  -10.733,  -13.500,  -15.700,  -17.233,  -17.983,  -17.950,  -17.200,  -15.833,  -13.983,  -11.817,   -9.533,   -7.317,   -5.317,   -3.633,   -2.233,   -1.033,    0.050,    1.100,    2.067,    2.833,    3.200,    3.067,    2.450,    1.517,    0.517,   -0.317,   -0.933,   -1.350,   -1.633,   -1.817,   -1.883,   -1.750,   -1.450,   -1.033,   -0.667,   -0.483,   -0.550,   -0.767,   -0.967,   -0.967,   -0.683,   -0.067,    0.800,    1.850,    3.000,    4.217,    5.433,    6.550,    7.500,    8.200 },
    {    8.250,    8.600,    8.767,    8.850,    8.950,    9.117,    9.367,    9.600,    9.767,    9.783,    9.650,    9.383,    9.017,    8.483,    7.700,    6.583,    5.017,    3.000,    0.533,   -2.283,   -5.300,   -8.350,  -11.183,  -13.617,  -15.467,  -16.600,  -17.017,  -16.717,  -15.783,  -14.333,  -12.483,  -10.400,   -8.200,   -6.100,   -4.200,   -2.617,   -1.333,   -0.283,    0.667,    1.583,    2.450,    3.167,    3.550,    3.500,    3.000,    2.183,    1.283,    0.517,   -0.067,   -0.467,   -0.767,   -1.000,   -1.167,   -1.217,   -1.150,   -1.000,   -0.917,   -1.000,   -1.250,   -1.633,   -1.950,   -2.067,   -1.867,   -1.350,   -0.533,    0.500,    1.700,    3.000,    4.333,    5.617,    6.750,    7.633 },
    {    7.767,    8.367,    8.733,    9.000,    9.233,    9.533,    9.867,   10.200,   10.433,   10.500,   10.400,   10.117,    9.650,    8.967,    7.983,    6.600,    4.783,    2.500,   -0.167,   -3.100,   -6.117,   -9.033,  -11.650,  -13.767,  -15.250,  -16.033,  -16.133,  -15.583,  -14.533,  -13.067,  -11.283,   -9.300,   -7.217,   -5.217,   -3.400,   -1.867,   -0.650,    0.333,    1.183,    2.000,    2.800,    3.450,    3.850,    3.867,    3.467,    2.767,    1.983,    1.267,    0.733,    0.333,    0.033,   -0.250,   -0.500,   -0.683,   -0.833,   -0.967,   -1.167,   -1.500,   -1.983,   -2.533,   -3.000,   -3.267,   -3.183,   -2.767,   -2.033,   -1.017,    0.217,    1.600,    3.050,    4.483,    5.800,    6.917 },
    {    7.150,    8.017,    8.667,    9.167,    9.617,   10.083,   10.550,   10.967,   11.283,   11.400,   11.317,   11.017,   10.467,    9.617,    8.417,    6.783,    4.683,    2.133,   -0.750,   -3.833,   -6.900,   -9.750,  -12.167,  -14.000,  -15.150,  -15.617,  -15.433,  -14.717,  -13.567,  -12.100,  -10.383,   -8.500,   -6.533,   -4.600,   -2.833,   -1.333,   -0.117,    0.833,    1.650,    2.400,    3.117,    3.733,    4.150,    4.217,    3.950,    3.383,    2.717,    2.100,    1.583,    1.200,    0.883,    0.567,    0.217,   -0.117,   -0.483,   -0.883,   -1.367,   -2.000,   -2.717,   -3.483,   -4.133,   -4.550,   -4.617,   -4.300,   -3.633,   -2.650,   -1.400,    0.033,    1.600,    3.167,    4.683,    6.033 },
    {    6.383,    7.550,    8.517,    9.317,   10.033,   10.700,   11.317,   11.850,   12.233,   12.417,   12.350,   12.000,   11.367,   10.367,    8.967,    7.100,    4.717,    1.900,   -1.250,   -4.517,   -7.667,  -10.483,  -12.750,  -14.367,  -15.250,  -15.450,  -15.050,  -14.183,  -12.967,  -11.483,   -9.817,   -8.000,   -6.100,   -4.233,   -2.483,   -0.983,    0.250,    1.233,    2.033,    2.767,    3.450,    4.050,    4.483,    4.650,    4.517,    4.133,    3.617,    3.083,    2.633,    2.250,    1.883,    1.500,    1.050,    0.533,   -0.050,   -0.733,   -1.533,   -2.467,   -3.467,   -4.467,   -5.317,   -5.900,   -6.100,   -5.900,   -5.300,   -4.333,   -3.067,   -1.567,    0.067,    1.767,    3.450,    5.000 },
    {    5.550,    7.017,    8.300,    9.417,   10.433,   11.333,   12.133,   12.783,   13.250,   13.467,   13.400,   13.033,   12.300,   11.167,    9.567,    7.467,    4.817,    1.717,   -1.700,   -5.183,   -8.467,  -11.283,  -13.483,  -14.917,  -15.617,  -15.617,  -15.050,  -14.067,  -12.783,  -11.283,   -9.617,   -7.817,   -5.967,   -4.117,   -2.367,   -0.833,    0.450,    1.500,    2.350,    3.117,    3.800,    4.433,    4.917,    5.217,    5.250,    5.083,    4.750,    4.350,    3.950,    3.567,    3.133,    2.650,    2.050,    1.333,    0.483,   -0.517,   -1.650,   -2.917,   -4.233,   -5.483,   -6.550,   -7.300,   -7.633,   -7.517,   -6.950,   -6.000,   -4.700,   -3.167,   -1.450,    0.367,    2.183,    3.933 },
    {    4.750,    6.467,    8.050,    9.483,   10.783,   11.933,   12.933,   13.717,   14.267,   14.533,   14.467,   14.050,   13.233,   11.967,   10.183,    7.833,    4.917,    1.500,   -2.200,   -5.933,   -9.367,  -12.250,  -14.400,  -15.750,  -16.317,  -16.183,  -15.517,  -14.433,  -13.083,  -11.517,   -9.817,   -8.000,   -6.133,   -4.267,   -2.500,   -0.900,    0.483,    1.617,    2.583,    3.433,    4.200,    4.917,    5.517,    5.983,    6.250,    6.300,    6.200,    5.967,    5.650,    5.250,    4.750,    4.117,    3.317,    2.333,    1.167,   -0.200,   -1.717,   -3.367,   -5.017,   -6.550,   -7.833,   -8.733,   -9.167,   -9.100,   -8.567,   -7.583,   -6.250,   -4.650,   -2.867,   -0.950,    0.983,    2.917 },
    {    4.067,    6.017,    7.850,    9.550,   11.100,   12.483,   13.667,   14.600,   15.250,   15.583,   15.533,   15.083,   14.183,   12.767,   10.767,    8.150,    4.917,    1.167,   -2.883,   -6.883,  -10.533,  -13.500,  -15.667,  -16.950,  -17.433,  -17.233,  -16.467,  -15.317,  -13.867,  -12.233,  -10.450,   -8.583,   -6.650,   -4.733,   -2.900,   -1.200,    0.300,    1.600,    2.733,    3.733,    4.683,    5.550,    6.350,    7.033,    7.550,    7.883,    8.017,    7.983,    7.767,    7.367,    6.783,    5.983,    4.933,    3.617,    2.067,    0.267,   -1.717,   -3.800,   -5.833,   -7.667,   -9.167,  -10.200,  -10.700,  -10.650,  -10.083,   -9.050,   -7.650,   -5.983,   -4.100,   -2.083,   -0.017,    2.050 },
    {    3.583,    5.700,    7.750,    9.667,   11.433,   13.017,   14.367,   15.450,   16.217,   16.617,   16.617,   16.150,   15.150,   13.567,   11.333,    8.383,    4.750,    0.567,   -3.883,   -8.233,  -12.100,  -15.200,  -17.383,  -18.650,  -19.083,  -18.800,  -17.967,  -16.733,  -15.200,  -13.467,  -11.567,   -9.600,   -7.567,   -5.550,   -3.600,   -1.767,   -0.083,    1.433,    2.800,    4.067,    5.267,    6.400,    7.450,    8.417,    9.233,    9.867,   10.283,   10.450,   10.367,   10.000,    9.333,    8.333,    7.000,    5.300,    3.250,    0.917,   -1.600,   -4.183,   -6.650,   -8.817,  -10.517,  -11.667,  -12.183,  -12.117,  -11.483,  -10.367,   -8.883,   -7.100,   -5.117,   -3.000,   -0.817,    1.400 },
    {    3.300,    5.567,    7.767,    9.850,   11.800,   13.533,   15.050,   16.283,   17.183,   17.683,   17.717,   17.250,   16.150,   14.383,   11.817,    8.450,    4.283,   -0.467,   -5.450,  -10.233,  -14.367,  -17.600,  -19.800,  -21.017,  -21.367,  -21.000,  -20.083,  -18.750,  -17.083,  -15.217,  -13.200,  -11.067,   -8.900,   -6.733,   -4.617,   -2.567,   -0.650,    1.167,    2.867,    4.483,    6.017,    7.483,    8.883,   10.183,   11.333,   12.300,   13.017,   13.433,   13.517,   13.217,   12.500,   11.317,    9.650,    7.500,    4.883,    1.917,   -1.267,   -4.467,   -7.417,   -9.950,  -11.867,  -13.083,  -13.617,  -13.483,  -12.750,  -11.533,   -9.933,   -8.033,   -5.917,   -3.683,   -1.367,    0.967 },
    {    3.167,    5.583,    7.917,   10.133,   12.217,   14.100,   15.750,   17.117,   18.150,   18.750,   18.850,   18.350,   17.150,   15.117,   12.133,    8.150,    3.250,   -2.283,   -7.983,  -13.267,  -17.683,  -20.983,  -23.133,  -24.233,  -24.450,  -23.933,  -22.867,  -21.367,  -19.550,  -17.500,  -15.300,  -12.983,  -10.617,   -8.233,   -5.867,   -3.550,   -1.300,    0.883,    2.983,    5.000,    6.967,    8.867,   10.667,   12.350,   13.883,   15.200,   16.250,   16.967,   17.283,   17.133,   16.433,   15.117,   13.150,   10.517,    7.250,    3.500,   -0.500,   -4.433,   -8.000,  -10.933,  -13.083,  -14.400,  -14.917,  -14.700,  -13.867,  -12.533,  -10.800,   -8.783,   -6.550,   -4.200,   -1.750,    0.717 },
    {    3.117,    5.650,    8.117,   10.467,   12.667,   14.683,   16.467,   17.967,   19.100,   19.783,   19.900,   19.350,   17.933,   15.500,   11.867,    6.983,    1.000,   -5.633,  -12.200,  -18.017,  -22.600,  -25.817,  -27.733,  -28.550,  -28.467,  -27.667,  -26.350,  -24.600,  -22.533,  -20.250,  -17.800,  -15.233,  -12.600,   -9.933,   -7.250,   -4.583,   -1.933,    0.667,    3.217,    5.700,    8.133,   10.500,   12.750,   14.883,   16.833,   18.567,   20.017,   21.100,   21.733,   21.850,   21.300,   20.017,   17.867,   14.800,   10.867,    6.233,    1.233,   -3.667,   -8.017,  -11.500,  -13.983,  -15.433,  -15.983,  -15.717,  -14.800,  -13.367,  -11.533,   -9.417,   -7.067,   -4.600,   -2.050,    0.550 },
    {    3.050,    5.700,    8.267,   10.733,   13.050,   15.183,   17.083,   18.667,   19.867,   20.550,   20.600,   19.817,   17.950,   14.767,   10.017,    3.650,   -3.983,  -12.033,  -19.450,  -25.467,  -29.767,  -32.450,  -33.767,  -34.000,  -33.383,  -32.133,  -30.383,  -28.267,  -25.867,  -23.250,  -20.467,  -17.583,  -14.600,  -11.583,   -8.533,   -5.467,   -2.417,    0.633,    3.633,    6.600,    9.517,   12.333,   15.067,   17.650,   20.083,   22.283,   24.200,   25.767,   26.883,   27.467,   27.333,   26.367,   24.350,   21.167,   16.750,   11.233,    5.067,   -1.100,   -6.583,  -10.933,  -13.983,  -15.783,  -16.500,  -16.317,  -15.417,  -13.967,  -12.100,   -9.917,   -7.517,   -4.950,   -2.317,    0.367 },
    {    2.900,    5.617,    8.250,   10.783,   13.167,   15.350,   17.250,   18.817,   19.883,   20.350,   19.967,   18.450,   15.433,   10.517,    3.450,   -5.533,  -15.350,  -24.433,  -31.633,  -36.600,  -39.567,  -40.933,  -41.083,  -40.333,  -38.917,  -36.967,  -34.633,  -32.017,  -29.150,  -26.117,  -22.950,  -19.683,  -16.333,  -12.933,   -9.500,   -6.050,   -2.583,    0.867,    4.300,    7.700,   11.033,   14.317,   17.500,   20.567,   23.483,   26.200,   28.683,   30.867,   32.667,   33.967,   34.633,   34.483,   33.283,   30.767,   26.700,   20.983,   13.883,    6.167,   -1.133,   -7.150,  -11.500,  -14.233,  -15.567,  -15.817,  -15.200,  -13.933,  -12.183,  -10.083,   -7.733,   -5.183,   -2.533,    0.183 },
    {    2.833,    5.383,    7.867,   10.233,   12.400,   14.283,   15.783,   16.733,   16.933,   16.067,   13.700,    9.250,    2.117,   -7.833,  -19.633,  -31.000,  -40.033,  -46.117,  -49.650,  -51.250,  -51.450,  -50.650,  -49.100,  -47.033,  -44.550,  -41.750,  -38.700,  -35.467,  -32.083,  -28.583,  -25.000,  -21.333,  -17.600,  -13.850,  -10.050,   -6.233,   -2.417,    1.383,    5.183,    8.967,   12.700,   16.383,   20.000,   23.517,   26.950,   30.233,   33.367,   36.283,   38.933,   41.250,   43.133,   44.450,   45.033,   44.617,   42.900,   39.483,   34.050,   26.533,   17.567,    8.483,    0.650,   -5.167,   -8.917,  -10.967,  -11.667,  -11.367,  -10.333,   -8.783,   -6.833,   -4.617,   -2.217,    0.283 },
    {    6.333,    6.233,    5.867,    4.883,    2.750,   -1.217,   -8.050,  -18.817,  -33.450,  -49.100,  -61.850,  -70.267,  -75.017,  -77.200,  -77.667,  -76.967,  -75.450,  -73.350,  -70.817,  -67.950,  -64.833,  -61.517,  -58.033,  -54.417,  -50.700,  -46.883,  -43.000,  -39.050,  -35.050,  -31.017,  -26.933,  -22.833,  -18.700,  -14.550,  -10.400,   -6.233,   -2.067,    2.100,    6.267,   10.400,   14.533,   18.633,   22.717,   26.750,   30.750,   34.683,   38.550,   42.350,   46.050,   49.650,   53.100,   56.400,   59.483,   62.317,   64.850,   66.950,   68.550,   69.450,   69.450,   68.250,   65.450,   60.650,   53.617,   44.650,   34.833,   25.750,   18.483,   13.283,    9.917,    7.917,    6.883,    6.450 },
  };
  
};
