/***************************************************************************
 *   Copyright (C) 2016 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

import java.awt.*;
import java.util.*;
import javax.swing.*;

final public class ProgramValues {
    
    
    public Dimension db_ProgWindowSize;
    public Point db_ProgWindowLocation;
    public int db_ProgWindowState;
    public String db_zip = "10001";
    public boolean db_directPosEntryMode = false;
    public double db_posLat = 0;
    public double db_posLng = 0;
    
    public ProgramValues() {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        db_ProgWindowSize = new Dimension(ss.width*2/3,ss.height*2/3);
        db_ProgWindowLocation =  new Point(ss.width/6,ss.height/6);
        db_ProgWindowState = Frame.NORMAL;
    }
    
    public void writeValues(String path) {
        DataFileManager.writeObjectToFile(path,this,"db_");
    }
    
    public void readValues(String path) {
        DataFileManager.readObjectFromFile(path,this,"db_");
    }
    /*
    public void debugDump() {
        try {
            Field[] fields = ProgramValues.class.getDeclaredFields();
            for(int i = 0;i < fields.length;i++) {
                Field f = fields[i];
                if((f.getModifiers() & Modifier.PUBLIC) != 0) {
                    String name = f.getName();
                    String type = f.getType().toString();
                    //System.out.println("debug:" + name + ":" + type + " = " + f.get(this));
     
                }
            }
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }*/
}

