/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 *
 * @author  lutusp
 */

import java.io.*;
import java.net.*;
import java.awt.*;

final public class SatFinderHelp extends javax.swing.JPanel {
    
    SatFinder parent;
    String helpUrl = "SatFinderHelp.txt";
    /** Creates new form SatFinderHelp */
    public SatFinderHelp(SatFinder p) {
        parent = p;
        initComponents();
        readHelp();
    }
    
    private void readHelp() {
        try {
            URL url = parent.getClass().getResource(helpUrl);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer sb = new StringBuffer();
            String line;
            while((line = br.readLine()) != null) {
                sb.append(line + parent.lineSep);
                //System.out.println(line);
            }
            br.close();
            String data = sb.toString();
            data = data.replaceAll("\\[userDir\\]",parent.userDir);
            data = data.replaceAll("\\[VersionBuildString\\]","Satellite Finder" + ", Version " + parent.VERSION + ", Build " + parent.programBuild);
            helpTextArea.setText(data);
            helpTextArea.setCaretPosition(0);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        helpTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        helpTextArea.setBackground(new java.awt.Color(255, 255, 255));
        helpTextArea.setFont(new java.awt.Font("Monospaced", 0, 12));
        helpTextArea.setLineWrap(true);
        helpTextArea.setWrapStyleWord(true);
        helpTextArea.setMargin(new java.awt.Insets(4, 4, 4, 4));
        jScrollPane1.setViewportView(helpTextArea);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea helpTextArea;
    // End of variables declaration//GEN-END:variables
    
}
